/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rlang;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class RPkgNameValidator
implements IValidator<String> {
    private static final String TRANSLATION_PREFIX = "Translation-";
    private static final int TRANSLATION_PREFIX_LENGTH = 12;
    private boolean required = true;
    private int errorVersion = 14;

    public void setRequired(boolean isRequired) {
        this.required = isRequired;
    }

    public void setBackwardCompatible(int errorVersion) {
        this.errorVersion = errorVersion;
    }

    public IStatus validate(String name) {
        if (name == null || name.isEmpty()) {
            if (this.required) {
                return ValidationStatus.error((String)Messages.RPkgName_Validation_error_Empty_message);
            }
            return ValidationStatus.ok();
        }
        char c = name.charAt(0);
        if (!Character.isLetter(c)) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.RPkgName_Validation_error_InvalidFirstChar_message, (Object)Character.valueOf(c)));
        }
        if (c > '\u007f') {
            return ValidationStatus.error((String)NLS.bind((String)Messages.RPkgName_Validation_error_InvalidNoAscii_message, (Object)Character.valueOf(c)));
        }
        boolean translation = name.startsWith(TRANSLATION_PREFIX);
        int i = translation ? 12 : 1;
        while (i < name.length()) {
            char c2 = name.charAt(i);
            if (!Character.isLetterOrDigit(c2) && c2 != '.') {
                return ValidationStatus.error((String)NLS.bind((String)Messages.RPkgName_Validation_error_InvalidChar_message, (Object)Character.valueOf(c2)));
            }
            if (c2 > '\u007f') {
                return ValidationStatus.error((String)NLS.bind((String)Messages.RPkgName_Validation_error_InvalidNoAscii_message, (Object)Character.valueOf(c2)));
            }
            ++i;
        }
        char c3 = name.charAt(name.length() - 1);
        if (c3 == '.') {
            return ValidationStatus.error((String)NLS.bind((String)Messages.RPkgName_Validation_error_InvalidDotAtEnd_message, (Object)Character.valueOf(c3)));
        }
        if (translation) {
            if (name.length() == 12) {
                return ValidationStatus.error((String)Messages.RPkgName_Validation_error_IncompleteTranslation_message);
            }
        } else if (name.length() == 1) {
            return this.errorVersion >= 14 ? ValidationStatus.error((String)Messages.RPkgName_Validation_error_InvalidSingleChar_message) : ValidationStatus.warning((String)Messages.RPkgName_Validation_error_InvalidSingleChar_message);
        }
        return ValidationStatus.ok();
    }
}

