/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.util.List;
import org.eclipse.statet.internal.r.core.sourcemodel.BuildSourceFrame;
import org.eclipse.statet.internal.r.core.sourcemodel.BuildSourceFrameElement;
import org.eclipse.statet.internal.r.core.sourcemodel.RSourceModel;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.r.core.model.RElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RFrame;
import org.eclipse.statet.r.core.model.RLangSourceElement;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;

@NonNullByDefault
final class RoxygenRCodeElement
implements BuildSourceFrameElement {
    private final RLangSourceElement parent;
    private final int number;
    private final RAstNode sourceNode;
    private final List<? extends RLangSourceElement> sourceChildrenProtected = RSourceModel.NO_R_SOURCE_CHILDREN;
    private BuildSourceFrame envir;

    public RoxygenRCodeElement(RLangSourceElement parent, int number, BuildSourceFrame envir, RAstNode node) {
        this.parent = parent;
        this.number = number;
        this.sourceNode = node;
    }

    @Override
    public void setSourceChildren(List<? extends RLangSourceElement> children) {
    }

    @Override
    public BuildSourceFrame getBuildFrame() {
        return this.envir;
    }

    public String getModelTypeId() {
        return "R";
    }

    public int getElementType() {
        return 644;
    }

    @Override
    public @Nullable RElementName getElementName() {
        return null;
    }

    public String getId() {
        return String.valueOf(Integer.toHexString(644)) + ":#" + this.number;
    }

    public boolean exists() {
        return this.parent.exists();
    }

    public boolean isReadOnly() {
        return this.parent.isReadOnly();
    }

    @Override
    public @Nullable RElement<?> getModelParent() {
        return null;
    }

    @Override
    public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
        return false;
    }

    @Override
    public List<? extends RLangSourceElement> getModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
        return RSourceModel.NO_R_SOURCE_CHILDREN;
    }

    public RLangSourceElement getSourceParent() {
        return this.parent;
    }

    @Override
    public boolean hasSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
        return LtkModelUtils.hasChildren(this.sourceChildrenProtected, filter);
    }

    @Override
    public List<? extends RLangSourceElement> getSourceChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
        return LtkModelUtils.getChildren(this.sourceChildrenProtected, filter);
    }

    @Override
    public RSourceUnit getSourceUnit() {
        return this.parent.getSourceUnit();
    }

    public TextRegion getSourceRange() {
        return this.sourceNode;
    }

    public @Nullable TextRegion getNameSourceRange() {
        return null;
    }

    public @Nullable TextRegion getDocumentationRange() {
        return null;
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == AstNode.class) {
            return (T)((Object)this.sourceNode);
        }
        if (adapterType == RFrame.class) {
            return (T)this.envir;
        }
        return null;
    }

    public int hashCode() {
        return this.parent.hashCode() + this.number;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RoxygenRCodeElement) {
            RoxygenRCodeElement other = (RoxygenRCodeElement)obj;
            return (other.getElementType() & 0xFFF) == 644 && this.number == other.number && this.parent.equals(other.parent);
        }
        return false;
    }
}

