/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.emf.ui.forms;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.statet.ecommons.emf.core.databinding.IEMFEditContext;
import org.eclipse.statet.ecommons.emf.ui.databinding.IDataBindingPart;
import org.eclipse.statet.ecommons.emf.ui.forms.EFLayoutUtil;
import org.eclipse.statet.ecommons.emf.ui.forms.EFToolkit;
import org.eclipse.statet.ecommons.emf.ui.forms.IEFFormPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class EFFormSection
extends SectionPart
implements IAdaptable,
IDataBindingPart {
    public static final int TITLE_STYLE = 256;
    public static final int TITLE_DESCRIPTION_STYLE = 384;
    public static final int EXPANDABLE_STYLE = 2;
    private final IEFFormPage page;

    public EFFormSection(IEFFormPage page, Composite parent, String title, String description) {
        this(page, parent, description != null ? 384 : 256);
        Section section = this.getSection();
        section.setText(title);
        if (description != null) {
            section.setDescription(description);
        }
    }

    public EFFormSection(IEFFormPage page, Composite parent, int style) {
        super(parent, (FormToolkit)page.getToolkit(), style);
        this.page = page;
        Section section = this.getSection();
        section.clientVerticalSpacing = 6;
        section.setData("part", (Object)this);
    }

    public IEFFormPage getPage() {
        return this.page;
    }

    protected void createClient() {
        Section section = this.getSection();
        EFToolkit toolkit = this.page.getToolkit();
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout(this.createClientLayout());
        section.setClient((Control)composite);
        this.createContent(composite);
    }

    protected Layout createClientLayout() {
        GridLayout layout = EFLayoutUtil.createSectionPropGridLayout();
        return layout;
    }

    protected abstract void createContent(Composite var1);

    public void addBindings(IEMFEditContext context) {
    }

    protected void expansionStateChanged(boolean expanded) {
        this.getPage().reflow(false);
    }

    public <T> T getAdapter(Class<T> adapterType) {
        return null;
    }
}

