/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;

public class TextHandlerUtil {
    private static final boolean IS_MAC;
    private static final boolean IS_GTK;
    private static final boolean IS_MOTIF;

    static {
        String platform = SWT.getPlatform();
        IS_MAC = "carbon".equals(platform) || "cocoa".equals(platform);
        IS_GTK = "gtk".equals(platform);
        IS_MOTIF = "motif".equals(platform);
    }

    public static void disable(StyledText widget, String commandId) {
        if (commandId.equals("org.eclipse.ui.edit.text.deleteNext")) {
            widget.setKeyBinding(127, 0);
            if (IS_MAC) {
                widget.setKeyBinding(0x7F | SWT.MOD2, 0);
            }
        } else if (commandId.equals("org.eclipse.ui.edit.text.goto.wordNext")) {
            if (IS_MAC) {
                widget.setKeyBinding(SWT.MOD3 | 0x1000004, 0);
            } else {
                widget.setKeyBinding(SWT.MOD1 | 0x1000004, 0);
            }
        } else if (commandId.equals("org.eclipse.ui.edit.text.goto.wordPrevious")) {
            if (IS_MAC) {
                widget.setKeyBinding(SWT.MOD3 | 0x1000003, 0);
            } else {
                widget.setKeyBinding(SWT.MOD1 | 0x1000003, 0);
            }
        } else if (commandId.equals("org.eclipse.ui.edit.text.select.wordNext")) {
            if (IS_MAC) {
                widget.setKeyBinding(SWT.MOD2 | SWT.MOD3 | 0x1000004, 0);
            } else {
                widget.setKeyBinding(SWT.MOD1 | SWT.MOD2 | 0x1000004, 0);
            }
        } else if (commandId.equals("org.eclipse.ui.edit.text.select.wordPrevious")) {
            if (IS_MAC) {
                widget.setKeyBinding(SWT.MOD2 | SWT.MOD3 | 0x1000003, 0);
            } else {
                widget.setKeyBinding(SWT.MOD1 | SWT.MOD2 | 0x1000003, 0);
            }
        } else if (commandId.equals("org.eclipse.ui.edit.text.deleteNextWord")) {
            widget.setKeyBinding(SWT.MOD1 | 0x7F, 0);
            if (IS_MAC) {
                widget.setKeyBinding(SWT.MOD3 | 0x7F, 0);
            }
        } else if (commandId.equals("org.eclipse.ui.edit.text.deletePreviousWord")) {
            widget.setKeyBinding(SWT.MOD1 | 8, 0);
            if (IS_MAC) {
                widget.setKeyBinding(SWT.MOD3 | 8, 0);
            }
        }
    }
}

