/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class DataStream
implements AutoCloseable {
    private static final ThreadLocal<DataStream> INSTANCES = new ThreadLocal<DataStream>(){

        @Override
        protected DataStream initialValue() {
            return new DataStream();
        }
    };
    private static final int BB_LENGTH = 16384;
    private static final int BA_LENGTH = 16384;
    private static final int BB_PART = 4096;
    private static final int CB_LENGTH = 8192;
    private static final int CA_LENGTH = 65536;
    private static final byte MODE_BBARRAY = 0;
    private static final byte MODE_IPARRAY = 1;
    private static final int IN = 2;
    private static final int OUT = 4;
    private static final int COMPRESS = 8;
    private final ByteBuffer bb = ByteBuffer.allocateDirect(16384);
    private final byte[] ba;
    private final CharBuffer cb;
    private final char[] ca;
    private final byte mode;
    private final InStream in;
    private final OutStream out;
    private int flags;
    private int version;

    public static DataStream get(OutputStream out) {
        DataStream io = INSTANCES.get();
        io.flags = 4;
        io.out.init(out);
        return io;
    }

    public static DataStream get(InputStream in) {
        DataStream io = INSTANCES.get();
        io.flags = 2;
        io.in.init(in);
        return io;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buffer = DataStream.INSTANCES.get().ba;
        while ((n = in.read(buffer, 0, buffer.length)) != -1) {
            out.write(buffer, 0, n);
        }
    }

    public static long decodeLong(byte[] ba) {
        return (long)(ba[0] & 0xFF) << 56 | (long)(ba[1] & 0xFF) << 48 | (long)(ba[2] & 0xFF) << 40 | (long)(ba[3] & 0xFF) << 32 | (long)(ba[4] & 0xFF) << 24 | (long)((ba[5] & 0xFF) << 16) | (long)((ba[6] & 0xFF) << 8) | (long)(ba[7] & 0xFF);
    }

    public static byte[] encodeLong(long value) {
        byte[] ba = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return ba;
    }

    public DataStream() {
        if (this.bb.hasArray()) {
            this.mode = 0;
            this.ba = this.bb.array();
        } else {
            this.mode = 1;
            this.ba = new byte[16384];
        }
        this.cb = this.bb.asCharBuffer();
        this.ca = new char[65536];
        this.in = new InStream();
        this.out = new OutStream();
    }

    @Override
    public void close() throws IOException {
        if ((this.flags & 2) != 0) {
            this.in.close();
        } else if ((this.flags & 4) != 0) {
            this.out.close();
        }
        this.flags = 0;
        this.version = 0;
    }

    public void enableCompression() {
        if ((this.flags & 2) != 0) {
            this.in.enableCompression();
        } else if ((this.flags & 4) != 0) {
            this.out.enableCompression();
        }
    }

    public void writeVersion(int version) throws IOException {
        this.version = version;
        this.writeInt(this.version);
    }

    public int readVersion() throws IOException {
        this.version = this.readInt();
        return this.version;
    }

    public int getVersion() {
        return this.version;
    }

    private void writeFullyBB(int bn) throws IOException {
        switch (this.mode) {
            case 0: {
                this.out.write(this.ba, 0, bn);
                return;
            }
        }
        this.bb.clear();
        this.bb.get(this.ba, 0, bn);
        this.out.write(this.ba, 0, bn);
    }

    private void readFullyBB(int bn) throws IOException {
        switch (this.mode) {
            case 0: {
                this.in.readFully(this.ba, 0, bn);
                return;
            }
        }
        this.in.readFully(this.ba, 0, bn);
        this.bb.clear();
        this.bb.put(this.ba, 0, bn);
    }

    public void writeByte(byte value) throws IOException {
        this.out.writeByte(value);
    }

    public void writeInt(int value) throws IOException {
        this.out.writeInt(value);
    }

    public void writeLong(long value) throws IOException {
        this.out.writeLong(value);
    }

    public void writeFloat(float value) throws IOException {
        this.out.writeFloat(value);
    }

    public void writeString(@Nullable String s) throws IOException {
        if (s != null) {
            int ci;
            int cn;
            block8: {
                cn = s.length();
                if (cn <= 16384) {
                    ci = 0;
                    while (ci < cn) {
                        if ((s.charAt(ci++) & 0xFFFFFF00) == 0) {
                            continue;
                        }
                        break block8;
                    }
                    if (cn <= 8) {
                        this.out.writeInt(-cn);
                        this.out.writeBytes(s);
                        return;
                    }
                    this.out.writeInt(-cn);
                    s.getBytes(0, cn, this.ba, 0);
                    this.out.write(this.ba, 0, cn);
                    return;
                }
            }
            this.out.writeInt(cn);
            if (cn <= 0) {
                this.out.writeChars(s);
            } else {
                ci = 0;
                while (ci < cn) {
                    int cCount = Math.min(cn - ci, 8192);
                    s.getChars(ci, ci + cCount, this.ca, 0);
                    this.cb.clear();
                    this.cb.put(this.ca, 0, cCount);
                    this.writeFullyBB(cCount << 1);
                    ci += cCount;
                }
            }
            return;
        }
        this.out.writeInt(Integer.MIN_VALUE);
    }

    /*
     * Unable to fully structure code
     */
    public void writeStringArray(@Nullable String[] sa, int length) throws IOException {
        this.out.writeInt(length);
        i = 0;
        while (i < length) {
            s = sa[i];
            if (s != null) {
                cn = s.length();
                if (cn <= 16384) {
                    ci = 0;
                    while (ci < cn) {
                        if ((s.charAt(ci++) & -256) == 0) {
                            continue;
                        }
                        ** break block12
                    }
                    if (cn <= 8) {
                        this.out.writeInt(-cn);
                        this.out.writeBytes(s);
                    } else {
                        this.out.writeInt(-cn);
                        s.getBytes(0, cn, this.ba, 0);
                        this.out.write(this.ba, 0, cn);
                    }
                } else lbl-1000:
                // 2 sources

                {
                    this.out.writeInt(cn);
                    if (cn <= 8) {
                        this.out.writeChars(s);
                    } else {
                        ci = 0;
                        while (ci < cn) {
                            cCount = Math.min(cn - ci, 8192);
                            s.getChars(ci, ci + cCount, this.ca, 0);
                            this.cb.clear();
                            this.cb.put(this.ca, 0, cCount);
                            this.writeFullyBB(cCount << 1);
                            ci += cCount;
                        }
                    }
                }
            } else {
                this.out.writeInt(-2147483648);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void writeStringList(List<String> sList) throws IOException {
        length = sList.size();
        this.out.writeInt(length);
        i = 0;
        while (i < length) {
            s = sList.get(i);
            if (s != null) {
                cn = s.length();
                if (cn <= 16384) {
                    ci = 0;
                    while (ci < cn) {
                        if ((s.charAt(ci++) & -256) == 0) {
                            continue;
                        }
                        ** break block12
                    }
                    if (cn <= 8) {
                        this.out.writeInt(-cn);
                        this.out.writeBytes(s);
                    } else {
                        this.out.writeInt(-cn);
                        s.getBytes(0, cn, this.ba, 0);
                        this.out.write(this.ba, 0, cn);
                    }
                } else lbl-1000:
                // 2 sources

                {
                    this.out.writeInt(cn);
                    if (cn <= 8) {
                        this.out.writeChars(s);
                    } else {
                        ci = 0;
                        while (ci < cn) {
                            cCount = Math.min(cn - ci, 8192);
                            s.getChars(ci, ci + cCount, this.ca, 0);
                            this.cb.clear();
                            this.cb.put(this.ca, 0, cCount);
                            this.writeFullyBB(cCount << 1);
                            ci += cCount;
                        }
                    }
                }
            } else {
                this.out.writeInt(-2147483648);
            }
            ++i;
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    private String readString(int cn, char[] ca, DataInputStream in) throws IOException {
        int cr = 0;
        int position = 0;
        while (true) {
            if ((position += in.read(this.ba, position, 16384 - position)) < 4096) {
                continue;
            }
            int icount = position >> 1;
            int bcount = icount << 1;
            if (!this.bb.hasArray()) {
                this.bb.clear();
                this.bb.put(this.ba, 0, bcount);
            }
            this.cb.clear();
            this.cb.get(ca, cr, icount);
            cr += icount;
            if (position - bcount != 0) {
                this.ca[cr++] = (char)((this.ba[bcount] & 0xFF) << 8 | in.readUnsignedByte());
            }
            position = 0;
            if (cn - cr <= 8192) break;
        }
        int bToComplete = cn - cr << 1;
        if (bToComplete > 0) {
            in.readFully(this.ba, position, bToComplete - position);
            if (!this.bb.hasArray()) {
                this.bb.clear();
                this.bb.put(this.ba, 0, bToComplete);
            }
            this.cb.clear();
            this.cb.get(ca, cr, bToComplete >> 1);
        }
        return new String(ca, 0, cn);
    }

    public @Nullable String readString() throws IOException {
        int cn = this.in.readInt();
        if (cn >= 0) {
            if (cn == 0) {
                return "";
            }
            if (cn <= 64) {
                int ci = 0;
                while (ci < cn) {
                    this.ca[ci] = this.in.readChar();
                    ++ci;
                }
                return new String(this.ca, 0, cn);
            }
            if (cn <= 8192) {
                this.readFullyBB(cn << 1);
                this.cb.clear();
                this.cb.get(this.ca, 0, cn);
                return new String(this.ca, 0, cn);
            }
            if (cn <= 65536) {
                return this.readString(cn, this.ca, this.in);
            }
            return this.readString(cn, new char[cn], this.in);
        }
        if (cn >= -16384) {
            this.in.readFully(this.ba, 0, -cn);
            return new String(this.ba, 0, 0, -cn);
        }
        if (cn != Integer.MIN_VALUE) {
            byte[] bt = new byte[-cn];
            this.in.readFully(bt, 0, -cn);
            return new String(bt, 0, 0, -cn);
        }
        return null;
    }

    public String readNonNullString() throws IOException {
        int cn = this.in.readInt();
        if (cn >= 0) {
            if (cn == 0) {
                return "";
            }
            if (cn <= 64) {
                int ci = 0;
                while (ci < cn) {
                    this.ca[ci] = this.in.readChar();
                    ++ci;
                }
                return new String(this.ca, 0, cn);
            }
            if (cn <= 8192) {
                this.readFullyBB(cn << 1);
                this.cb.clear();
                this.cb.get(this.ca, 0, cn);
                return new String(this.ca, 0, cn);
            }
            if (cn <= 65536) {
                return this.readString(cn, this.ca, this.in);
            }
            return this.readString(cn, new char[cn], this.in);
        }
        if (cn >= -16384) {
            this.in.readFully(this.ba, 0, -cn);
            return new String(this.ba, 0, 0, -cn);
        }
        if (cn != Integer.MIN_VALUE) {
            byte[] bt = new byte[-cn];
            this.in.readFully(bt, 0, -cn);
            return new String(bt, 0, 0, -cn);
        }
        throw new NullPointerException();
    }

    public String[] readNonNullStringArray() throws IOException {
        int length = this.in.readInt();
        String[] array = new String[length];
        int i = 0;
        while (i < length) {
            int cn = this.in.readInt();
            if (cn >= 0) {
                if (cn == 0) {
                    array[i] = "";
                } else if (cn <= 64) {
                    int ci = 0;
                    while (ci < cn) {
                        this.ca[ci] = this.in.readChar();
                        ++ci;
                    }
                    array[i] = new String(this.ca, 0, cn);
                } else if (cn <= 8192) {
                    this.readFullyBB(cn << 1);
                    this.cb.clear();
                    this.cb.get(this.ca, 0, cn);
                    array[i] = new String(this.ca, 0, cn);
                } else {
                    array[i] = cn <= 65536 ? this.readString(cn, this.ca, this.in) : this.readString(cn, new char[cn], this.in);
                }
            } else if (cn >= -16384) {
                this.in.readFully(this.ba, 0, -cn);
                array[i] = new String(this.ba, 0, 0, -cn);
            } else if (cn != Integer.MIN_VALUE) {
                byte[] bt = new byte[-cn];
                this.in.readFully(bt, 0, -cn);
                array[i] = new String(bt, 0, 0, -cn);
            } else {
                throw new NullPointerException();
            }
            ++i;
        }
        return array;
    }

    private class InStream
    extends DataInputStream {
        private final Inflater inflater;

        public InStream() {
            super(null);
            this.inflater = new Inflater();
        }

        public void init(InputStream in) {
            this.in = in;
        }

        public void enableCompression() {
            DataStream dataStream = DataStream.this;
            dataStream.flags = dataStream.flags | 8;
            this.in = new InflaterInputStream(this.in, this.inflater, 4096);
        }

        @Override
        public void close() throws IOException {
            if (this.in != null) {
                super.close();
                this.in = null;
                if ((DataStream.this.flags & 8) != 0) {
                    this.inflater.reset();
                }
            }
        }
    }

    private class OutStream
    extends DataOutputStream {
        private final Deflater deflater;

        public OutStream() {
            super(null);
            this.deflater = new Deflater();
        }

        public void init(OutputStream out) {
            this.out = out;
        }

        public void enableCompression() {
            DataStream dataStream = DataStream.this;
            dataStream.flags = dataStream.flags | 8;
            this.out = new DeflaterOutputStream(this.out, this.deflater, 4096);
        }

        @Override
        public void close() throws IOException {
            if (this.out != null) {
                super.close();
                this.out = null;
                if ((DataStream.this.flags & 8) != 0) {
                    this.deflater.reset();
                }
            }
        }
    }
}

