/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.AbstractCellPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.swt.graphics.GC;

public abstract class CellPainterWrapper
extends AbstractCellPainter {
    private ICellPainter wrappedPainter;

    public CellPainterWrapper() {
    }

    public CellPainterWrapper(ICellPainter painter) {
        this.wrappedPainter = painter;
    }

    public void setWrappedPainter(ICellPainter painter) {
        this.wrappedPainter = painter;
    }

    public ICellPainter getWrappedPainter() {
        return this.wrappedPainter;
    }

    public LRectangle getWrappedPainterBounds(ILayerCell cell, GC gc, LRectangle bounds, IConfigRegistry configRegistry) {
        return bounds;
    }

    @Override
    public ICellPainter getCellPainterAt(long x, long y, ILayerCell cell, GC gc, LRectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        LRectangle wrappedPainterBounds = this.getWrappedPainterBounds(cell, gc, adjustedCellBounds, configRegistry);
        if (this.wrappedPainter != null && wrappedPainterBounds.contains(x, y)) {
            return this.wrappedPainter.getCellPainterAt(x, y, cell, gc, wrappedPainterBounds, configRegistry);
        }
        return super.getCellPainterAt(x, y, cell, gc, adjustedCellBounds, configRegistry);
    }

    @Override
    public long getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return this.wrappedPainter != null ? this.wrappedPainter.getPreferredWidth(cell, gc, configRegistry) : 0L;
    }

    @Override
    public long getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return this.wrappedPainter != null ? this.wrappedPainter.getPreferredHeight(cell, gc, configRegistry) : 0L;
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, LRectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        if (this.wrappedPainter != null) {
            this.wrappedPainter.paintCell(cell, gc, adjustedCellBounds, configRegistry);
        }
    }
}

