/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.emf.ui.forms;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.emf.core.util.RuleSet;
import org.eclipse.statet.ecommons.emf.ui.forms.DirectResourceEditorInput;
import org.eclipse.statet.ecommons.emf.ui.forms.EFDataBindingSupport;
import org.eclipse.statet.ecommons.emf.ui.forms.EFEditorActionBarContributor;
import org.eclipse.statet.ecommons.emf.ui.forms.EFPropertySheetPage;
import org.eclipse.statet.ecommons.emf.ui.forms.EFToolkit;
import org.eclipse.statet.ecommons.emf.ui.forms.IEFModelDescriptor;
import org.eclipse.statet.ecommons.emf.ui.forms.IEFPropertyExpressions;
import org.eclipse.statet.ecommons.ui.actions.HandlerCollection;
import org.eclipse.statet.internal.ecommons.emf.ui.forms.CopyEObjectHandler;
import org.eclipse.statet.internal.ecommons.emf.ui.forms.CutEObjectHandler;
import org.eclipse.statet.internal.ecommons.emf.ui.forms.EFEditingDomain;
import org.eclipse.statet.internal.ecommons.emf.ui.forms.EditEObjectHandler;
import org.eclipse.statet.internal.ecommons.emf.ui.forms.EditorSelectionProvider;
import org.eclipse.statet.internal.ecommons.emf.ui.forms.PasteEObjectHandler;
import org.eclipse.statet.internal.rtm.base.ui.editors.Messages;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public abstract class EFEditor
extends FormEditor
implements IEditingDomainProvider,
IMenuListener,
IGotoMarker,
ITabbedPropertySheetPageContributor {
    private final IEFModelDescriptor modelDescriptor;
    private final ResourceManager resourceListener = new ResourceManager();
    private final Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    private final MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected boolean updateProblemIndication = true;
    private final EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = EFEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            EFEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            EFEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!EFEditor.this.updateProblemIndication) return;
                        EFEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                EFEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
        }
    };
    private IContentOutlinePage contentOutlinePage;
    private final List<IPropertySheetPage> propertySheetPages = new ArrayList<IPropertySheetPage>(2);
    private final IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == EFEditor.this.contentOutlinePage) {
                    EFEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)EFEditor.this);
                }
            } else if (p instanceof PropertySheet) {
                if (EFEditor.this.propertySheetPages.contains(((PropertySheet)p).getCurrentPage())) {
                    EFEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)EFEditor.this);
                    EFEditor.this.handleActivate();
                }
            } else if (p == EFEditor.this) {
                EFEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    private EFEditingDomain editingDomain;
    private ComposedAdapterFactory adapterFactory;
    private EFDataBindingSupport dataBinding;
    private final EditorSelectionProvider selectionProvider = new EditorSelectionProvider(this);
    protected HandlerCollection handlers;

    protected EFEditor(IEFModelDescriptor modelDescriptor) {
        this.modelDescriptor = modelDescriptor;
        this.initializeEditingDomain(modelDescriptor.createItemProviderAdapterFactory());
    }

    public IEFModelDescriptor getModelDescriptor() {
        return this.modelDescriptor;
    }

    public String getContributorId() {
        return this.modelDescriptor.getEditorID();
    }

    protected void initializeEditingDomain(AdapterFactory itemAdapterFactory) {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory(itemAdapterFactory);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                EFEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EFEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            EFEditor.this.selectObject(mostRecentCommand.getAffectedObjects());
                        }
                    }
                });
            }
        });
        this.editingDomain = new EFEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    protected EFEditorActionBarContributor getActionBarContributor() {
        return (EFEditorActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this.selectionProvider);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener, 1);
    }

    protected void handleActivate() {
        Map resourceToReadOnlyMap = this.editingDomain.getResourceToReadOnlyMap();
        if (resourceToReadOnlyMap != null) {
            resourceToReadOnlyMap.clear();
            ISelectionProvider selectionProvider = this.getSite().getSelectionProvider();
            selectionProvider.setSelection(selectionProvider.getSelection());
        }
        this.resourceListener.processChanges();
    }

    public void createModel() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof DirectResourceEditorInput) {
            this.editingDomain.getResourceSet().getResources().add((Object)((DirectResourceEditorInput)input).getResource());
            return;
        }
        URI resourceURI = EditUIUtil.getURI((IEditorInput)input);
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    protected void resourceLoaded() {
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, this.modelDescriptor.getEditorPluginID(), 0, NLS.bind((String)Messages.EFEditor_error_ProblemsInFile_message, (Object)resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, this.modelDescriptor.getEditorPluginID(), 0, NLS.bind((String)Messages.EFEditor_error_ProblemsInFile_message, (Object)resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.EFEditor_FileConflict_title, (String)Messages.EFEditor_FileConflict_message);
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        if (this.getEditorInput() instanceof DirectResourceEditorInput && ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).getURI().equals(DirectResourceEditorInput.NO_URI)) {
            this.doSaveAs();
            return;
        }
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("ENCODING", "UTF-8");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : EFEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !EFEditor.this.isPersisted(resource) || EFEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            EFEditor.this.resourceListener.savedResources.add(resource);
                        }
                    }
                    catch (Exception exception) {
                        EFEditor.this.resourceToDiagnosticMap.put(resource, EFEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception e) {
            this.operationFailed("saving config", e);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public void doSaveAs() {
        IFile file;
        IPath path;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        if (saveAsDialog.open() != 0 || (path = saveAsDialog.getResult()) == null) {
            return;
        }
        if (path.getFileExtension() == null && this.modelDescriptor.getDefaultFileExtension() != null) {
            path = path.addFileExtension(this.modelDescriptor.getDefaultFileExtension());
        }
        if ((file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        IStatusLineManager statusLine = this.getActionBarContributor().getActionBars().getStatusLineManager();
        IProgressMonitor progressMonitor = statusLine != null ? statusLine.getProgressMonitor() : new NullProgressMonitor();
        this.doSave(progressMonitor);
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, this.modelDescriptor.getEditorPluginID(), 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException e) {
                    this.operationFailed("updating problem indicators", (Exception)((Object)e));
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException e) {
                        this.operationFailed("updating problem indicators", (Exception)((Object)e));
                    }
                }
            }
        }
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    this.selectObject(Collections.singletonList((EObject)this.editingDomain.getWrapper(eObject)));
                }
            }
        }
        catch (CoreException e) {
            this.operationFailed("going to marker", (Exception)((Object)e));
        }
    }

    public EFToolkit getToolkit() {
        return (EFToolkit)super.getToolkit();
    }

    protected abstract EFToolkit createToolkit(Display var1);

    protected void createPages() {
        this.createModel();
        this.dataBinding = new EFDataBindingSupport(this, this.createContextAdapterFactory());
        super.createPages();
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    EFEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                EFEditor.this.updateProblemIndication();
            }
        });
        this.handlers = new HandlerCollection();
        this.createActions((IServiceLocator)this.getSite(), this.handlers);
    }

    protected IAdapterFactory createContextAdapterFactory() {
        return new ContextAdapterFactory();
    }

    public EFDataBindingSupport getDataBinding() {
        return this.dataBinding;
    }

    protected void createActions(IServiceLocator locator, HandlerCollection handlers) {
        IHandlerService handlerService = (IHandlerService)locator.getService(IHandlerService.class);
        EditEObjectHandler handler = new CutEObjectHandler();
        handlers.add("org.eclipse.ui.edit.cut~org.eclipse.statet.ecommons.emf.ui.EObjectList", (IHandler2)handler);
        handlerService.activateHandler("org.eclipse.ui.edit.cut", (IHandler)handler, IEFPropertyExpressions.EOBJECT_LIST_EXPRESSION);
        handler = new CopyEObjectHandler();
        handlers.add("org.eclipse.ui.edit.copy~org.eclipse.statet.ecommons.emf.ui.EObjectList", (IHandler2)handler);
        handlerService.activateHandler("org.eclipse.ui.edit.copy", (IHandler)handler, IEFPropertyExpressions.EOBJECT_LIST_EXPRESSION);
        handler = new PasteEObjectHandler();
        handlers.add("org.eclipse.ui.edit.paste~org.eclipse.statet.ecommons.emf.ui.EObjectList", (IHandler2)handler);
        handlerService.activateHandler("org.eclipse.ui.edit.paste", (IHandler)handler, IEFPropertyExpressions.EOBJECT_LIST_EXPRESSION);
    }

    protected void contributeToPages(IToolBarManager manager) {
    }

    protected void createRawContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(7, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(7, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter(this.getEditingDomain(), (Viewer)viewer));
    }

    public void menuAboutToShow(IMenuManager menuManager) {
    }

    protected void selectObject(Collection<? extends EObject> objects) {
    }

    protected void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager = this.getActionBarContributor().getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage("");
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator(this.getAdapterFactory()).getText(collection.iterator().next());
                        statusLineManager.setMessage(text);
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(NLS.bind((String)Messages.EFEditor_MultiObjectSelected_message, (Object)Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1 && this.getContainer() instanceof CTabFolder) {
            ((CTabFolder)this.getContainer()).setTabHeight(1);
            Point point = this.getContainer().getSize();
            this.getContainer().setSize(point.x, point.y + 6);
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1 && this.getContainer() instanceof CTabFolder) {
            ((CTabFolder)this.getContainer()).setTabHeight(-1);
            Point point = this.getContainer().getSize();
            this.getContainer().setSize(point.x, point.y - 6);
        }
    }

    protected IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = this.createContentOutlinePage();
        }
        return this.contentOutlinePage;
    }

    protected IContentOutlinePage createContentOutlinePage() {
        return null;
    }

    protected IPropertySheetPage getPropertySheetPage() {
        IPropertySheetPage page = this.createPropertySheetPage();
        this.propertySheetPages.add(page);
        return page;
    }

    protected IPropertySheetPage createPropertySheetPage() {
        return new EFPropertySheetPage(this);
    }

    EditorSelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    protected void pageChange(int newPageIndex) {
        this.selectionProvider.update();
        super.pageChange(newPageIndex);
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    protected abstract void operationFailed(String var1, Exception var2);

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == Control.class) {
            return (T)this.getContainer();
        }
        if (adapterType == IContentOutlinePage.class) {
            return (T)this.getContentOutlinePage();
        }
        if (adapterType == IPropertySheetPage.class) {
            return (T)this.getPropertySheetPage();
        }
        if (adapterType == IGotoMarker.class) {
            return (T)((Object)this);
        }
        return (T)super.getAdapter(adapterType);
    }

    void onPropertySheetDisposed(IPropertySheetPage page) {
        this.propertySheetPages.remove(page);
    }

    public void dispose() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        for (IPropertySheetPage page : this.propertySheetPages) {
            page.dispose();
        }
        this.propertySheetPages.clear();
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
            this.contentOutlinePage = null;
        }
        if (this.handlers != null) {
            this.handlers.dispose();
            this.handlers = null;
        }
        super.dispose();
    }

    public class ContextAdapterFactory
    implements IAdapterFactory {
        public Class<?>[] getAdapterList() {
            return null;
        }

        public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
            if (adapterType.equals(RuleSet.class)) {
                return (T)EFEditor.this.modelDescriptor.getRuleSet();
            }
            return null;
        }
    }

    private class ResourceManager
    implements IResourceChangeListener {
        private final Collection<Resource> removedResources = new ArrayList<Resource>();
        private final Collection<Resource> changedResources = new ArrayList<Resource>();
        private final Collection<Resource> savedResources = new ArrayList<Resource>();

        private ResourceManager() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = EFEditor.this.getEditingDomain().getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        Resource resource;
                        if (delta.getResource().getType() == 1 && (delta.getKind() == 2 || delta.getKind() == 4 && delta.getFlags() != 131072) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                            if (delta.getKind() == 2) {
                                this.removedResources.add(resource);
                            } else if (!ResourceManager.this.savedResources.remove(resource)) {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    EFEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            ResourceManager.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!EFEditor.this.isDirty()) {
                                EFEditor.this.getSite().getPage().closeEditor((IEditorPart)EFEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    EFEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            ResourceManager.this.changedResources.addAll(visitor.getChangedResources());
                            if (EFEditor.this.getSite().getPage().getActiveEditor() == EFEditor.this) {
                                EFEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException e) {
                EFEditor.this.operationFailed("processing resource change", (Exception)((Object)e));
            }
        }

        public void processChanges() {
            if (!this.removedResources.isEmpty()) {
                if (EFEditor.this.handleDirtyConflict()) {
                    EFEditor.this.getSite().getPage().closeEditor((IEditorPart)EFEditor.this, false);
                } else {
                    this.removedResources.clear();
                    this.changedResources.clear();
                    this.savedResources.clear();
                }
            } else if (!this.changedResources.isEmpty()) {
                this.changedResources.removeAll(this.savedResources);
                this.handleChangedResources();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        }

        protected void handleChangedResources() {
            if (!(this.changedResources.isEmpty() || EFEditor.this.isDirty() && !EFEditor.this.handleDirtyConflict())) {
                if (EFEditor.this.isDirty()) {
                    this.changedResources.addAll((Collection<Resource>)EFEditor.this.editingDomain.getResourceSet().getResources());
                }
                EFEditor.this.editingDomain.getCommandStack().flush();
                EFEditor.this.updateProblemIndication = false;
                for (Resource resource : this.changedResources) {
                    if (!resource.isLoaded()) continue;
                    resource.unload();
                    try {
                        resource.load(Collections.EMPTY_MAP);
                    }
                    catch (IOException exception) {
                        if (EFEditor.this.resourceToDiagnosticMap.containsKey(resource)) continue;
                        EFEditor.this.resourceToDiagnosticMap.put(resource, EFEditor.this.analyzeResourceProblems(resource, exception));
                    }
                }
                ISelectionProvider selectionProvider = EFEditor.this.getSite().getSelectionProvider();
                if (AdapterFactoryEditingDomain.isStale((Object)selectionProvider.getSelection())) {
                    selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
                }
                EFEditor.this.updateProblemIndication = true;
                EFEditor.this.updateProblemIndication();
            }
        }
    }
}

