/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.variables.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.ecommons.variables.core.Messages;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class VariableText2 {
    public static final ProblemReporter EXCEPTION_REPORTER = new ProblemReporter(){

        @Override
        public void problemFound(IStatus status, int begin, int end) throws CoreException {
            throw new CoreException(status);
        }
    };
    private static final String DOLLAR_SIGN = "$";
    private static final String RESOLVE_FAILED_VALUE = new String("<unresolved>");
    private final Map<String, IStringVariable> extraVariables;
    private Severities severities;
    private ProblemReporter reporter;
    private final List<VariableReference> references = new ArrayList<VariableReference>();
    private @Nullable IStringVariableManager variableManager;
    private final StringBuilder sb = new StringBuilder();

    public VariableText2(@Nullable Map<String, IStringVariable> variables) {
        this.extraVariables = variables != null ? variables : Collections.emptyMap();
    }

    public VariableText2() {
        this(null);
    }

    public final Map<String, IStringVariable> getExtraVariables() {
        return this.extraVariables;
    }

    public void validate(String text, @Nullable Severities severities, @Nullable ProblemReporter reporter) throws CoreException {
        try {
            this.severities = (Severities)ObjectUtils.nonNullElse((Object)severities, (Object)Severities.RESOLVE);
            this.reporter = (ProblemReporter)ObjectUtils.nonNullElse((Object)reporter, (Object)EXCEPTION_REPORTER);
            this.parseReferences(text);
            if (this.severities.getUnresolved() != 0) {
                this.resolveReferences(text, 0, Integer.MAX_VALUE);
            }
        }
        finally {
            this.severities = null;
            this.reporter = null;
            this.references.clear();
        }
    }

    public String performStringSubstitution(String text, @Nullable Severities severities) throws CoreException {
        try {
            this.severities = (Severities)ObjectUtils.nonNullElse((Object)severities, (Object)Severities.RESOLVE);
            this.reporter = EXCEPTION_REPORTER;
            this.parseReferences(text);
            this.resolveReferences(text, 0, Integer.MAX_VALUE);
            String string = this.concatChecked(text, 0, 0, text.length());
            return string;
        }
        finally {
            this.severities = null;
            this.reporter = null;
            this.references.clear();
        }
    }

    public String escapeText(String text) {
        StringBuilder escaped = this.getStringBuilder();
        int start = 0;
        int idx = 0;
        while (idx < text.length()) {
            if (text.charAt(idx) == '$') {
                if (start < idx) {
                    escaped.append(text, start, idx);
                }
                escaped.append("$$");
                start = idx + 1;
            }
            ++idx;
        }
        if (start == 0) {
            return text;
        }
        if (start < text.length()) {
            escaped.append(text, start, text.length());
        }
        return escaped.toString();
    }

    public final @Nullable IStringVariable getVariable(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        IStringVariable variable = this.extraVariables.get(name);
        if (variable == null) {
            if (this.variableManager == null) {
                this.variableManager = VariablesPlugin.getDefault().getStringVariableManager();
            }
            if ((variable = this.variableManager.getValueVariable(name)) == null) {
                variable = this.variableManager.getDynamicVariable(name);
            }
        }
        return variable;
    }

    private StringBuilder getStringBuilder() {
        this.sb.setLength(0);
        return this.sb;
    }

    private void parseReferences(String text) throws CoreException {
        int l = text.length();
        int offset = 0;
        while (offset < l) {
            char c = text.charAt(offset);
            if (c == '$') {
                if (offset + 1 == l) {
                    this.reporter.problemFound((IStatus)new Status(4, "org.eclipse.statet.ecommons.variables.core", NLS.bind((String)Messages.Validation_Syntax_DollarEnd_message, (Object)Character.valueOf(c))), offset, offset + 1);
                    break;
                }
                char c2 = text.charAt(offset + 1);
                if (c2 == '$') {
                    this.references.add(new VariableReference(offset, offset + 2, DOLLAR_SIGN));
                    offset += 2;
                    continue;
                }
                if (c2 == '{') {
                    int end = offset + 2;
                    while (end < l) {
                        char cEnd = text.charAt(end);
                        if (!(cEnd >= 'a' && cEnd <= 'z' || cEnd >= 'A' && cEnd <= 'Z' || cEnd == '_')) {
                            if (cEnd == ':' || cEnd == '}') {
                                if (end == offset + 2) {
                                    this.reporter.problemFound((IStatus)new Status(4, "org.eclipse.statet.ecommons.variables.core", Messages.Validation_Syntax_VarMissingName_message), offset, 3);
                                    break;
                                }
                                this.references.add(new VariableReference(offset, cEnd == '}' ? end + 1 : -1, text.substring(offset + 2, end)));
                                break;
                            }
                            this.reporter.problemFound((IStatus)new Status(4, "org.eclipse.statet.ecommons.variables.core", NLS.bind((String)Messages.Validation_Syntax_VarInvalidChar_message, (Object)Character.valueOf(cEnd), (Object)text.substring(offset + 2, end))), offset, end + 1);
                            break;
                        }
                        ++end;
                    }
                    if (end == l) {
                        this.reporter.problemFound((IStatus)new Status(4, "org.eclipse.statet.ecommons.variables.core", NLS.bind((String)Messages.Validation_Syntax_VarNotClosed_message, (Object)text.substring(offset + 2, end))), offset, 2);
                    }
                    offset = end + 1;
                    continue;
                }
                this.reporter.problemFound((IStatus)new Status(4, "org.eclipse.statet.ecommons.variables.core", NLS.bind((String)Messages.Validation_Syntax_DollorInvalidChar_message, (Object)Character.valueOf(c))), offset, 2);
                ++offset;
                continue;
            }
            if (c == '}') {
                int i = this.references.size() - 1;
                while (i >= 0) {
                    VariableReference ref = this.references.get(i);
                    if (ref.end < 0) {
                        ref.end = offset + 1;
                        break;
                    }
                    --i;
                }
                ++offset;
                continue;
            }
            ++offset;
        }
        if (this.references.isEmpty()) {
            return;
        }
        for (VariableReference ref : this.references) {
            if (ref.name == DOLLAR_SIGN) continue;
            if (ref.end < 0) {
                this.reporter.problemFound((IStatus)new Status(4, "org.eclipse.statet.ecommons.variables.core", NLS.bind((String)Messages.Validation_Syntax_VarNotClosed_message, (Object)ref.name)), ref.begin, 2);
                continue;
            }
            IStringVariable iStringVariable = this.getVariable(ref.name);
            ref.variable = iStringVariable;
            if (iStringVariable != null) continue;
            this.reporter.problemFound((IStatus)new Status(this.severities.getUndefined(), "org.eclipse.statet.ecommons.variables.core", NLS.bind((String)Messages.Validation_Ref_VarNotDefined_message, (Object)ref.name)), ref.begin, 2);
        }
        for (VariableReference ref : this.references) {
            if (ref.variable == null || !ref.hasArg() || ref.variable instanceof IDynamicVariable && ((IDynamicVariable)ref.variable).supportsArgument()) continue;
            this.reporter.problemFound((IStatus)new Status(4, "org.eclipse.statet.ecommons.variables.core", NLS.bind((String)Messages.Validation_Ref_VarNoArgs_message, (Object)ref.name)), ref.begin, 2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean resolveReferences(String text, int refIdx, int end) throws CoreException {
        ok = true;
        i = refIdx;
        while (i < this.references.size()) {
            block17: {
                block15: {
                    block19: {
                        block14: {
                            block18: {
                                block13: {
                                    ref = this.references.get(i);
                                    if (VariableReference.access$0(ref) > end) break;
                                    if (VariableReference.access$6(ref) == null) break block13;
                                    if (VariableReference.access$6(ref) == VariableText2.RESOLVE_FAILED_VALUE) {
                                        ok = false;
                                    }
                                    break block17;
                                }
                                if (!ref.hasArg()) ** GOTO lbl27
                                if (i + 1 >= this.references.size() || VariableReference.access$3(this.references.get(i + 1)) >= VariableReference.access$0(ref)) break block14;
                                if (!this.resolveReferences(text, i + 1, VariableReference.access$0(ref))) break block18;
                                arg = this.concat(text, i + 1, ref.getArgBegin(), ref.getArgEnd());
                                ** GOTO lbl28
                            }
                            VariableReference.access$7(ref, VariableText2.RESOLVE_FAILED_VALUE);
                            if (VariableReference.access$6(ref) == VariableText2.RESOLVE_FAILED_VALUE) {
                                ok = false;
                            }
                            break block17;
                        }
                        arg = text.substring(ref.getArgBegin(), ref.getArgEnd());
                        break block19;
lbl27:
                        // 1 sources

                        arg = null;
                    }
                    if (VariableReference.access$5(ref) != null) break block15;
                    VariableReference.access$7(ref, VariableText2.RESOLVE_FAILED_VALUE);
                    if (VariableReference.access$6(ref) == VariableText2.RESOLVE_FAILED_VALUE) {
                        ok = false;
                    }
                    break block17;
                }
                try {
                    try {
                        VariableReference.access$7(ref, this.resolve(VariableReference.access$5(ref), arg));
                    }
                    catch (CoreException e) {
                        VariableReference.access$7(ref, VariableText2.RESOLVE_FAILED_VALUE);
                        status = e.getStatus();
                        this.reporter.problemFound((IStatus)new Status(this.severities.getUnresolved(), status.getPlugin(), status.getMessage()), VariableReference.access$3(ref), VariableReference.access$0(ref));
                        if (VariableReference.access$6(ref) != VariableText2.RESOLVE_FAILED_VALUE) ** GOTO lbl53
                        ok = false;
                    }
                }
                catch (Throwable var9_10) {
                    if (VariableReference.access$6(ref) == VariableText2.RESOLVE_FAILED_VALUE) {
                        ok = false;
                    }
                    throw var9_10;
                }
                if (VariableReference.access$6(ref) == VariableText2.RESOLVE_FAILED_VALUE) {
                    ok = false;
                }
            }
            ++i;
        }
        return ok;
    }

    private String concat(String text, int refIdx, int begin, int end) {
        StringBuilder newText = this.getStringBuilder();
        while (refIdx < this.references.size()) {
            VariableReference ref;
            if ((ref = this.references.get(refIdx++)).begin < begin || ref.begin >= end) continue;
            newText.append(text, begin, ref.begin);
            newText.append(ref.value);
            begin = ref.end;
        }
        newText.append(text, begin, end);
        return newText.toString();
    }

    private String concatChecked(String text, int refIdx, int begin, int end) throws CoreException {
        StringBuilder newText = this.getStringBuilder();
        while (refIdx < this.references.size()) {
            VariableReference ref;
            if ((ref = this.references.get(refIdx++)).begin < begin || ref.begin >= end) continue;
            newText.append(text, begin, ref.begin);
            newText.append(this.checkValue(ref.variable, ref.value));
            begin = ref.end;
        }
        newText.append(text, begin, end);
        return newText.toString();
    }

    protected String resolve(IStringVariable variable, @Nullable String argument) throws CoreException {
        String value = variable instanceof IDynamicVariable ? ((IDynamicVariable)variable).getValue(argument) : ((IValueVariable)variable).getValue();
        return value != null ? value : "";
    }

    protected String checkValue(IStringVariable variable, String value) throws CoreException {
        return value;
    }

    public static interface ProblemReporter {
        public void problemFound(IStatus var1, int var2, int var3) throws CoreException;
    }

    public static class Severities {
        public static final Severities CHECK_SYNTAX = new Severities(4, 0);
        public static final Severities RESOLVE = new Severities(4, 4);
        private final int undefined;
        private final int unresolved;

        public Severities(int undefined, int unresolved) {
            this.undefined = undefined;
            this.unresolved = unresolved;
        }

        public int getUndefined() {
            return this.undefined;
        }

        public int getUnresolved() {
            return this.unresolved;
        }
    }

    @NonNullByDefault(value={NullDefaultLocation.PARAMETER, NullDefaultLocation.RETURN_TYPE, NullDefaultLocation.TYPE_BOUND, NullDefaultLocation.TYPE_ARGUMENT})
    private static class VariableReference {
        private final int begin;
        private int end;
        private final @NonNull String name;
        private IStringVariable variable;
        private String value;

        public VariableReference(int begin, int end, String name) {
            this.begin = begin;
            this.end = end;
            this.name = name;
            if (name == VariableText2.DOLLAR_SIGN) {
                this.value = VariableText2.DOLLAR_SIGN;
            }
        }

        public boolean hasArg() {
            return this.end > 0 && this.end - this.begin > this.name.length() + 3;
        }

        public int getArgBegin() {
            return this.begin + this.name.length() + 3;
        }

        public int getArgEnd() {
            return this.end - 1;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("VariableReference");
            sb.append(" name= ").append(this.name);
            sb.append("\n\tbegin= ").append(this.begin);
            sb.append("\n\tend= ").append(this.end);
            sb.append("\n");
            return sb.toString();
        }

        static /* synthetic */ void access$7(VariableReference variableReference, String string) {
            variableReference.value = string;
        }
    }
}

