/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class StructureSelectionHistory {
    private final ISourceEditor sourceEditor;
    private final List<IRegion> history;
    private final ISelectionChangedListener selectionListener;
    private int selectionChangeListenerCounter;
    private final CopyOnWriteIdentityListSet<IUpdate> updateActions = new CopyOnWriteIdentityListSet();

    public StructureSelectionHistory(ISourceEditor editor) {
        this.sourceEditor = editor;
        this.history = new ArrayList<IRegion>();
        this.selectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (StructureSelectionHistory.this.selectionChangeListenerCounter == 0) {
                    StructureSelectionHistory.this.flush();
                }
            }
        };
        this.sourceEditor.getViewer().getSelectionProvider().addSelectionChangedListener(this.selectionListener);
    }

    public void addUpdateListener(IUpdate action) {
        this.updateActions.add((Object)action);
    }

    private final void updateState() {
        for (IUpdate action : this.updateActions.toList()) {
            action.update();
        }
    }

    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    public void remember(IRegion range) {
        this.history.add(range);
        this.updateState();
    }

    public IRegion getLast() {
        if (this.isEmpty()) {
            return null;
        }
        IRegion result = this.history.remove(this.history.size() - 1);
        this.updateState();
        return result;
    }

    public void flush() {
        if (this.history.isEmpty()) {
            return;
        }
        this.history.clear();
        this.updateState();
    }

    public void ignoreSelectionChanges() {
        ++this.selectionChangeListenerCounter;
    }

    public void listenToSelectionChanges() {
        --this.selectionChangeListenerCounter;
    }

    public void dispose() {
        this.sourceEditor.getViewer().getSelectionProvider().removeSelectionChangedListener(this.selectionListener);
    }
}

