/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.statet.ecommons.ts.ui.ToolRunnableDecorator;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DecoratorsRegistry {
    private static final String DECORATORS_EXTENSION_POINT = "org.eclipse.statet.ecommons.ts.UIDecorators";
    private static final String RUNNABLE_ELEMENT_NAME = "runnable";
    private static final String RUNNABLE_ID_ATTRIBUTE_NAME = "typeId";
    private static final String ICON_ATTRIBUTE_NAME = "icon";
    private final HashMap<String, RunnableDecorator> runnableIconMap = new HashMap();
    private final Display display = UIAccess.getDisplay();
    private ResourceManager manager;

    public DecoratorsRegistry() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DecoratorsRegistry.this.manager = JFaceResources.getResources((Display)DecoratorsRegistry.this.display);
                DecoratorsRegistry.this.display.disposeExec(new Runnable(){

                    @Override
                    public void run() {
                        DecoratorsRegistry.this.dispose();
                    }
                });
                DecoratorsRegistry.this.load();
            }
        };
        if (this.display.getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            this.display.syncExec(runnable);
        }
    }

    private void load() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(DECORATORS_EXTENSION_POINT);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            String typeId;
            IConfigurationElement configuration = iConfigurationElementArray[n2];
            if (configuration.getName().equals(RUNNABLE_ELEMENT_NAME) && (typeId = configuration.getAttribute(RUNNABLE_ID_ATTRIBUTE_NAME)) != null && !typeId.isEmpty()) {
                RunnableDecorator decorators = new RunnableDecorator();
                String icon = configuration.getAttribute(ICON_ATTRIBUTE_NAME);
                String namespaceId = configuration.getNamespaceIdentifier();
                if (icon != null && icon.length() > 0) {
                    decorators.iconDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)namespaceId, (String)icon);
                }
                this.runnableIconMap.put(typeId, decorators);
            }
            ++n2;
        }
    }

    public ToolRunnableDecorator getDecoratorForRunnable(String typeId) {
        return this.runnableIconMap.get(typeId);
    }

    private void dispose() {
        for (RunnableDecorator decorator : this.runnableIconMap.values()) {
            if (decorator.icon == null) continue;
            this.manager.destroyImage(decorator.iconDescriptor);
        }
        this.runnableIconMap.clear();
    }

    private class RunnableDecorator
    implements ToolRunnableDecorator {
        ImageDescriptor iconDescriptor;
        Image icon;

        private RunnableDecorator() {
        }

        public Image getImage() {
            if (this.icon == null && this.iconDescriptor != null) {
                this.icon = DecoratorsRegistry.this.manager.createImageWithDefault(this.iconDescriptor);
            }
            return this.icon;
        }
    }
}

