/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Cursor;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.EscapedCharacter;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.HardLineBreak;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.SourceSpan;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class BackslashEscapeSpan
extends SourceSpan {
    @Override
    public @Nullable Inline createInline(ProcessingContext context, Cursor cursor) {
        char c = cursor.getChar();
        if (c == '\\' && cursor.hasNext()) {
            if (cursor.getNext() == '\n') {
                int startOffset = cursor.getOffset();
                int endOffset = cursor.getOffset(2);
                return new HardLineBreak(cursor.getLineAtOffset(), startOffset, endOffset - startOffset, 2);
            }
            if (context.getHelper().isAsciiPunctuation(cursor.getNext())) {
                return new EscapedCharacter(cursor.getLineAtOffset(), cursor.getOffset(), cursor.getNext());
            }
        }
        return null;
    }
}

