/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.lang;

import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault(value={NullDefaultLocation.PARAMETER, NullDefaultLocation.RETURN_TYPE, NullDefaultLocation.FIELD})
public final class ObjectUtils {
    public static final Class<@NonNull Object> NonNull_Object_TYPE = Object.class;
    public static final Class<@Nullable Object> Nullable_Object_TYPE = Object.class;
    public static final Class<@NonNull String> NonNull_String_TYPE = String.class;
    public static final Class<@Nullable String> Nullable_String_TYPE = String.class;

    public static boolean isNull(@Nullable Object value) {
        return value == null;
    }

    public static boolean isAnyNull(@Nullable Object v1, @Nullable Object v2) {
        return v1 == null || v2 == null;
    }

    @SafeVarargs
    public static <T> boolean isAnyNull(T ... values) {
        int i = 0;
        while (i < values.length) {
            if (values[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <T> @NonNull T nonNullAssert(@Nullable T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return value;
    }

    public static <T> @NonNull T nonNullElse(@Nullable T value, @NonNull T elseValue) {
        return value != null ? value : elseValue;
    }

    public static <T> @NonNull T nonNullElse(@Nullable T value, Supplier<? extends @NonNull T> elseSupplier) {
        return value != null ? value : elseSupplier.get();
    }

    public static <T> @Nullable T nullable(@Nullable T value) {
        return value;
    }

    private ObjectUtils() {
    }

    public static class ToStringBuilder {
        private static final String INDENT = "  ";
        private static final String CONT_INDENT = "    ";
        private static final String PROP_PREFIX = "\n  ";
        private static final String PROP_ASSIGN = "= ";
        private static final Object NULL = "<null>";
        private final StringBuilder sb;
        private @Nullable Formatter formatter;

        public ToStringBuilder() {
            this.sb = new StringBuilder();
        }

        public ToStringBuilder(String name) {
            this.sb = new StringBuilder(name);
        }

        public ToStringBuilder(String name, Class<?> clazz) {
            this.sb = new StringBuilder(name);
            this.sb.append(" (");
            this.sb.append(clazz.getName());
            this.sb.append(")");
        }

        public ToStringBuilder(Class<?> defClazz, Class<?> clazz) {
            this(defClazz.getSimpleName(), clazz);
        }

        public StringBuilder getStringBuilder() {
            return this.sb;
        }

        public final void append(String s) {
            this.sb.append(s);
        }

        public final void append(String s, int begin, int end) {
            this.sb.append(s, begin, end);
        }

        public final void append(char c) {
            this.sb.append(c);
        }

        public final void append(char sep, String s) {
            this.sb.append(sep);
            this.sb.append(s);
        }

        public final void append(int number) {
            this.sb.append(number);
        }

        public final void append(String valueFormat, Object ... valueArgs) {
            Formatter formatter = this.formatter;
            if (formatter == null) {
                this.formatter = formatter = new Formatter(this.sb, Locale.ENGLISH);
            }
            formatter.format(valueFormat, valueArgs);
        }

        private void appendLines(String s, String contPrefix) {
            int start = 0;
            int end = s.indexOf(10, start);
            if (end < 0) {
                this.append(s);
                return;
            }
            if (end > 0 && s.charAt(end - 1) == '\r') {
                this.append(s, start, end - 1);
            } else {
                this.append(s, start, end);
            }
            start = end + 1;
            while ((end = s.indexOf(10, start)) >= 0) {
                this.append(contPrefix);
                if (end > 0 && s.charAt(end - 1) == '\r') {
                    this.append(s, start, end - 1);
                } else {
                    this.append(s, start, end);
                }
                start = end + 1;
            }
            if (start < s.length()) {
                this.append(contPrefix);
                this.append(s, start, s.length());
            }
        }

        public void addProp(String name) {
            this.sb.append(PROP_PREFIX);
            this.sb.append(name);
            this.sb.append(PROP_ASSIGN);
        }

        public void addProp(String name, @Nullable String value) {
            this.addProp(name);
            if (value == null) {
                this.sb.append(NULL);
                return;
            }
            this.appendLines(value, "\n      ");
        }

        public void addProp(String name, boolean value) {
            this.addProp(name);
            this.sb.append(value);
        }

        public void addProp(String name, int value) {
            this.addProp(name);
            this.sb.append(value);
        }

        public void addProp(String name, long value) {
            this.addProp(name);
            this.sb.append(value);
        }

        public void addProp(String name, float value) {
            this.addProp(name);
            this.sb.append(value);
        }

        public void addProp(String name, double value) {
            this.addProp(name);
            this.sb.append(value);
        }

        public void addProp(String name, @Nullable Object value) {
            this.addProp(name);
            if (value == null) {
                this.sb.append(NULL);
                return;
            }
            this.appendLines(value.toString(), "\n      ");
        }

        public void addProp(String name, @Nullable Collection<?> value) {
            this.addProp(name);
            if (value == null) {
                this.sb.append(NULL);
                return;
            }
            if (value instanceof List) {
                this.sb.append('[');
            } else {
                this.sb.append('{');
            }
            if (!value.isEmpty()) {
                for (Object e : value) {
                    this.sb.append("\n    ");
                    if (e == null) {
                        this.sb.append(NULL);
                        continue;
                    }
                    this.appendLines(e.toString(), "\n        ");
                }
                this.sb.append(PROP_PREFIX);
            }
            if (value instanceof List) {
                this.sb.append(']');
            } else {
                this.sb.append('}');
            }
        }

        public void addProp(String name, String valueFormat, Object ... valueArgs) {
            this.addProp(name);
            this.append(valueFormat, valueArgs);
        }

        public String build() {
            return this.sb.toString();
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

