/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.internal.yaml.ui.editors.YamlDocumentProvider;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.ltk.ui.LtkUI;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.templates.WaContributionContextTypeRegistry;
import org.eclipse.statet.ltk.ui.util.CombinedPreferenceStore;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class YamlUIPlugin
extends AbstractUIPlugin {
    private static YamlUIPlugin instance;
    private boolean started;
    private final List<Disposable> disposables = new ArrayList<Disposable>();
    private IPreferenceStore editorPreferenceStore;
    private YamlDocumentProvider yamlDocumentProvider;
    private ContextTypeRegistry yamlEditorTemplateContextTypeRegistry;
    private TemplateStore yamlEditorTemplateStore;
    private ContentAssistComputerRegistry yamlEditorContentAssistRegistry;

    public static YamlUIPlugin getInstance() {
        return instance;
    }

    public static final void log(IStatus status) {
        YamlUIPlugin plugin = YamlUIPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            YamlUIPlugin yamlUIPlugin = this;
            synchronized (yamlUIPlugin) {
                this.started = false;
                this.editorPreferenceStore = null;
                this.yamlDocumentProvider = null;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    YamlUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.yaml.ui", "Error occured when dispose module", e));
                }
            }
            this.disposables.clear();
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoppingListener(Disposable listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        YamlUIPlugin yamlUIPlugin = this;
        synchronized (yamlUIPlugin) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.disposables.add(listener);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        if (!this.started) {
            throw new IllegalStateException("Plug-in is not started.");
        }
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register("org.eclipse.statet.yaml/images/obj/YamlDoc", "obj_16", "yaml-doc.png");
        util.register("org.eclipse.statet.yaml/images/obj/Alias", "obj_16", "yaml-alias.png");
    }

    public synchronized IPreferenceStore getEditorPreferenceStore() {
        IPreferenceStore preferenceStore = this.editorPreferenceStore;
        if (preferenceStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.editorPreferenceStore = preferenceStore = CombinedPreferenceStore.createStore((IPreferenceStore[])new IPreferenceStore[]{this.getPreferenceStore(), LtkUI.getPreferenceStore(), EditorsUI.getPreferenceStore()});
        }
        return preferenceStore;
    }

    public synchronized YamlDocumentProvider getYamlDocumentProvider() {
        if (this.yamlDocumentProvider == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.yamlDocumentProvider = new YamlDocumentProvider();
            this.disposables.add(this.yamlDocumentProvider);
        }
        return this.yamlDocumentProvider;
    }

    public synchronized ContextTypeRegistry getYamlEditorTemplateContextTypeRegistry() {
        if (this.yamlEditorTemplateContextTypeRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.yamlEditorTemplateContextTypeRegistry = new WaContributionContextTypeRegistry("org.eclipse.statet.yaml.templates.YamlEditor");
        }
        return this.yamlEditorTemplateContextTypeRegistry;
    }

    public synchronized TemplateStore getYamlEditorTemplateStore() {
        if (this.yamlEditorTemplateStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.yamlEditorTemplateStore = new ContributionTemplateStore(this.getYamlEditorTemplateContextTypeRegistry(), this.getPreferenceStore(), "editor/assist/Yaml/EditorTemplates.store");
            try {
                this.yamlEditorTemplateStore.load();
            }
            catch (IOException e) {
                this.getLog().log((IStatus)new Status(4, "org.eclipse.statet.yaml.ui", 0, "An error occured when loading 'YAML Editor' template store.", (Throwable)e));
            }
        }
        return this.yamlEditorTemplateStore;
    }

    public synchronized ContentAssistComputerRegistry getYamlEditorContentAssistRegistry() {
        if (this.yamlEditorContentAssistRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.yamlEditorContentAssistRegistry = new ContentAssistComputerRegistry("org.eclipse.statet.yaml.contentTypes.Yaml", "org.eclipse.statet.yaml.ui/editor/assist/Yaml");
            this.disposables.add((Disposable)this.yamlEditorContentAssistRegistry);
        }
        return this.yamlEditorContentAssistRegistry;
    }
}

