/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.statet.internal.r.ui.correction.ChangeIfElseAssistProposal;
import org.eclipse.statet.internal.r.ui.correction.ConvertFCallToPipeForwardAssistProposal;
import org.eclipse.statet.internal.r.ui.correction.RLinkedNamesAssistProposal;
import org.eclipse.statet.internal.r.ui.correction.RenameInRegionAssistProposal;
import org.eclipse.statet.internal.r.ui.correction.RenameInWorkspaceAssistProposal;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.QuickAssistComputer;
import org.eclipse.statet.r.core.model.RCoreFunctions;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RModelUtils;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RWorkspaceSourceUnit;
import org.eclipse.statet.r.core.model.rlang.RCompositeSrcStrElement;
import org.eclipse.statet.r.core.model.rlang.RLangSrcStrElement;
import org.eclipse.statet.r.core.refactoring.FCallToPipeForwardRefactoring;
import org.eclipse.statet.r.core.refactoring.IfElseInvertRefactoring;
import org.eclipse.statet.r.core.refactoring.IfNotNullElseToCRefactoring;
import org.eclipse.statet.r.core.refactoring.IfNotNullElseToSpecialRefactoring;
import org.eclipse.statet.r.core.source.RSourceConfig;
import org.eclipse.statet.r.core.source.RSourceConstants;
import org.eclipse.statet.r.core.source.ast.CIfElse;
import org.eclipse.statet.r.core.source.ast.FCall;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.Special;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;

@NonNullByDefault
public class RQuickRefactoringComputer
implements QuickAssistComputer {
    protected static final byte IN_DEFAULT = 1;
    protected static final byte IN_STRING = 2;
    private RAssistInvocationContext rContext = (RAssistInvocationContext)((Object)ObjectUtils.nonNullLateInit());
    protected byte in;
    protected AssistProposalCollector proposals = (AssistProposalCollector)ObjectUtils.nonNullLateInit();

    protected void initR(RAssistInvocationContext context, IProgressMonitor monitor) {
        this.rContext = context;
        this.in = (byte)(context.getInvocationContentType() == "R.String" ? 2 : 1);
    }

    protected void clear() {
        this.rContext = null;
        this.proposals = null;
    }

    protected final RAssistInvocationContext getRContext() {
        return this.rContext;
    }

    public void computeAssistProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        try {
            this.proposals = proposals;
            if (context instanceof RAssistInvocationContext) {
                this.initR((RAssistInvocationContext)context, monitor);
                this.computeAssistProposals(monitor);
            }
        }
        finally {
            this.clear();
        }
    }

    public void computeAssistProposals(IProgressMonitor monitor) {
        RAstNode node;
        block8: {
            node = this.getRContext().getSelectionRAstNode();
            if (node == null) {
                return;
            }
            if (node.getNodeType() == NodeType.SYMBOL || node.getNodeType() == NodeType.STRING_CONST) {
                RAstNode candidate = node;
                while (candidate != null) {
                    ImList attachments = candidate.getAttachments();
                    block1: for (Object attachment : attachments) {
                        if (!(attachment instanceof RElementAccess)) continue;
                        RElementAccess access = (RElementAccess)attachment;
                        while (access != null) {
                            if (access.getSegmentName() == null) continue block1;
                            if (access.getNameNode() == node) {
                                this.addAccessAssistProposals(access);
                                break block8;
                            }
                            access = access.getNextSegment();
                        }
                    }
                    candidate = candidate.getRParent();
                }
            } else if (this.getRContext().getLength() > 0 && this.getRContext().getSourceUnit() != null) {
                this.proposals.add((AssistProposal)new RenameInRegionAssistProposal(this.getRContext()));
            }
        }
        this.addFCallProposals(node);
        this.addFCallArgProposals(node);
        this.addIfElseProposals(node);
        this.addSpecialProposals(node);
    }

    protected void addAccessAssistProposals(RElementAccess access) {
        RAssistInvocationContext context = this.getRContext();
        RAstNode accessNameNode = access.getNameNode();
        if (accessNameNode == null) {
            return;
        }
        ImIdentityList allAccess = ImCollections.toIdentityList((Collection)access.getAllInUnit(false));
        int current = allAccess.indexOf((Object)access);
        if (current < 0) {
            return;
        }
        this.proposals.add((AssistProposal)new RLinkedNamesAssistProposal(1, context, access));
        if (allAccess.size() > 1) {
            this.proposals.add((AssistProposal)new RLinkedNamesAssistProposal(2, context, access));
            this.proposals.add((AssistProposal)new RLinkedNamesAssistProposal(3, context, access));
            TextRegion rChunk = this.getRChunk(context, accessNameNode);
            if (rChunk != null) {
                int chunkBegin = 0;
                int offset = rChunk.getStartOffset();
                while (chunkBegin < current) {
                    RAstNode nameNode = ((RElementAccess)allAccess.get(chunkBegin)).getNameNode();
                    if (nameNode != null && offset <= nameNode.getStartOffset()) break;
                    ++chunkBegin;
                }
                int chunkEnd = current + 1;
                int offset2 = rChunk.getEndOffset();
                while (chunkEnd < allAccess.size()) {
                    RAstNode nameNode = ((RElementAccess)allAccess.get(chunkEnd)).getNameNode();
                    if (nameNode != null && offset2 <= nameNode.getStartOffset()) break;
                    ++chunkEnd;
                }
                if (chunkEnd - chunkBegin > 1) {
                    this.proposals.add((AssistProposal)new RLinkedNamesAssistProposal(4, context, access, rChunk));
                }
            }
        }
        if (context.getSourceUnit() instanceof RWorkspaceSourceUnit) {
            this.proposals.add((AssistProposal)new RenameInWorkspaceAssistProposal(context, accessNameNode));
        }
    }

    protected @Nullable TextRegion getRChunk(RAssistInvocationContext context, RAstNode accessNameNode) {
        List elements;
        RLangSrcStrElement element;
        SourceStructElement sourceElement;
        SourceUnitModelInfo modelInfo = context.getModelInfo();
        if (modelInfo != null && (sourceElement = modelInfo.getSourceElement()) instanceof RCompositeSrcStrElement && (element = (RLangSrcStrElement)LtkModelUtils.getCoveringSourceElement((List)(elements = ((RCompositeSrcStrElement)sourceElement).getCompositeElements()), (int)accessNameNode.getStartOffset())) != null) {
            return element.getSourceRange();
        }
        return null;
    }

    protected void addFCallProposals(RAstNode node) {
        FCallToPipeForwardRefactoring refactoring;
        RefactoringStatus status;
        RSourceUnit sourceUnit = this.getRContext().getSourceUnit();
        FCall fCall = this.findFCall(node);
        if (sourceUnit == null || fCall == null) {
            return;
        }
        RSourceConfig rSourceConfig = this.getRContext().getRCoreAccess().getRSourceConfig();
        FCall.Args args = fCall.getArgsChild();
        if (rSourceConfig.getLangVersion().compareTo(RSourceConstants.LANG_VERSION_4_1) >= 0 && args.getChildCount() > 0 && !(status = (refactoring = new FCallToPipeForwardRefactoring(sourceUnit, fCall)).checkInitialConditions(null)).hasFatalError()) {
            this.proposals.add((AssistProposal)new ConvertFCallToPipeForwardAssistProposal(this.getRContext(), refactoring));
        }
    }

    protected void addFCallArgProposals(RAstNode node) {
        FCallToPipeForwardRefactoring refactoring;
        RefactoringStatus status;
        FCall fCall;
        RSourceUnit sourceUnit = this.getRContext().getSourceUnit();
        FCall.Arg arg = this.findFCallArg(node, (TextRegion)this.getRContext());
        if (sourceUnit == null || arg == null || (fCall = arg.getFCall()) == null) {
            return;
        }
        RSourceConfig rSourceConfig = this.getRContext().getRCoreAccess().getRSourceConfig();
        if (rSourceConfig.getLangVersion().compareTo(RSourceConstants.LANG_VERSION_4_2) >= 0 && arg.hasName() && !(status = (refactoring = new FCallToPipeForwardRefactoring(sourceUnit, fCall, arg)).checkInitialConditions(null)).hasFatalError()) {
            this.proposals.add((AssistProposal)new ConvertFCallToPipeForwardAssistProposal(this.getRContext(), refactoring));
        }
    }

    protected void addIfElseProposals(RAstNode node) {
        IfNotNullElseToSpecialRefactoring refactoring;
        RefactoringStatus status;
        FCall fCall;
        IfElseInvertRefactoring refactoring2;
        RefactoringStatus status2;
        RSourceUnit sourceUnit = this.getRContext().getSourceUnit();
        CIfElse cIfElse = this.findIf(node, (TextRegion)this.getRContext());
        if (sourceUnit == null || cIfElse == null) {
            return;
        }
        RSourceConfig rSourceConfig = this.getRContext().getRCoreAccess().getRSourceConfig();
        RAstNode condNode = cIfElse.getCondChild();
        boolean not = false;
        if (condNode.getNodeType() == NodeType.NOT) {
            not = true;
            condNode = condNode.getChild(0);
        }
        if (cIfElse.hasElse() && !(status2 = (refactoring2 = new IfElseInvertRefactoring(sourceUnit, cIfElse)).checkInitialConditions(null)).hasFatalError()) {
            this.proposals.add((AssistProposal)new ChangeIfElseAssistProposal(this.getRContext(), refactoring2));
        }
        if (condNode.getNodeType() == NodeType.F_CALL && RModelUtils.matches((FCall)(fCall = (FCall)condNode), (RElementName)RCoreFunctions.BASE_IsNull_ELEMENT_NAME) && rSourceConfig.getLangVersion().compareTo(RSourceConstants.LANG_VERSION_4_4) >= 0 && cIfElse.hasElse() && !(status = (refactoring = new IfNotNullElseToSpecialRefactoring(sourceUnit, cIfElse)).checkInitialConditions(null)).hasFatalError()) {
            this.proposals.add((AssistProposal)new ChangeIfElseAssistProposal(this.getRContext(), refactoring));
        }
    }

    protected void addSpecialProposals(RAstNode node) {
        RSourceUnit sourceUnit = this.getRContext().getSourceUnit();
        Special special = this.findSpecial(node, (TextRegion)this.getRContext());
        if (sourceUnit == null || special == null) {
            return;
        }
        if (special.getText() == "||" && this.getRContext().getEndOffset() < special.getRightChild().getStartOffset()) {
            IfNotNullElseToCRefactoring refactoring = new IfNotNullElseToCRefactoring(sourceUnit, special, false);
            RefactoringStatus status = refactoring.checkInitialConditions(null);
            if (!status.hasFatalError()) {
                this.proposals.add((AssistProposal)new ChangeIfElseAssistProposal(this.getRContext(), refactoring));
            }
            if (!(special.getLeftChild().getNodeType() == NodeType.BLOCK && special.getRightChild().getNodeType() == NodeType.BLOCK || (status = (refactoring = new IfNotNullElseToCRefactoring(sourceUnit, special, true)).checkInitialConditions(null)).hasFatalError())) {
                this.proposals.add((AssistProposal)new ChangeIfElseAssistProposal(this.getRContext(), refactoring));
            }
        }
    }

    private @Nullable FCall findFCall(@Nullable RAstNode node) {
        block4: while (true) {
            if (node == null) {
                return null;
            }
            switch (node.getNodeType()) {
                case F_CALL: {
                    return (FCall)node;
                }
                default: {
                    node = node.getRParent();
                    continue block4;
                }
                case SOURCELINES: 
                case COMMENT: 
                case ERROR: 
                case ERROR_TERM: 
                case DUMMY: 
                case BLOCK: 
                case PIPE_FORWARD: 
                case F_CALL_ARGS: 
                case F_CALL_ARG: 
            }
            break;
        }
        return null;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable FCall.Arg findFCallArg(@Nullable RAstNode node, TextRegion region) {
        block5: while (true) {
            if (node == null) {
                return null;
            }
            switch (node.getNodeType()) {
                case F_CALL_ARG: {
                    return (FCall.Arg)node;
                }
                case SYMBOL: 
                case STRING_CONST: {
                    node = node.getRParent();
                    continue block5;
                }
                default: {
                    if (node.getStartOffset() != region.getStartOffset() && node.getEndOffset() != region.getEndOffset()) break block5;
                    node = node.getRParent();
                    continue block5;
                }
                case SOURCELINES: 
                case COMMENT: 
                case ERROR: 
                case ERROR_TERM: 
                case DUMMY: 
                case BLOCK: 
                case PIPE_FORWARD: 
                case F_CALL: 
                case F_CALL_ARGS: 
            }
            break;
        }
        return null;
    }

    private @Nullable CIfElse findIf(@Nullable RAstNode node, TextRegion region) {
        block4: while (true) {
            if (node == null) {
                return null;
            }
            switch (node.getNodeType()) {
                case C_IF: {
                    CIfElse c = (CIfElse)node;
                    if (c.contains(region) && (region.getStartOffset() < c.getThenChild().getStartOffset() || c.hasElse() && region.getStartOffset() >= c.getElseOffset() && region.getStartOffset() <= c.getElseOffset() + 4)) {
                        return c;
                    }
                    return null;
                }
                default: {
                    node = node.getRParent();
                    continue block4;
                }
                case SOURCELINES: 
                case COMMENT: 
                case ERROR: 
                case ERROR_TERM: 
                case DUMMY: 
                case BLOCK: 
                case C_FOR: 
                case C_WHILE: 
                case C_REPEAT: 
            }
            break;
        }
        return null;
    }

    private @Nullable Special findSpecial(@Nullable RAstNode node, TextRegion region) {
        block4: while (true) {
            if (node == null) {
                return null;
            }
            switch (node.getNodeType()) {
                case SPECIAL: {
                    Special special = (Special)node;
                    return special;
                }
                default: {
                    node = node.getRParent();
                    continue block4;
                }
                case SOURCELINES: 
                case COMMENT: 
                case ERROR: 
                case ERROR_TERM: 
                case DUMMY: 
                case BLOCK: 
                case C_IF: 
                case C_FOR: 
                case C_WHILE: 
                case C_REPEAT: 
            }
            break;
        }
        return null;
    }
}

