/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.setup;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolCommandData;
import org.eclipse.statet.nico.core.runtime.ConsoleService;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;
import org.eclipse.statet.nico.core.util.AbstractConsoleCommandHandler;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.statet.nico.ui.views.HistoryView;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

@NonNullByDefault
public class EclipseIDEOperationsHandler
extends AbstractConsoleCommandHandler {
    public static final String OPEN_FILE_COMMAND_ID = "common/openFile";
    @Deprecated
    public static final String OPEN_FILE_COMMAND_OLD_ID = "common/showFile";
    public static final String SHOW_HISTORY_COMMAND_ID = "common/showHistory";

    public Status execute(String id, ConsoleService service, ToolCommandData data, ProgressMonitor m) {
        switch (id) {
            case "common/openFile": 
            case "common/showFile": {
                IFile workspaceFile;
                IFileStore fileStore;
                String fileName = data.getString("filename");
                if (fileName == null && (fileName = data.getString("fileName")) == null) {
                    fileName = data.getStringRequired("filePath");
                }
                ToolWorkspace toolWorkspace = service.getWorkspace();
                try {
                    fileStore = toolWorkspace.toFileStore(fileName);
                    workspaceFile = this.getWorkspaceFile(fileStore, m);
                }
                catch (CoreException e) {
                    ErrorStatus status = new ErrorStatus("org.eclipse.statet.nico.ui", "Failed to resolve filename.", (Throwable)e);
                    service.handleStatus((Status)status, m);
                    return status;
                }
                UIAccess.getDisplay().syncExec(() -> {
                    IWorkbenchPage page = NicoUI.getToolRegistry().findWorkbenchPage((Tool)service.getTool());
                    try {
                        if (workspaceFile != null) {
                            IDE.openEditor((IWorkbenchPage)page, (IFile)workspaceFile);
                        } else {
                            IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                        }
                    }
                    catch (PartInitException e) {
                        ErrorStatus status = new ErrorStatus("org.eclipse.statet.nico.ui", "An error occurred when trying open/activate the Editor.", (Throwable)e);
                        service.handleStatus((Status)status, m);
                    }
                });
                return Status.OK_STATUS;
            }
            case "common/showHistory": {
                String pattern = data.getString("pattern");
                UIAccess.getDisplay().syncExec(() -> {
                    try {
                        IWorkbenchPage page = NicoUI.getToolRegistry().findWorkbenchPage((Tool)service.getTool());
                        HistoryView view = (HistoryView)page.showView("org.eclipse.statet.nico.views.HistoryView");
                        if (pattern != null) {
                            view.search(pattern, false);
                        }
                    }
                    catch (PartInitException e) {
                        ErrorStatus status = new ErrorStatus("org.eclipse.statet.nico.ui", "An error occurred when trying open/activate the History view.", (Throwable)e);
                        service.handleStatus((Status)status, m);
                    }
                });
                return Status.OK_STATUS;
            }
        }
        throw new UnsupportedOperationException();
    }

    private @Nullable IFile getWorkspaceFile(IFileStore fileStore, ProgressMonitor m) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = root.findFilesForLocationURI(fileStore.toURI());
        if (files != null && files.length > 0) {
            IFile file = files[0];
            if (!file.exists()) {
                file.refreshLocal(0, EStatusUtils.convert((ProgressMonitor)m));
            }
            return file;
        }
        return null;
    }
}

