/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;
import org.apache.derby.shared.common.sanity.SanityManager;

public class BitTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        if (otherType.getBaseTypeId().isAnsiUDT()) {
            return false;
        }
        return otherType.isBitTypeId() || otherType.isBlobTypeId() || otherType.userType();
    }

    @Override
    public boolean compatible(TypeId otherType) {
        if (otherType.isBlobTypeId()) {
            return false;
        }
        return otherType.isBitTypeId();
    }

    @Override
    public boolean storable(TypeId otherType, ClassFactory cf) {
        if (otherType.isBlobTypeId()) {
            return false;
        }
        if (otherType.isBitTypeId()) {
            return true;
        }
        return this.userTypeStorable(this.getTypeId(), otherType, cf);
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.BitDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "byte[]";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return dts.getMaximumWidth();
    }

    @Override
    String nullMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 27: {
                return "getNullBit";
            }
            case 232: {
                return "getNullLongVarbit";
            }
            case 29: {
                return "getNullVarbit";
            }
        }
        SanityManager.THROWASSERT("unexpected formatId in nullMethodName() - " + formatId);
        return null;
    }

    @Override
    String dataValueMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 27: {
                return "getBitDataValue";
            }
            case 232: {
                return "getLongVarbitDataValue";
            }
            case 29: {
                return "getVarbitDataValue";
            }
        }
        SanityManager.THROWASSERT("unexpected formatId in dataValueMethodName() - " + formatId);
        return null;
    }
}

