/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.servi.pool;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.statet.internal.rj.servi.Utils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.rj.servi.node.PropertiesBean;
import org.eclipse.statet.rj.servi.pool.PoolConfig;

@NonNullByDefault
public class NetConfig
implements PropertiesBean {
    public static final String BEAN_ID = "netconfig";
    public static final String HOSTADDRESS_ID = "host.address";
    public static final String REGISTRY_PORT_ID = "rmi_registry.address.port";
    public static final String REGISTRY_EMBED_ID = "rmi_registry.embed.enabled";
    public static final String SSL_ENABLED_ID = "ssl.enabled";
    private static final @Nullable String REGISTRY_HOST_DEFAULT = null;
    private static final int REGISTRY_PORT_DEFAULT = -1;
    private static final boolean REGISTRY_EMBED_DEFAULT = true;
    private static final boolean SSL_ENABLED_DEFAULT = false;
    private @Nullable String hostAddress;
    private @Nullable String effectiveHostAddress;
    private int registryPort;
    private int effectiveRegistryPort;
    private boolean registryEmbed;
    private boolean isSSLEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable String getPoolAddress(NetConfig config, String poolId) {
        int registryPort;
        String hostAddress;
        NetConfig netConfig = config;
        synchronized (netConfig) {
            block4: {
                if (config.validate(null)) break block4;
                return null;
            }
            hostAddress = config.effectiveHostAddress;
            registryPort = config.effectiveRegistryPort;
        }
        return NetConfig.getPoolAddress(hostAddress, registryPort, poolId);
    }

    public static @Nullable String getPoolAddress(@Nullable String hostAddress, int registryPort, String poolId) {
        try {
            return new RMIAddress(hostAddress, registryPort, PoolConfig.getPoolName(poolId)).toString();
        }
        catch (IllegalArgumentException | UnknownHostException e) {
            return null;
        }
    }

    public NetConfig() {
        this.loadDefaults();
    }

    public NetConfig(NetConfig config) {
        this.load(config);
    }

    @Override
    public String getBeanId() {
        return BEAN_ID;
    }

    public synchronized void loadDefaults() {
        this.setHostAddress(REGISTRY_HOST_DEFAULT);
        this.setRegistryPort(-1);
        this.setRegistryEmbed(true);
        this.setSSLEnabled(false);
    }

    public synchronized void load(NetConfig templ) {
        this.setHostAddress(templ.hostAddress);
        this.setRegistryPort(templ.registryPort);
        this.setRegistryEmbed(templ.registryEmbed);
        this.setSSLEnabled(templ.isSSLEnabled);
    }

    @Override
    public synchronized void load(Properties map) {
        this.loadDefaults();
        if (map != null) {
            String s = map.getProperty(HOSTADDRESS_ID);
            if (s != null && !s.isEmpty()) {
                this.setHostAddress(s);
            }
            this.setRegistryPort((s = map.getProperty(REGISTRY_PORT_ID)) != null && !s.isEmpty() ? Integer.parseInt(s) : -1);
            s = map.getProperty(REGISTRY_EMBED_ID);
            this.setRegistryEmbed(s != null && !s.isEmpty() ? Boolean.parseBoolean(s) : true);
            s = map.getProperty(SSL_ENABLED_ID);
            this.setSSLEnabled(s != null && !s.isEmpty() ? Boolean.parseBoolean(s) : false);
        }
    }

    @Override
    public synchronized void save(Properties map) {
        Utils.setProperty(map, HOSTADDRESS_ID, this.hostAddress);
        Utils.setProperty(map, REGISTRY_PORT_ID, this.registryPort > 0 ? Integer.toString(this.registryPort) : null);
        map.put(REGISTRY_EMBED_ID, Boolean.toString(this.registryEmbed));
        map.put(SSL_ENABLED_ID, Boolean.toString(this.isSSLEnabled));
    }

    public synchronized @Nullable String getHostAddress() {
        return this.hostAddress;
    }

    public synchronized void setHostAddress(@Nullable String address) {
        this.hostAddress = address;
        this.effectiveHostAddress = null;
    }

    public synchronized @Nullable String getEffectiveHostAddress() {
        return this.effectiveHostAddress;
    }

    public synchronized int getRegistryPort() {
        return this.registryPort;
    }

    public synchronized void setRegistryPort(int port) {
        this.registryPort = port;
        this.effectiveRegistryPort = port <= 0 ? 1099 : port;
    }

    public synchronized int getEffectiveRegistryPort() {
        return this.effectiveRegistryPort;
    }

    public synchronized boolean getRegistryEmbed() {
        return this.registryEmbed;
    }

    public synchronized void setRegistryEmbed(boolean embed) {
        this.registryEmbed = embed;
    }

    public synchronized boolean isSSLEnabled() {
        return this.isSSLEnabled;
    }

    public synchronized void setSSLEnabled(boolean enable) {
        this.isSSLEnabled = enable;
    }

    @Override
    public synchronized boolean validate(@Nullable Collection<PropertiesBean.ValidationMessage> messages) {
        boolean valid = true;
        String effective = this.hostAddress;
        if (effective == null || effective.isEmpty()) {
            effective = System.getProperty("java.rmi.server.hostname");
        }
        try {
            InetAddress inet = null;
            if (effective != null && !effective.isEmpty()) {
                inet = InetAddress.getByName(effective);
            } else {
                try {
                    inet = InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (inet == null) {
                    inet = InetAddress.getLoopbackAddress();
                }
            }
            this.effectiveHostAddress = inet.getHostAddress();
        }
        catch (Exception e) {
            this.effectiveHostAddress = null;
            String msg = e.getMessage();
            if (e instanceof UnknownHostException) {
                msg = "Unknown Host";
            } else if (msg == null) {
                msg = e.getClass().getSimpleName();
            }
            if (messages != null) {
                messages.add(new PropertiesBean.ValidationMessage(HOSTADDRESS_ID, msg));
            }
            valid = false;
        }
        return valid;
    }
}

