/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.statet.ecommons.io.internal.EFSUtilImpl;
import org.eclipse.statet.ecommons.io.internal.WorkspaceUtilImpl;
import org.eclipse.statet.jcommons.io.ByteOrderMark;
import org.eclipse.statet.jcommons.io.IOUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class FileUtil {
    public static IFileStore getLocalFileStore(String s) throws CoreException {
        return FileUtil.getLocalFileStore(s, null);
    }

    public static IFileStore getLocalFileStore(String s, @Nullable IFileStore relativeParent) throws CoreException {
        if (s.length() > 0) {
            URI uri;
            IFileSystem localFS = EFS.getLocalFileSystem();
            if (s.startsWith("file")) {
                try {
                    return localFS.getStore(new URI(s).normalize());
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", e.getReason()));
                }
            }
            IPath path = Path.fromOSString((String)s);
            if (path.isUNC() && (uri = URIUtil.toURI((IPath)path)) != null) {
                return localFS.getStore(uri);
            }
            if (path.isAbsolute()) {
                URI uri2;
                String device = path.getDevice();
                if ((device == null || device.length() <= 2) && (uri2 = URIUtil.toURI((String)s)) != null) {
                    return localFS.getStore(uri2);
                }
            } else if (relativeParent != null && path.getDevice() == null) {
                return relativeParent.getFileStore(path);
            }
        } else if (relativeParent != null) {
            return relativeParent;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", "No local filesystem resource."));
    }

    public static IFileStore getLocalFileStore(String s, @Nullable IContainer relativeParent) throws CoreException {
        if (s.length() > 0) {
            URI uri;
            IFileSystem localFS = EFS.getLocalFileSystem();
            if (s.startsWith("file")) {
                try {
                    return localFS.getStore(new URI(s).normalize());
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", e.getReason()));
                }
            }
            IPath path = Path.fromOSString((String)s);
            if (path.isUNC() && (uri = URIUtil.toURI((IPath)path)) != null) {
                return localFS.getStore(uri);
            }
            if (path.isAbsolute()) {
                URI uri2;
                String device = path.getDevice();
                if ((device == null || device.length() <= 2) && (uri2 = URIUtil.toURI((String)s)) != null) {
                    return localFS.getStore(uri2);
                }
            } else if (relativeParent != null && path.getDevice() == null) {
                return EFS.getStore((URI)relativeParent.getFile(path).getLocationURI().normalize());
            }
        } else if (relativeParent != null) {
            return EFS.getStore((URI)relativeParent.getLocationURI().normalize());
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", "No local filesystem resource."));
    }

    public static IFileStore getFileStore(String location) throws CoreException {
        return FileUtil.getFileStore(location, null);
    }

    public static IFileStore getFileStore(String location, @Nullable IFileStore relativeParent) throws CoreException {
        try {
            return FileUtil.getLocalFileStore(location, relativeParent);
        }
        catch (CoreException coreException) {
            int p = location.indexOf(58);
            if (p > 1) {
                try {
                    URI uri = new URI(location);
                    if (uri.getScheme() != null) {
                        return EFS.getStore((URI)uri);
                    }
                }
                catch (URISyntaxException e) {
                    try {
                        new URI(location.substring(0, p), "a", null);
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", e.getReason()));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", "No supported filesystem resource."));
        }
    }

    public static @Nullable String toString(@Nullable IFileStore fileStore) {
        if (fileStore == null) {
            return null;
        }
        if (fileStore.getFileSystem().getScheme().equals("file")) {
            return fileStore.toString();
        }
        return fileStore.toURI().toString();
    }

    public static IFileStore expandToLocalFileStore(String location, IFileStore parent, String child) throws CoreException {
        IStringVariableManager variables = VariablesPlugin.getDefault().getStringVariableManager();
        String expanded = variables.performStringSubstitution(location);
        IFileStore localFileStore = FileUtil.getLocalFileStore(expanded, parent);
        if (child != null) {
            return localFileStore.getChild(child);
        }
        return localFileStore;
    }

    public static @Nullable IFile getAsWorkspaceFile(URI uri) {
        IFile file;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = URIUtil.toPath((URI)uri);
        if (path != null && (file = root.getFileForLocation(path = path.makeAbsolute())) != null) {
            return file;
        }
        IFile[] files = root.findFilesForLocationURI(uri);
        if (files.length > 0) {
            return files[0];
        }
        return null;
    }

    public static FileUtil getFileUtil(Object file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (file instanceof IFile) {
            return new WorkspaceUtilImpl((IFile)file);
        }
        if (file instanceof IFileStore) {
            IFileStore efsFile = (IFileStore)file;
            IFile iFile = FileUtil.getAsWorkspaceFile(efsFile.toURI());
            if (iFile != null) {
                return new WorkspaceUtilImpl(iFile);
            }
            return new EFSUtilImpl(efsFile);
        }
        throw new IllegalArgumentException("Unknown file object: " + String.valueOf(file.getClass()));
    }

    public abstract long getTimeStamp(IProgressMonitor var1) throws CoreException;

    public abstract String getLabel();

    public abstract @Nullable URI getURI();

    public abstract ReadTextFileOperation createReadTextFileOp(ReaderAction var1);

    public abstract WriteTextFileOperation createWriteTextFileOp(String var1);

    public static abstract class AbstractFileOperation {
        protected int mode = 0;
        protected Charset charset = StandardCharsets.UTF_8;
        protected boolean forceCharset = false;

        protected AbstractFileOperation() {
        }

        public void setFileOperationMode(int mode) {
            this.mode = mode;
        }

        public void setCharset(Charset charset, boolean forceCharset) {
            this.charset = charset;
            this.forceCharset = forceCharset;
        }

        public void doOperation(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
            this.runInEnv(monitor);
        }

        protected abstract void runInEnv(IProgressMonitor var1) throws CoreException, OperationCanceledException;

        protected void runAsWorkspaceRunnable(IProgressMonitor monitor, ISchedulingRule rule) throws CoreException, OperationCanceledException {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable workspaceRunner = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    this.runInEnv(monitor);
                }
            };
            workspace.run(workspaceRunner, rule, 1, monitor);
        }
    }

    protected static class FileInput
    implements Closeable {
        private Charset charset;
        private @Nullable Charset defaultCharset;
        private InputStream stream;

        public FileInput(InputStream input, @Nullable Charset expliciteCharsetHint) throws IOException, CoreException {
            this.stream = input;
            if (expliciteCharsetHint != null) {
                if (expliciteCharsetHint.equals(StandardCharsets.UTF_8) || expliciteCharsetHint.equals(StandardCharsets.UTF_16BE) || expliciteCharsetHint.equals(StandardCharsets.UTF_16LE)) {
                    this.read(input, expliciteCharsetHint);
                }
                this.defaultCharset = expliciteCharsetHint;
            } else {
                this.read(input, null);
            }
            this.charset = this.defaultCharset != null ? this.defaultCharset : StandardCharsets.UTF_8;
        }

        void read(InputStream input, @Nullable Charset charset) throws IOException {
            try {
                int n = 3;
                byte[] bytes = new byte[3];
                int readed = input.read(bytes, 0, 3);
                if (readed == 0) {
                    return;
                }
                int next = 0;
                ByteOrderMark bom = ByteOrderMark.ofStart((byte[])bytes);
                if (bom != null && (charset == null || charset.equals(bom.getCharset()))) {
                    next = bom.getLength();
                    this.defaultCharset = bom.getCharset();
                }
                if (readed - next > 0) {
                    this.stream = new SequenceInputStream(new ByteArrayInputStream(bytes, next, readed - next), input);
                }
            }
            catch (IOException e) {
                IOUtils.close((Closeable)input, (Throwable)e);
                throw e;
            }
        }

        public void setEncoding(@Nullable Charset charset, boolean force) {
            if (charset == null && this.defaultCharset != null) {
                this.charset = this.defaultCharset;
            }
            if (force || this.defaultCharset == null) {
                this.charset = charset;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.stream != null) {
                this.stream.close();
            }
        }

        public @Nullable Charset getDefaultCharset() {
            return this.defaultCharset;
        }

        public Reader getReader() {
            return new InputStreamReader(this.stream, this.charset);
        }
    }

    public abstract class ReadTextFileOperation
    extends AbstractFileOperation {
        protected abstract FileInput getInput(IProgressMonitor var1) throws CoreException, IOException;

        protected abstract ReaderAction getAction();

        @Override
        protected void runInEnv(IProgressMonitor monitor) throws CoreException {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            FileInput fi = null;
            try {
                try {
                    String fileLabel = FileUtil.this.getLabel();
                    m.subTask("Opening " + fileLabel + "...");
                    if (m.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    fi = this.getInput((IProgressMonitor)m.newChild(10));
                    fi.setEncoding(this.charset, this.forceCharset);
                    Throwable throwable = null;
                    Object var6_9 = null;
                    try (BufferedReader reader = new BufferedReader(fi.getReader());){
                        m.worked(5);
                        m.subTask("Reading " + fileLabel + "...");
                        this.getAction().run(reader, (IProgressMonitor)m.newChild(80));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (UnsupportedEncodingException | UnsupportedCharsetException e) {
                    IOUtils.close(fi, (Throwable)e);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", 0, "The selected charset is unsupported on your system.", (Throwable)e));
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", 0, "Error while reading the file.", (Throwable)e));
                }
            }
            finally {
                m.done();
            }
        }
    }

    public static interface ReaderAction {
        public void run(BufferedReader var1, IProgressMonitor var2) throws IOException, CoreException;
    }

    public abstract class WriteTextFileOperation
    extends AbstractFileOperation {
        protected WriteTextFileOperation() {
        }

        protected abstract void writeImpl(SubMonitor var1) throws CoreException, UnsupportedEncodingException, IOException;

        @Override
        protected void runInEnv(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)("Writing to " + FileUtil.this.getLabel()), (int)100);
            try {
                try {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    this.writeImpl(m);
                }
                catch (UnsupportedEncodingException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", 0, "The selected charset is unsupported on your system.", (Throwable)e));
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", 0, "Error while writing to file.", (Throwable)e));
                }
            }
            finally {
                m.done();
            }
        }
    }
}

