/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui.rexpr;

import com.ibm.icu.text.DecimalFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.ui.components.DoubleText;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.r.core.model.RGraphicFunctions;
import org.eclipse.statet.r.core.source.ast.RParser;
import org.eclipse.statet.r.ui.graphics.RAlphaChooser;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprTypeUIAdapter;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprWidget;
import org.eclipse.statet.rtm.rtdata.types.RTypedExpr;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.statushandlers.StatusManager;

public class AlphaType
extends RExprWidget.TypeDef
implements PaintListener,
Listener {
    private Button detail;
    private Float currentValue;
    private int current255 = -1;
    private Color currentSWTColor;
    private RAlphaChooser alphaChooser;
    private final RGraphicFunctions rGraphicFunctions = RGraphicFunctions.DEFAULT;

    public AlphaType(RExprTypeUIAdapter type) {
        super(type);
    }

    @Override
    public boolean hasDetail() {
        return true;
    }

    @Override
    protected Control createDetailControl(Composite parent) {
        this.detail = new Button(parent, 0);
        this.detail.addPaintListener((PaintListener)this);
        this.detail.addListener(13, (Listener)this);
        this.detail.addListener(12, (Listener)this);
        return this.detail;
    }

    @Override
    public void valueAboutToChange(ObjValueEvent<RTypedExpr> event) {
        RTypedExpr newExpr = (RTypedExpr)event.newValue;
        Float newValue = null;
        try {
            if (newExpr != null && newExpr.getTypeKey() == "r") {
                RParser rParser = RExprWidget.getDisplayRParser();
                newValue = this.rGraphicFunctions.parseAlpha(rParser.parseExpr((TextParserInput)new StringParserInput(newExpr.getExpr()).init()));
            }
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.rtm.base.ui", "An error occurred when parsing the R alpha value expression.", (Throwable)e));
        }
        this.doSetValue(newValue);
        this.detail.redraw();
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        Point size = this.detail.getSize();
        gc.setForeground(gc.getDevice().getSystemColor(16));
        gc.drawRectangle(4, 4, size.x - 9, size.y - 9);
        if (this.currentValue != null) {
            if (this.currentSWTColor == null) {
                this.currentSWTColor = new Color(this.current255, this.current255, this.current255);
            }
            RAlphaChooser.drawPreview((GC)gc, (int)5, (int)5, (int)(size.x - 11), (int)(size.y - 11), (Color)this.currentSWTColor);
        }
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 13: {
                this.showColorChooser();
                return;
            }
            case 12: {
                if (this.alphaChooser != null) {
                    this.alphaChooser.dispose();
                }
                return;
            }
        }
    }

    private void showColorChooser() {
        if (this.alphaChooser == null) {
            this.alphaChooser = new RAlphaChooser(){

                protected void onOK() {
                    AlphaType.this.setValue(this.getValue());
                }
            };
        }
        if (this.alphaChooser.isActive()) {
            this.alphaChooser.close();
            return;
        }
        Rectangle bounds = this.detail.getBounds();
        Point location = this.detail.getParent().toDisplay(new Point(bounds.x, bounds.y));
        bounds.x = location.x;
        bounds.y = location.y;
        this.alphaChooser.open(this.detail.getShell(), bounds, this.currentValue);
    }

    private void setValue(Float value) {
        if (value == null) {
            this.setExpr("");
            return;
        }
        StringBuilder sb = new StringBuilder();
        DecimalFormat format = DoubleText.createFormat((int)3);
        sb.append(format.format(value.doubleValue()));
        this.doSetValue(value);
        this.detail.redraw();
        this.setExpr(sb.toString());
    }

    private void doSetValue(Float value) {
        if (value != null) {
            int v255 = 255 - Math.round(value.floatValue() * 255.0f);
            if (this.currentSWTColor != null && v255 != this.current255) {
                this.currentSWTColor = null;
            }
            this.currentValue = value;
            this.current255 = v255;
        } else {
            this.currentValue = null;
        }
    }
}

