/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui;

import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.rlang.RFrame;
import org.eclipse.statet.r.core.model.rlang.RFrameSearchPath;
import org.eclipse.statet.r.core.model.rlang.RLangElement;
import org.eclipse.statet.r.core.model.rlang.RLangMethod;

@NonNullByDefault
public class FCallNamePattern {
    private final RElementName elementName;
    private final @Nullable String packageName;
    private final @Nullable String assignName;
    private final int assignLength;

    public FCallNamePattern(RElementName name) {
        this.elementName = name;
        RElementName scope = name.getScope();
        String string = this.packageName = scope != null && RElementName.isPackageFacetScopeType((int)scope.getType()) ? scope.getSegmentName() : null;
        if (this.elementName.getNextSegment() == null) {
            this.assignName = this.elementName.getSegmentName();
            this.assignLength = this.assignName.length();
        } else {
            this.assignName = null;
            this.assignLength = 0;
        }
    }

    public final RElementName getElementName() {
        return this.elementName;
    }

    public boolean matches(RElementName candidateName) {
        String candidate0;
        return candidateName != null && (this.elementName.equals((Object)candidateName, (byte)1) || this.assignName != null && candidateName.getNextSegment() == null && this.assignLength == (candidate0 = candidateName.getSegmentName()).length() - 2 && this.elementName.getType() == candidateName.getType() && candidate0.charAt(this.assignLength) == '<' && candidate0.charAt(this.assignLength + 1) == '-' && candidate0.regionMatches(false, 0, this.assignName, 0, this.assignLength));
    }

    public void searchFDef(RFrameSearchPath searchPath) {
        RFrameSearchPath.Iterator iter = searchPath.iterator();
        while (iter.hasNext()) {
            RElementName frameName;
            RFrame frame = iter.next();
            if (this.packageName != null && ((frameName = frame.getElementName()) == null || !RElementName.isPackageFacetScopeType((int)frameName.getType()) || !this.packageName.equals(frameName.getSegmentName()))) continue;
            List elements = frame.getModelChildren(null);
            for (RLangElement candidate : elements) {
                if (candidate.getModelTypeId() != "R" || (candidate.getElementType() & 0xF00) != 1280 || !this.matches(candidate.getElementName())) continue;
                this.handleMatch((RLangMethod)candidate, frame, iter);
            }
        }
    }

    protected void handleMatch(RLangMethod<?> element, RFrame<?> frame, RFrameSearchPath.Iterator iterator) {
    }
}

