/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.PhraseMatcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;

class PhraseScorer
extends Scorer {
    final PhraseMatcher matcher;
    final boolean needsScores;
    private final Similarity.SimScorer simScorer;
    final float matchCost;
    private float freq = 0.0f;

    PhraseScorer(Weight weight, PhraseMatcher matcher, boolean needsScores, Similarity.SimScorer simScorer) {
        super(weight);
        this.matcher = matcher;
        this.needsScores = needsScores;
        this.simScorer = simScorer;
        this.matchCost = matcher.getMatchCost();
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return new TwoPhaseIterator(this.matcher.approximation){

            @Override
            public boolean matches() throws IOException {
                PhraseScorer.this.matcher.reset();
                PhraseScorer.this.freq = 0.0f;
                return PhraseScorer.this.matcher.nextMatch();
            }

            @Override
            public float matchCost() {
                return PhraseScorer.this.matchCost;
            }
        };
    }

    @Override
    public int docID() {
        return this.matcher.approximation.docID();
    }

    @Override
    public float score() throws IOException {
        if (this.freq == 0.0f) {
            this.freq = this.matcher.sloppyWeight(this.simScorer);
            while (this.matcher.nextMatch()) {
                this.freq += this.matcher.sloppyWeight(this.simScorer);
            }
        }
        return this.simScorer.score(this.docID(), this.freq);
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    public String toString() {
        return "PhraseScorer(" + this.weight + ")";
    }
}

