/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.net.core;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.net.Port;
import org.eclipse.statet.jcommons.net.core.PortForwardingL;
import org.eclipse.statet.jcommons.net.core.RSAccessClientSession;
import org.eclipse.statet.jcommons.net.core.RemoteProcess;
import org.eclipse.statet.jcommons.net.core.RemoteSocket;
import org.eclipse.statet.jcommons.net.core.TunnelClientSocketImpl;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.runtime.ProcessConfig;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public abstract class BasicRSAccessClientSession<TSession>
implements RSAccessClientSession {
    private static final byte S_CONNECTING = 1;
    private static final byte S_CONNECTED = 2;
    private static final byte S_DISCONNECTED = 3;
    private volatile byte state;
    private volatile @Nullable TSession session;
    private final CopyOnWriteIdentityListSet<RSAccessClientSession.Listener> listeners = new CopyOnWriteIdentityListSet();
    private final @Nullable Duration timeout;
    private final Map<InetSocketAddress, SessionPortForwarding> managedPortForwardings = new HashMap<InetSocketAddress, SessionPortForwarding>();

    protected BasicRSAccessClientSession(@Nullable Duration timeout) {
        this.timeout = timeout;
    }

    @Override
    public void addListener(RSAccessClientSession.Listener listener) {
        this.listeners.add(ObjectUtils.nonNullAssert(listener));
    }

    @Override
    public void removeListener(RSAccessClientSession.Listener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners(RSAccessClientSession.Event event) {
        for (RSAccessClientSession.Listener listener : this.listeners) {
            try {
                listener.onSessionChanged(event);
            }
            catch (RuntimeException e) {
                ObjectUtils.ToStringBuilder sb = this.buildToString();
                sb.addProp("listener", listener);
                sb.addProp("event", event);
                sb.getStringBuilder().insert(0, "An error occurred while notifying a listener of: ");
                CommonsRuntime.log(new ErrorStatus("org.eclipse.statet.jcommons.util", sb.toString(), e));
            }
        }
    }

    @Override
    public boolean isConnected() {
        TSession session;
        if (this.state == 2 && (session = this.session) != null) {
            if (this.isConnected(session)) {
                return true;
            }
            this.disconnect();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConnected(TSession session) {
        BasicRSAccessClientSession basicRSAccessClientSession = this;
        synchronized (basicRSAccessClientSession) {
            if (this.state != 1) {
                throw new IllegalStateException();
            }
            this.state = (byte)2;
            this.session = session;
        }
    }

    protected boolean isConnected(TSession session) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ProgressMonitor m) throws StatusException {
        try {
            BasicRSAccessClientSession basicRSAccessClientSession = this;
            synchronized (basicRSAccessClientSession) {
                this.state = 1;
            }
            TSession session = this.connect(this.timeout, m);
            this.setConnected(session);
        }
        catch (Exception e) {
            StatusException se;
            this.disconnect(e);
            if (e instanceof StatusException && (se = (StatusException)e).getStatus().getSeverity() == 8) {
                throw se;
            }
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", "Failed to connect to remote host.", e));
        }
    }

    @Override
    public void disconnect() {
        this.disconnect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect(@Nullable Exception reason) {
        block20: {
            TSession session;
            BasicRSAccessClientSession basicRSAccessClientSession = this;
            synchronized (basicRSAccessClientSession) {
                if (this.state == 3) {
                    return;
                }
                session = this.session;
                this.state = (byte)3;
                this.session = null;
            }
            try {
                try {
                    this.disconnect(session);
                }
                catch (Exception e) {
                    if (reason != null) {
                        reason.addSuppressed(e);
                    } else {
                        CommonsRuntime.log(new ErrorStatus("org.eclipse.statet.jcommons.util", String.format("Failed to close %1$s session.", this.getTarget().getType()), e));
                    }
                    Map<InetSocketAddress, SessionPortForwarding> map = this.managedPortForwardings;
                    synchronized (map) {
                        this.managedPortForwardings.clear();
                    }
                    this.notifyListeners(new RSAccessClientSession.Event(RSAccessClientSession.Event.Type.DISCONNECT, this));
                    break block20;
                }
            }
            catch (Throwable throwable) {
                Map<InetSocketAddress, SessionPortForwarding> map = this.managedPortForwardings;
                synchronized (map) {
                    this.managedPortForwardings.clear();
                }
                this.notifyListeners(new RSAccessClientSession.Event(RSAccessClientSession.Event.Type.DISCONNECT, this));
                throw throwable;
            }
            Map<InetSocketAddress, SessionPortForwarding> map = this.managedPortForwardings;
            synchronized (map) {
                this.managedPortForwardings.clear();
            }
            this.notifyListeners(new RSAccessClientSession.Event(RSAccessClientSession.Event.Type.DISCONNECT, this));
        }
    }

    protected abstract TSession connect(@Nullable Duration var1, ProgressMonitor var2) throws Exception;

    protected abstract void disconnect(@Nullable TSession var1) throws Exception;

    protected final @Nullable TSession getSession() {
        return this.session;
    }

    protected final TSession checkSession() throws StatusException {
        TSession session = this.session;
        if (session == null) {
            throw new StatusException(new InfoStatus("org.eclipse.statet.jcommons.util", String.format("The %1$s session is closed.", this.getTarget().getType())));
        }
        return session;
    }

    protected InetSocketAddress createTargetLocalhostAddress(Port port) {
        return InetSocketAddress.createUnresolved(this.getTargetLocalhostString(), port.get());
    }

    protected @Nullable Duration getTimeout() {
        return this.timeout;
    }

    @Override
    public RemoteProcess exec(ProcessConfig processConfig, ProgressMonitor m) throws StatusException {
        try {
            TSession session = this.checkSession();
            return this.exec(session, processConfig, this.getTimeout(), m);
        }
        catch (Exception e) {
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", "Failed to execute remote command.", e));
        }
    }

    protected abstract RemoteProcess exec(TSession var1, ProcessConfig var2, @Nullable Duration var3, ProgressMonitor var4) throws Exception;

    @Override
    public Socket createDirectTcpIpSocket(InetSocketAddress targetAddress, ProgressMonitor m) throws StatusException {
        try {
            TSession session = this.checkSession();
            TunnelClientSocketImpl socketImpl = this.createDirectTcpIpSocketImpl(session);
            RemoteSocket socket = new RemoteSocket(socketImpl);
            socket.connect(targetAddress, this.getTimeout(), m);
            return socket;
        }
        catch (Exception e) {
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", "Failed to create remote socket.", e));
        }
    }

    @Override
    public Socket createDirectTcpIpSocket(Port targetPort, ProgressMonitor m) throws StatusException {
        return this.createDirectTcpIpSocket(this.createTargetLocalhostAddress(targetPort), m);
    }

    protected abstract TunnelClientSocketImpl createDirectTcpIpSocketImpl(TSession var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortForwardingL allocatePortForwardingL(InetSocketAddress targetAddress) throws StatusException {
        try {
            SessionPortForwarding managed;
            TSession session = this.checkSession();
            Map<InetSocketAddress, SessionPortForwarding> map = this.managedPortForwardings;
            synchronized (map) {
                managed = this.managedPortForwardings.get(targetAddress);
                if (managed != null) {
                    return managed.createHandle();
                }
            }
            InetSocketAddress localAddress = this.startPortForwardingL(session, targetAddress, this.getTimeout());
            managed = new SessionPortForwarding(targetAddress, localAddress);
            Map<InetSocketAddress, SessionPortForwarding> map2 = this.managedPortForwardings;
            synchronized (map2) {
                this.checkSession();
                this.managedPortForwardings.put(targetAddress, managed);
                return managed.createHandle();
            }
        }
        catch (Exception e) {
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", "Failed to start local port forwarding.", e));
        }
    }

    @Override
    public PortForwardingL allocatePortForwardingL(Port targetPort) throws StatusException {
        return this.allocatePortForwardingL(this.createTargetLocalhostAddress(targetPort));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePortForwarding(PortForwardingL handle) throws StatusException {
        try {
            SessionPortForwarding managed;
            TSession session = this.getSession();
            if (session == null) {
                return;
            }
            Map<InetSocketAddress, SessionPortForwarding> map = this.managedPortForwardings;
            synchronized (map) {
                managed = this.managedPortForwardings.get(handle.getTargetAddress());
                if (managed == null || !managed.removeHandle(handle)) {
                    throw new IllegalArgumentException();
                }
                if (managed.hasHandles()) {
                    return;
                }
                this.managedPortForwardings.remove(handle.getTargetAddress());
            }
            this.stopPortForwardingL(session, managed.getTargetAddress(), managed.getLocalAddress(), this.getTimeout());
        }
        catch (Exception e) {
            if (this.state != 2) {
                return;
            }
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", "Failed to stop local port forwarding.", e));
        }
    }

    protected abstract InetSocketAddress startPortForwardingL(TSession var1, InetSocketAddress var2, @Nullable Duration var3) throws Exception;

    protected abstract void stopPortForwardingL(TSession var1, InetSocketAddress var2, InetSocketAddress var3, @Nullable Duration var4) throws Exception;

    public String toString() {
        return this.buildToString().toString();
    }

    protected abstract ObjectUtils.ToStringBuilder buildToString();

    private static class SessionPortForwarding {
        private final InetSocketAddress targetAddress;
        private final InetSocketAddress localAddress;
        private final List<PortForwardingL> handles = new ArrayList<PortForwardingL>();

        public SessionPortForwarding(InetSocketAddress targetAddress, InetSocketAddress localAddress) {
            this.targetAddress = targetAddress;
            this.localAddress = localAddress;
        }

        public InetSocketAddress getTargetAddress() {
            return this.targetAddress;
        }

        public InetSocketAddress getLocalAddress() {
            return this.localAddress;
        }

        public PortForwardingL createHandle() {
            PortForwardingL handle = new PortForwardingL(this.targetAddress, this.localAddress);
            this.handles.add(handle);
            return handle;
        }

        public boolean removeHandle(PortForwardingL handle) {
            return this.handles.remove(handle);
        }

        public boolean hasHandles() {
            return !this.handles.isEmpty();
        }
    }
}

