/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.util;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.ui.components.ShortedLabel;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ToolInfoGroup {
    public static int WIDE = 1;
    private final ToolProcess process;
    private ViewForm form;
    private final int flags;

    public ToolInfoGroup(Composite parent, ToolProcess process) {
        this(parent, 0, process);
    }

    public ToolInfoGroup(Composite parent, int flags, ToolProcess process) {
        this.process = process;
        this.flags = flags;
        this.createControls(parent);
    }

    private void createControls(Composite parent) {
        this.form = new ViewForm(parent, 0x800800);
        Composite info = new Composite((Composite)this.form, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = (this.flags & WIDE) != 0 ? 3 : 2;
        layout.verticalSpacing = (this.flags & WIDE) != 0 ? 1 : 2;
        info.setLayout((Layout)layout);
        this.form.setContent((Control)info);
        Label text = new Label(info, 0);
        Image image = NicoUITools.getImage(this.process);
        if (image != null) {
            text.setImage(image);
        } else {
            text.setText("(i)");
        }
        GridData gd = new GridData(128, 16384, false, false);
        gd.horizontalSpan = 1;
        gd.verticalSpan = 2;
        text.setLayoutData((Object)gd);
        ShortedLabel detail1 = new ShortedLabel(info, 0);
        detail1.setText(this.process.getLabel(1));
        detail1.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ShortedLabel detail2 = new ShortedLabel(info, 0);
        String wd = FileUtil.toString((IFileStore)this.process.getWorkspace().getWorkspaceDir());
        detail2.setText((String)(wd != null ? " \u2219  " + wd : "                                                  "));
        detail2.getControl().setLayoutData((Object)new GridData(4, 128, true, false));
    }

    public Control getControl() {
        return this.form;
    }
}

