/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core.http.ee10;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rhelp.core.http.MediaTypeProvider;
import org.eclipse.statet.rhelp.core.http.ee10.ResourceHandler;

@NonNullByDefault
public class SimpleResourceHandler
implements ResourceHandler {
    private final MediaTypeProvider defaultMediaTypes;
    private @Nullable MediaTypeProvider specialMediaTypes;
    private @Nullable String cacheControl;

    public SimpleResourceHandler(MediaTypeProvider mediaTypes) {
        this.defaultMediaTypes = (MediaTypeProvider)ObjectUtils.nonNullAssert((Object)mediaTypes);
    }

    @Override
    public void setSpecialMediaTypes(MediaTypeProvider types) {
        this.specialMediaTypes = types;
    }

    private @Nullable String getMediaType(String fileName) {
        String type = null;
        MediaTypeProvider specialMediaTypes = this.specialMediaTypes;
        if (specialMediaTypes != null) {
            type = specialMediaTypes.getMediaTypeString(fileName);
        }
        if (type == null) {
            type = this.defaultMediaTypes.getMediaTypeString(fileName);
        }
        return type;
    }

    @Override
    public void setCacheControl(String value) {
        this.cacheControl = value;
    }

    @Override
    public void doGet(Path file, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            String cacheControl;
            in.available();
            String mediaType = this.getMediaType(((Path)ObjectUtils.nonNullAssert((Object)file.getFileName())).toString());
            if (mediaType != null) {
                resp.setContentType(mediaType);
            }
            if ((cacheControl = this.cacheControl) != null) {
                resp.setHeader("Cache-Control", cacheControl);
            }
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (ServletOutputStream out = resp.getOutputStream();){
                in.transferTo((OutputStream)out);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }
}

