/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FragListBuilder;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.ScoreOrderFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.SimpleFragListBuilder;
import org.eclipse.statet.internal.rhelp.core.RHelpSearchMatchImpl;
import org.eclipse.statet.internal.rhelp.core.index.DocFieldVisitorCollector;
import org.eclipse.statet.internal.rhelp.core.index.HighlightBoundaryScanner;
import org.eclipse.statet.internal.rhelp.core.index.Highlighter;
import org.eclipse.statet.internal.rhelp.core.index.REnvIndexSchema;
import org.eclipse.statet.internal.rhelp.core.index.REnvIndexSearchQuery;
import org.eclipse.statet.internal.rhelp.core.index.REnvIndexUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.RHelpSearchMatch;
import org.eclipse.statet.rhelp.core.RHelpSearchRequestor;
import org.eclipse.statet.rhelp.core.RPkgHelp;

@NonNullByDefault
public class RequestStreamCollector
extends DocFieldVisitorCollector.Visitor
implements REnvIndexSchema {
    private static final Highlighter HIGHLIGHTER;
    private static final ImSet<String> LOAD_ID_SELECTOR;
    private final REnvIndexSearchQuery indexQuery;
    private final Map<String, RPkgHelp> packageMap;
    private final RHelpSearchRequestor requestor;
    private final List<RHelpSearchMatch.MatchFragment> fragmentCollection = new ArrayList<RHelpSearchMatch.MatchFragment>();
    private @Nullable FieldQuery fieldQuery;
    private final int maxNumFragments;
    private LeafReader reader;
    private int doc;
    private float score;
    private @Nullable String pkgName;
    private @Nullable String pageName;

    static {
        SimpleFragListBuilder fragListBuilder = new SimpleFragListBuilder(10);
        ScoreOrderFragmentsBuilder fragmentsBuilder = new ScoreOrderFragmentsBuilder((BoundaryScanner)new HighlightBoundaryScanner());
        fragmentsBuilder.setDiscreteMultiValueHighlighting(true);
        HIGHLIGHTER = new Highlighter(true, true, (FragListBuilder)fragListBuilder, (FragmentsBuilder)fragmentsBuilder);
        LOAD_ID_SELECTOR = ImCollections.newSet((Object[])new String[]{"page", "pkg"});
    }

    public RequestStreamCollector(REnvIndexSearchQuery indexQuery, Map<String, RPkgHelp> packageMap, RHelpSearchRequestor requestor) throws IOException {
        super((Set<String>)LOAD_ID_SELECTOR);
        this.indexQuery = indexQuery;
        this.packageMap = packageMap;
        this.requestor = requestor;
        this.maxNumFragments = requestor.getMaxFragments();
    }

    @Override
    public void setReader(LeafReader reader) throws IOException {
        this.reader = reader;
        this.fieldQuery = this.indexQuery.getQuery() != null && this.indexQuery.fieldNames != null && this.indexQuery.fieldNames.size() > 0 && this.maxNumFragments > 0 ? HIGHLIGHTER.getFieldQuery(this.indexQuery.getQuery(), (IndexReader)this.reader) : null;
    }

    @Override
    public void newDocMatch(int doc, float score) {
        this.doc = doc;
        this.score = score;
        this.pkgName = null;
        this.pageName = null;
    }

    public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
        switch (fieldInfo.name) {
            case "pkg": {
                this.pkgName = REnvIndexUtils.toString(value);
                return;
            }
            case "page": {
                this.pageName = REnvIndexUtils.toString(value);
                return;
            }
        }
    }

    @Override
    public void finalizeDocMatch() throws IOException {
        RHelpPage page;
        RPkgHelp pkgHelp;
        if (this.pkgName != null && this.pageName != null && (pkgHelp = this.packageMap.get(this.pkgName)) != null && (page = pkgHelp.getPage(this.pageName)) != null) {
            int matchCount = this.checkMatches();
            RHelpSearchMatchImpl match = matchCount >= 0 ? new RHelpSearchMatchImpl(page, this.score, matchCount, this.fragmentCollection.toArray(new RHelpSearchMatch.MatchFragment[this.fragmentCollection.size()])) : new RHelpSearchMatchImpl(page, this.score);
            this.requestor.matchFound(match);
            return;
        }
    }

    private int checkMatches() throws IOException {
        FieldQuery fieldQuery = this.fieldQuery;
        if (fieldQuery == null) {
            return -1;
        }
        AtomicInteger counter = new AtomicInteger();
        this.fragmentCollection.clear();
        for (String fieldName : this.indexQuery.fieldNames) {
            @NonNull String[] fragments = HIGHLIGHTER.getBestFragments(fieldQuery, (IndexReader)this.reader, this.doc, fieldName, 80, this.maxNumFragments, RHelpSearchMatch.PRE_TAGS, RHelpSearchMatch.POST_TAGS, Highlighter.DEFAULT_ENCODER, counter);
            if (fragments == null) continue;
            int j = 0;
            while (j < fragments.length) {
                this.fragmentCollection.add(new RHelpSearchMatchImpl.Fragment(fieldName, fragments[j]));
                ++j;
            }
        }
        return counter.get();
    }
}

