/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.internal.ltk.core.LtkCorePlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.impl.BasicWorkingBuffer;

@NonNullByDefault
public class FileBufferWorkingBuffer
extends BasicWorkingBuffer {
    private @Nullable ITextFileBuffer fileBuffer;

    public FileBufferWorkingBuffer(SourceUnit unit) {
        super(unit);
    }

    @Override
    protected final byte getContentMode() {
        return 1;
    }

    @Override
    protected @Nullable AbstractDocument createDocument(SubMonitor m) {
        IDocument fileDoc;
        ITextFileBuffer fileBuffer = null;
        switch (this.detectResourceMode()) {
            case 1: {
                IPath path = ((IFile)this.unit.getResource()).getFullPath();
                try {
                    FileBuffers.getTextFileBufferManager().connect(path, LocationKind.IFILE, (IProgressMonitor)m);
                    fileBuffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(path, LocationKind.IFILE);
                }
                catch (CoreException e) {
                    LtkCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", -1, "An error occurred when allocating the document of the file buffer.", (Throwable)e));
                }
                break;
            }
            case 2: {
                IFileStore store = (IFileStore)this.unit.getResource();
                try {
                    FileBuffers.getTextFileBufferManager().connectFileStore(store, (IProgressMonitor)m);
                    fileBuffer = FileBuffers.getTextFileBufferManager().getFileStoreTextFileBuffer(store);
                }
                catch (CoreException e) {
                    LtkCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", -1, "An error occurred when allocating the document of the file buffer.", (Throwable)e));
                }
                break;
            }
            default: {
                return super.createDocument(m);
            }
        }
        this.fileBuffer = fileBuffer;
        if (fileBuffer != null && (fileDoc = fileBuffer.getDocument()) instanceof AbstractDocument) {
            return (AbstractDocument)fileDoc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable ITextFileBuffer getBuffer() {
        FileBufferWorkingBuffer fileBufferWorkingBuffer = this;
        synchronized (fileBufferWorkingBuffer) {
            ITextFileBuffer fileBuffer = this.fileBuffer;
            if (fileBuffer != null) {
                return fileBuffer;
            }
        }
        switch (this.getResourceMode()) {
            case 1: {
                IPath path = ((IFile)this.unit.getResource()).getFullPath();
                return FileBuffers.getTextFileBufferManager().getTextFileBuffer(path, LocationKind.IFILE);
            }
            case 2: {
                IFileStore store = (IFileStore)this.unit.getResource();
                return FileBuffers.getTextFileBufferManager().getFileStoreTextFileBuffer(store);
            }
        }
        return null;
    }

    @Override
    protected SourceContent createContent(SubMonitor m) throws CoreException {
        ITextFileBuffer buffer;
        if (this.detectResourceMode() > 0 && (buffer = this.getBuffer()) != null) {
            return FileBufferWorkingBuffer.createContentFromDocument(buffer.getDocument());
        }
        return super.createContent(m);
    }

    @Override
    public void releaseDocument(IProgressMonitor monitor) {
        if (this.fileBuffer != null) {
            try {
                try {
                    SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
                    switch (this.getResourceMode()) {
                        case 1: {
                            IPath path = ((IFile)this.unit.getResource()).getFullPath();
                            FileBuffers.getTextFileBufferManager().disconnect(path, LocationKind.IFILE, (IProgressMonitor)m);
                            break;
                        }
                        case 2: {
                            IFileStore store = (IFileStore)this.unit.getResource();
                            FileBuffers.getTextFileBufferManager().disconnectFileStore(store, (IProgressMonitor)m);
                            break;
                        }
                    }
                }
                catch (CoreException e) {
                    LtkCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", -1, "An error occurred when releasing the document of the file buffer.", (Throwable)e));
                    this.fileBuffer = null;
                    super.releaseDocument(monitor);
                }
            }
            finally {
                this.fileBuffer = null;
                super.releaseDocument(monitor);
            }
        } else {
            super.releaseDocument(monitor);
        }
    }

    @Override
    public boolean checkState(boolean validate, IProgressMonitor monitor) {
        ITextFileBuffer buffer = this.fileBuffer;
        if (buffer != null) {
            if (!validate && !buffer.isStateValidated()) {
                return true;
            }
            if (validate && !buffer.isStateValidated()) {
                try {
                    buffer.validateState(monitor, IWorkspace.VALIDATE_PROMPT);
                }
                catch (CoreException e) {
                    LtkCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", -1, "An error occurred when validating file buffer state.", (Throwable)e));
                }
            }
        }
        return super.checkState(validate, monitor);
    }

    @Override
    public boolean isSynchronized() {
        ITextFileBuffer buffer;
        if (this.detectResourceMode() > 0 && (buffer = this.getBuffer()) != null) {
            return !buffer.isDirty();
        }
        return true;
    }
}

