/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceContainerElement;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;

@NonNullByDefault
public final class LtkModelUtils {
    public static @Nullable LtkModelElement<?> getModelElement(@Nullable Object element) {
        if (element instanceof LtkModelElement) {
            return (LtkModelElement)element;
        }
        if (element instanceof IAdaptable) {
            return (LtkModelElement)((IAdaptable)element).getAdapter(LtkModelElement.class);
        }
        return null;
    }

    public static @Nullable SourceUnit getSourceUnit(@Nullable LtkModelElement<?> element) {
        if (element instanceof SourceUnit) {
            return (SourceUnit)element;
        }
        if (element instanceof SourceElement) {
            return ((SourceElement)element).getSourceUnit();
        }
        return null;
    }

    public static @Nullable SourceContainerElement<?> getSourceContainerElement(@Nullable SourceStructElement<?, ?> element) {
        while (element != null) {
            if (element instanceof SourceContainerElement) {
                return (SourceContainerElement)((Object)element);
            }
            element = element.getSourceParent();
        }
        return null;
    }

    public static final <T> boolean hasChildren(List<? extends @NonNull T> children, @Nullable LtkModelElementFilter<? super @NonNull T> filter) {
        if (filter == null) {
            return !children.isEmpty();
        }
        for (T child : children) {
            if (!filter.include(child)) continue;
            return true;
        }
        return false;
    }

    public static final <T> List<? extends T> getChildren(List<? extends @NonNull T> children, @Nullable LtkModelElementFilter<? super @NonNull T> filter) {
        if (filter == null) {
            return children;
        }
        ArrayList<T> filtered = new ArrayList<T>(children.size());
        for (T child : children) {
            if (!filter.include(child)) continue;
            filtered.add(child);
        }
        return filtered;
    }

    public static final List<? extends SourceStructElement<?, ?>> filter(List<? extends SourceStructElement<?, ?>> elements, @Nullable LtkModelElementFilter<? super SourceStructElement<?, ?>> filter, @Nullable List<SourceStructElement<?, ?>> tmpList) {
        if (filter == null || elements.isEmpty()) {
            return elements;
        }
        if (tmpList == null) {
            tmpList = new ArrayList(elements.size());
        }
        for (SourceStructElement<?, ?> element : elements) {
            if (!filter.include(element)) continue;
            tmpList.add(element);
        }
        return tmpList;
    }

    public static @Nullable SourceStructElement<?, ?> getCoveringSourceElement(SourceStructElement<?, ?> root, TextRegion region) {
        return LtkModelUtils.getCoveringSourceElement(root, region.getStartOffset(), region.getEndOffset());
    }

    public static @Nullable SourceStructElement<?, ?> getCoveringSourceElement(SourceStructElement<?, ?> root, int startOffset, int endOffset) {
        SourceStructElement<?, ?> best = root;
        while (true) {
            List<?> children = best.getSourceChildren(null);
            SourceStructElement bestChild = null;
            for (SourceStructElement child : children) {
                int childEnd;
                int childOffset;
                TextRegion sourceRange = child.getSourceRange();
                TextRegion docRange = child.getDocumentationRange();
                int n = childOffset = docRange != null ? Math.min(sourceRange.getStartOffset(), docRange.getStartOffset()) : sourceRange.getStartOffset();
                if (childOffset > startOffset) break;
                int n2 = childEnd = docRange != null ? Math.max(sourceRange.getEndOffset(), docRange.getEndOffset()) : sourceRange.getEndOffset();
                if (childEnd < endOffset) continue;
                bestChild = child;
                if (startOffset != endOffset || childEnd != endOffset) break;
            }
            if (bestChild == null) break;
            best = bestChild;
        }
        return best;
    }

    public static int searchCoveringSourceElement(List<? extends SourceStructElement<?, ?>> elements, int offset) {
        int low = 0;
        int high = elements.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            TextRegion region = elements.get(mid).getSourceRange();
            if (region.getEndOffset() < offset) {
                low = mid + 1;
                continue;
            }
            if (region.getStartOffset() > offset) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static <T extends SourceStructElement<?, ?>> @Nullable T getCoveringSourceElement(List<T> elements, int offset) {
        int idx = LtkModelUtils.searchCoveringSourceElement(elements, offset);
        if (idx >= 0) {
            return (T)((SourceStructElement)elements.get(idx));
        }
        return null;
    }
}

