/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ast.core.impl;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;

@NonNullByDefault
public abstract class AbstractAstNode
implements AstNode {
    private static final ImList<Object> NO_ATTACHMENT = ImCollections.emptyList();
    private int statusCode;
    private int startOffset;
    private int endOffset;
    private volatile ImList<Object> attachments = NO_ATTACHMENT;

    protected AbstractAstNode(int statusCode, int startOffset, int endOffset) {
        this.statusCode = statusCode;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    protected AbstractAstNode(int statusCode) {
        this.statusCode = statusCode;
    }

    protected AbstractAstNode() {
    }

    @Override
    public final int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public final void accept(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public final int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public final int getLength() {
        return this.endOffset - this.startOffset;
    }

    protected final void doSetStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    protected final void doSetStatusThis(int statusCode) {
        this.statusCode = this.statusCode & 0x7000000 | statusCode;
    }

    protected final void doAddStatusFlag(int statusFlag) {
        this.statusCode |= statusFlag;
    }

    protected final void doClearStatusSeverityInChild() {
        this.statusCode &= 0xF8FFFFFF;
    }

    protected final void doSetStatusSeverityInChild(int statusCode) {
        this.statusCode = this.statusCode & 0xF8FFFFFF | statusCode;
    }

    protected final void doSetStatusSeverityOfChild(int childStatusCode) {
        this.statusCode = (childStatusCode & 0x4400000) != 0 ? this.statusCode & 0xF8FFFFFF | 0x4000000 : ((childStatusCode & 0x2200000) != 0 ? this.statusCode & 0xF8FFFFFF | 0x2000000 : (this.statusCode &= 0xF8FFFFFF));
    }

    protected final void doAddStatusSeverityOfChild(int childStatusCode) {
        int statusCode = this.statusCode;
        if ((statusCode & 0x4000000) != 0) {
            return;
        }
        if ((childStatusCode & 0x4400000) != 0) {
            this.statusCode = statusCode & 0xF8FFFFFF | 0x4000000;
        } else if ((childStatusCode & 0x2200000) != 0) {
            this.statusCode = statusCode & 0xF8FFFFFF | 0x2000000;
        }
    }

    protected final void doSetStartOffset(int offset) {
        this.startOffset = offset;
    }

    protected final void doSetEndOffset(int offset) {
        this.endOffset = offset;
    }

    protected final void doSetEndOffsetMin(int offset) {
        if (offset > this.endOffset) {
            this.endOffset = offset;
        }
    }

    protected final void doSetStartEndOffset(int startOffset, int endOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    protected final void doSetStartEndOffset(int offset) {
        this.startOffset = offset;
        this.endOffset = offset;
    }

    public synchronized void addAttachment(Object data) {
        this.attachments = ImCollections.addElement(this.attachments, (Object)data);
    }

    public synchronized void removeAttachment(Object data) {
        this.attachments = ImCollections.removeElement(this.attachments, (Object)data);
    }

    public ImList<Object> getAttachments() {
        return this.attachments;
    }
}

