/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.statet.jcommons.collections.SortedArraySet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.renv.core.BasicRPkgList;
import org.eclipse.statet.rj.renv.core.RPkg;
import org.eclipse.statet.rj.renv.core.RPkgCompilation;
import org.eclipse.statet.rj.renv.core.RPkgList;
import org.eclipse.statet.rj.renv.core.RPkgUtils;

@NonNullByDefault
public class BasicRPkgCompilation<T extends RPkg>
implements RPkgCompilation<T> {
    private final List<String> sources;
    private final List<RPkgList<T>> pkgLists;
    private volatile @Nullable List<String> names;

    public BasicRPkgCompilation(int size) {
        this.sources = new ArrayList<String>(size);
        this.pkgLists = new ArrayList<RPkgList<T>>(size);
    }

    public void add(String source, RPkgList<T> list) {
        this.sources.add(source != null ? source : "");
        this.pkgLists.add(list);
    }

    public RPkgList<T> getOrAdd(String source) {
        RPkgList<T> list = this.getBySource(source);
        if (list == null) {
            list = this.newPkgList();
            this.add(source, list);
        }
        return list;
    }

    protected RPkgList<T> newPkgList() {
        return new BasicRPkgList(4);
    }

    @Override
    public List<String> getNames() {
        if (this.names == null) {
            this.createNames();
        }
        return this.names;
    }

    private synchronized void createNames() {
        if (this.names != null) {
            return;
        }
        if (this.pkgLists.isEmpty()) {
            this.names = Collections.emptyList();
            return;
        }
        SortedArraySet names = new SortedArraySet((Object[])new String[Math.min(16, this.pkgLists.get(0).size())], 0, (Comparator)RPkgUtils.NAMES_COLLATOR);
        for (RPkgList<T> list : this.pkgLists) {
            int i = 0;
            while (i < list.size()) {
                names.addE((Object)list.get(i).getName());
                ++i;
            }
        }
        this.names = Collections.unmodifiableList(names);
    }

    @Override
    public boolean contains(String name) {
        for (RPkgList<T> list : this.pkgLists) {
            int idx = list.indexOf(name);
            if (idx < 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public @Nullable T getFirst(String name) {
        for (RPkgList<T> list : this.pkgLists) {
            int idx = list.indexOf(name);
            if (idx < 0) continue;
            return list.get(idx);
        }
        return null;
    }

    @Override
    public List<T> get(String name) {
        List result = null;
        for (RPkgList<T> list : this.pkgLists) {
            int idx = list.indexOf(name);
            if (idx < 0) continue;
            if (result == null) {
                result = new ArrayList(2);
            }
            result.add(list.get(idx));
        }
        return result != null ? result : Collections.emptyList();
    }

    @Override
    public List<String> getSources() {
        return this.sources;
    }

    @Override
    public @Nullable RPkgList<T> getBySource(String source) {
        int idx = this.sources.indexOf(source);
        return idx >= 0 ? this.pkgLists.get(idx) : null;
    }

    @Override
    public List<RPkgList<T>> getAll() {
        return this.pkgLists;
    }
}

