/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;
import org.eclipse.statet.r.core.source.ast.StdBinary;

@NonNullByDefault
public abstract class Relational
extends StdBinary {
    Relational() {
    }

    @Override
    public final NodeType getNodeType() {
        return NodeType.RELATIONAL;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public abstract RTerminal getOperator(int var1);

    @Override
    public final boolean equalsSingle(RAstNode element) {
        return NodeType.RELATIONAL == element.getNodeType();
    }

    static final class EQ
    extends Relational {
        EQ() {
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.REL_EQ;
        }

        @Override
        public boolean equalsValue(RAstNode element) {
            if (NodeType.RELATIONAL == element.getNodeType()) {
                Relational other = (Relational)element;
                return element.getOperator(0) == RTerminal.REL_EQ && this.leftExpr.node.equalsValue(other.leftExpr.node) && this.rightExpr.node.equalsValue(other.rightExpr.node) || element.getOperator(0) == RTerminal.REL_EQ && this.leftExpr.node.equalsValue(other.rightExpr.node) && this.rightExpr.node.equalsValue(other.leftExpr.node);
            }
            return false;
        }
    }

    static final class GE
    extends Relational {
        GE() {
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.REL_GE;
        }

        @Override
        public boolean equalsValue(RAstNode element) {
            if (NodeType.RELATIONAL == element.getNodeType()) {
                Relational other = (Relational)element;
                return element.getOperator(0) == RTerminal.REL_GE && this.leftExpr.node.equalsValue(other.leftExpr.node) && this.rightExpr.node.equalsValue(other.rightExpr.node) || element.getOperator(0) == RTerminal.REL_LT && this.leftExpr.node.equalsValue(other.rightExpr.node) && this.rightExpr.node.equalsValue(other.leftExpr.node);
            }
            return false;
        }
    }

    static final class GT
    extends Relational {
        GT() {
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.REL_GT;
        }

        @Override
        public boolean equalsValue(RAstNode element) {
            if (NodeType.RELATIONAL == element.getNodeType()) {
                Relational other = (Relational)element;
                return element.getOperator(0) == RTerminal.REL_GT && this.leftExpr.node.equalsValue(other.leftExpr.node) && this.rightExpr.node.equalsValue(other.rightExpr.node) || element.getOperator(0) == RTerminal.REL_LE && this.leftExpr.node.equalsValue(other.rightExpr.node) && this.rightExpr.node.equalsValue(other.leftExpr.node);
            }
            return false;
        }
    }

    static final class LE
    extends Relational {
        LE() {
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.REL_LE;
        }

        @Override
        public boolean equalsValue(RAstNode element) {
            if (NodeType.RELATIONAL == element.getNodeType()) {
                Relational other = (Relational)element;
                return element.getOperator(0) == RTerminal.REL_LE && this.leftExpr.node.equalsValue(other.leftExpr.node) && this.rightExpr.node.equalsValue(other.rightExpr.node) || element.getOperator(0) == RTerminal.REL_GT && this.leftExpr.node.equalsValue(other.rightExpr.node) && this.rightExpr.node.equalsValue(other.leftExpr.node);
            }
            return false;
        }
    }

    static final class LT
    extends Relational {
        LT() {
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.REL_LT;
        }

        @Override
        public boolean equalsValue(RAstNode element) {
            if (NodeType.RELATIONAL == element.getNodeType()) {
                Relational other = (Relational)element;
                return element.getOperator(0) == RTerminal.REL_LT && this.leftExpr.node.equalsValue(other.leftExpr.node) && this.rightExpr.node.equalsValue(other.rightExpr.node) || element.getOperator(0) == RTerminal.REL_GE && this.leftExpr.node.equalsValue(other.rightExpr.node) && this.rightExpr.node.equalsValue(other.leftExpr.node);
            }
            return false;
        }
    }

    static final class NE
    extends Relational {
        NE() {
        }

        @Override
        public final RTerminal getOperator(int index) {
            return RTerminal.REL_NE;
        }

        @Override
        public boolean equalsValue(RAstNode element) {
            if (NodeType.RELATIONAL == element.getNodeType()) {
                Relational other = (Relational)element;
                return element.getOperator(0) == RTerminal.REL_NE && this.leftExpr.node.equalsValue(other.leftExpr.node) && this.rightExpr.node.equalsValue(other.rightExpr.node) || element.getOperator(0) == RTerminal.REL_NE && this.leftExpr.node.equalsValue(other.rightExpr.node) && this.rightExpr.node.equalsValue(other.leftExpr.node);
            }
            return false;
        }
    }
}

