/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.Expression;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;

@NonNullByDefault
public final class CWhileLoop
extends RAstNode {
    int condOpenOffset = Integer.MIN_VALUE;
    final Expression condExpr = new Expression();
    int condCloseOffset = Integer.MIN_VALUE;
    final Expression loopExpr = new Expression();

    CWhileLoop() {
    }

    @Override
    public final NodeType getNodeType() {
        return NodeType.C_WHILE;
    }

    @Override
    public final RTerminal getOperator(int index) {
        return RTerminal.WHILE;
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    public final int getChildCount() {
        return 2;
    }

    @Override
    public final RAstNode getChild(int index) {
        return switch (index) {
            case 0 -> this.condExpr.node;
            case 1 -> this.loopExpr.node;
            default -> throw new IndexOutOfBoundsException();
        };
    }

    @Override
    public final int getChildIndex(AstNode child) {
        if (this.condExpr.node == child) {
            return 0;
        }
        if (this.loopExpr.node == child) {
            return 1;
        }
        return -1;
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        if (this.loopExpr.node == child) {
            return this.loopExpr;
        }
        if (this.condExpr.node == child) {
            return this.condExpr;
        }
        return null;
    }

    public final int getCondOpenOffset() {
        return this.condOpenOffset;
    }

    public final RAstNode getCondChild() {
        return this.condExpr.node;
    }

    public final int getCondCloseOffset() {
        return this.condCloseOffset;
    }

    public final RAstNode getContChild() {
        return this.loopExpr.node;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        this.condExpr.node.acceptInR(visitor);
        this.loopExpr.node.acceptInR(visitor);
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        visitor.visit((AstNode)this.condExpr.node);
        visitor.visit((AstNode)this.loopExpr.node);
    }

    @Override
    final @Nullable Expression getLeftExpr() {
        return null;
    }

    @Override
    final Expression getRightExpr() {
        return this.loopExpr;
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        return NodeType.C_WHILE == element.getNodeType();
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        if (this.condExpr == expr) {
            return 4211476;
        }
        if (this.loopExpr == expr) {
            return 4211478;
        }
        throw new IllegalArgumentException();
    }

    final void updateOffsets() {
        if (this.loopExpr.node != null) {
            this.doSetEndOffset(this.loopExpr.node.getEndOffset());
        } else if (this.condCloseOffset != Integer.MIN_VALUE) {
            this.doSetEndOffset(this.condCloseOffset + 1);
        } else if (this.condExpr.node != null) {
            this.doSetEndOffset(this.condExpr.node.getEndOffset());
        } else if (this.condOpenOffset != Integer.MIN_VALUE) {
            this.doSetEndOffset(this.condOpenOffset + 1);
        } else {
            this.doSetEndOffset(this.getStartOffset() + 5);
        }
    }
}

