/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.pkgmanager;

import java.util.Collection;
import java.util.List;
import org.eclipse.statet.internal.r.core.pkgmanager.RVarRepo;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.r.core.pkgmanager.RRepo;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.runtime.RLibLocationInfo;
import org.eclipse.statet.rj.renv.runtime.RPkgManager;
import org.eclipse.statet.rj.renv.runtime.RPkgManagerDataset;
import org.eclipse.statet.rj.renv.runtime.RuntimeRLibPaths;
import org.eclipse.statet.rj.services.RService;

@NonNullByDefault
public class RPkgUtils
extends org.eclipse.statet.rj.renv.core.RPkgUtils {
    public static boolean DEBUG = Boolean.getBoolean("org.eclipse.statet.r.core.pkgmanager.debug");
    private static final ImList<String> DEFAULT_INSTALL_ORDER = ImCollections.newList((Object[])new String[]{"r.user", "r.common", "r.site", "r.default"});

    public static @Nullable RRepo getRepoById(Collection<? extends RRepo> list, String id) {
        for (RRepo rRepo : list) {
            if (!id.equals(rRepo.getId())) continue;
            return rRepo;
        }
        return null;
    }

    public static @Nullable RRepo getRepoByName(Collection<? extends RRepo> list, String name) {
        for (RRepo rRepo : list) {
            if (!name.equals(rRepo.getName())) continue;
            return rRepo;
        }
        return null;
    }

    public static @Nullable RRepo getRepoByURL(Collection<? extends RRepo> list, RRepo repo) {
        return repo instanceof RVarRepo ? RPkgUtils.getRepoByRawURL(list, ((RVarRepo)repo).getRawURL()) : RPkgUtils.getRepoByURL(list, repo.getURL());
    }

    public static @Nullable RRepo getRepoByURL(Collection<? extends RRepo> list, String url) {
        url = RRepo.checkRepoURL(url);
        for (RRepo rRepo : list) {
            if (!url.equals(rRepo.getURL())) continue;
            return rRepo;
        }
        return null;
    }

    private static @Nullable RVarRepo getRepoByRawURL(Collection<? extends RRepo> list, String url) {
        url = RRepo.checkRepoURL(url);
        for (RRepo rRepo : list) {
            if (!(rRepo instanceof RVarRepo) || !url.equals(((RVarRepo)rRepo).getRawURL())) continue;
            return (RVarRepo)rRepo;
        }
        return null;
    }

    public static @Nullable RRepo findRepo(Collection<? extends RRepo> list, RRepo repo) {
        RRepo found = RPkgUtils.getRepoById(list, repo.getId());
        if (found == null && !repo.getURL().isEmpty()) {
            found = RPkgUtils.getRepoByURL(list, repo);
        }
        if (found == null && !repo.getName().isEmpty()) {
            found = RPkgUtils.getRepoByName(list, repo.getName());
        }
        return found;
    }

    public static @Nullable RLibLocation getDefaultInstallLocation(RuntimeRLibPaths rLibPaths) {
        for (String groupId : DEFAULT_INSTALL_ORDER) {
            RLibGroup group = rLibPaths.getRLibGroup(groupId);
            if (group == null) continue;
            for (RLibLocation location : group.getLibLocations()) {
                RLibLocationInfo locationInfo = rLibPaths.getInfo(location);
                if (locationInfo == null || !locationInfo.isWritable()) continue;
                return location;
            }
        }
        return null;
    }

    public static boolean areInstalled(RPkgManager manager, List<String> pkgNames, RService r, ProgressMonitor m) {
        RPkgManagerDataset dataset = manager.getDataset();
        if (dataset == null) {
            return true;
        }
        for (String pkgName : pkgNames) {
            if (dataset.getInstalled().contains(pkgName)) continue;
            return false;
        }
        return true;
    }
}

