/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.docmlet.wikitext.core.ast.Embedded;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikitextSourceElement;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextElementName;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.elements.IEmbeddedForeignElement;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;

public abstract class WikitextSourceElement
implements IWikitextSourceElement,
TextRegion {
    private static final ImList<WikitextSourceElement> NO_CHILDREN = ImCollections.emptyList();
    private final int type;
    WikitextElementName name;
    int occurrenceCount;
    int startOffset;
    int length;

    static final List<? extends ISourceStructElement> getChildren(List<? extends ISourceStructElement> children, IModelElement.Filter filter) {
        if (filter == null) {
            return children;
        }
        ArrayList<ISourceStructElement> filtered = new ArrayList<ISourceStructElement>(children.size());
        for (ISourceStructElement iSourceStructElement : children) {
            if (!filter.include((IModelElement)iSourceStructElement)) continue;
            filtered.add(iSourceStructElement);
        }
        return filtered;
    }

    static final boolean hasChildren(List<? extends ISourceStructElement> children, IModelElement.Filter filter) {
        if (filter == null) {
            return !children.isEmpty();
        }
        for (ISourceStructElement iSourceStructElement : children) {
            if (!filter.include((IModelElement)iSourceStructElement)) continue;
            return true;
        }
        return false;
    }

    protected WikitextSourceElement(int type) {
        this.type = type;
    }

    public final String getModelTypeId() {
        return "Wikidoc";
    }

    public final int getElementType() {
        return this.type;
    }

    public ElementName getElementName() {
        return this.name;
    }

    public String getId() {
        String name = this.getElementName().getDisplayName();
        StringBuilder sb = new StringBuilder(name.length() + 16);
        sb.append(Integer.toHexString(this.getElementType() & 0xFF0));
        sb.append(':');
        sb.append(name);
        sb.append('#');
        sb.append(this.occurrenceCount);
        return sb.toString();
    }

    public TextRegion getSourceRange() {
        return this;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.startOffset + this.length;
    }

    public int getLength() {
        return this.length;
    }

    public TextRegion getDocumentationRange() {
        return null;
    }

    public <T> T getAdapter(Class<T> adapterType) {
        return null;
    }

    public int hashCode() {
        return (this.type & 0xFF0) * this.getElementName().hashCode() + this.occurrenceCount;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WikitextSourceElement)) {
            return false;
        }
        WikitextSourceElement other = (WikitextSourceElement)obj;
        return (this.type & 0xFF0) == (other.type & 0xFF0) && this.occurrenceCount == other.occurrenceCount && ((this.type & 0xF00) == 512 || this.getSourceParent().equals(other.getSourceParent())) && this.getElementName().equals(other.getElementName());
    }

    public static abstract class Container
    extends WikitextSourceElement {
        List<WikitextSourceElement> children = WikitextSourceElement.access$0();
        TextRegion nameRegion;
        private final WikitextAstNode astNode;

        public Container(int type, WikitextAstNode astNode) {
            super(type);
            this.astNode = astNode;
        }

        public TextRegion getNameSourceRange() {
            return this.nameRegion;
        }

        public boolean hasSourceChildren(IModelElement.Filter filter) {
            return Container.hasChildren(this.children, filter);
        }

        public List<? extends ISourceStructElement> getSourceChildren(IModelElement.Filter filter) {
            return Container.getChildren(this.children, filter);
        }

        @Override
        public abstract Container getModelParent();

        public boolean hasModelChildren(IModelElement.Filter filter) {
            return Container.hasChildren(this.children, filter);
        }

        public List<? extends IModelElement> getModelChildren(IModelElement.Filter filter) {
            return Container.getChildren(this.children, filter);
        }

        @Override
        public <T> T getAdapter(Class<T> adapterType) {
            if (adapterType == AstNode.class) {
                return (T)((Object)this.astNode);
            }
            return super.getAdapter(adapterType);
        }
    }

    public static class EmbeddedRef
    extends WikitextSourceElement
    implements IEmbeddedForeignElement {
        private final Container parent;
        private final String externType;
        private ISourceStructElement foreign;
        private final Embedded astNode;

        protected EmbeddedRef(String externType, Container parent, Embedded astNode) {
            super(2048);
            this.externType = externType;
            this.parent = parent;
            this.astNode = astNode;
        }

        @Override
        public String getId() {
            String name = this.getElementName().getDisplayName();
            StringBuilder sb = new StringBuilder(name.length() + 32);
            sb.append(Integer.toHexString(this.getElementType() & 0xFF0));
            sb.append(':');
            sb.append(name);
            sb.append('#');
            sb.append(this.occurrenceCount);
            return sb.toString();
        }

        @Override
        public ElementName getElementName() {
            return this.foreign != null ? this.foreign.getElementName() : WikitextElementName.create(0, "");
        }

        public TextRegion getNameSourceRange() {
            return this.foreign != null ? this.foreign.getNameSourceRange() : null;
        }

        public ISourceUnit getSourceUnit() {
            return this.parent.getSourceUnit();
        }

        public boolean exists() {
            return this.parent.exists();
        }

        public boolean isReadOnly() {
            return this.parent.isReadOnly();
        }

        @Override
        public IWikitextSourceElement getModelParent() {
            return this.parent;
        }

        public boolean hasModelChildren(IModelElement.Filter filter) {
            return false;
        }

        public List<? extends IModelElement> getModelChildren(IModelElement.Filter filter) {
            return null;
        }

        public ISourceStructElement getForeignElement() {
            return this.foreign;
        }

        public ISourceStructElement getSourceParent() {
            return this.parent;
        }

        public boolean hasSourceChildren(IModelElement.Filter filter) {
            return this.foreign != null && (filter == null || filter.include((IModelElement)this.foreign));
        }

        public List<? extends ISourceStructElement> getSourceChildren(IModelElement.Filter filter) {
            return this.foreign != null && (filter == null || filter.include((IModelElement)this.foreign)) ? ImCollections.newList((Object)this.foreign) : NO_CHILDREN;
        }

        public void setForeign(ISourceStructElement foreign) {
            this.foreign = foreign;
        }

        @Override
        public <T> T getAdapter(Class<T> adapterType) {
            if (adapterType == AstNode.class) {
                return (T)((Object)this.astNode);
            }
            T adapter = super.getAdapter(adapterType);
            if (adapter != null) {
                return adapter;
            }
            return (T)this.foreign.getAdapter(adapterType);
        }

        @Override
        public int hashCode() {
            int h = 2048 * this.externType.hashCode() + this.occurrenceCount;
            if (this.foreign != null) {
                h = this.foreign.hashCode() * 23917;
            }
            return h;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EmbeddedRef)) {
                return false;
            }
            EmbeddedRef other = (EmbeddedRef)obj;
            return this.getSourceParent().equals(other.getSourceParent()) && (this.foreign != null ? this.foreign.equals(other.foreign) : other.foreign == null);
        }
    }

    public static class SourceContainer
    extends Container {
        private final ISourceUnit sourceUnit;

        public SourceContainer(int type, ISourceUnit su, WikitextAstNode astNode) {
            super(type, astNode);
            this.sourceUnit = su;
        }

        @Override
        public String getId() {
            return this.sourceUnit.getId();
        }

        @Override
        public WikitextElementName getElementName() {
            ElementName elementName = this.sourceUnit.getElementName();
            if (elementName instanceof WikitextElementName) {
                return (WikitextElementName)elementName;
            }
            return WikitextElementName.create(15, elementName.getSegmentName());
        }

        public ISourceUnit getSourceUnit() {
            return this.sourceUnit;
        }

        public boolean exists() {
            ISourceUnitModelInfo modelInfo = this.getSourceUnit().getModelInfo("Wikidoc", 0, null);
            return modelInfo != null && modelInfo.getSourceElement() == this;
        }

        public boolean isReadOnly() {
            return this.sourceUnit.isReadOnly();
        }

        public ISourceStructElement getSourceParent() {
            return null;
        }

        @Override
        public Container getModelParent() {
            return null;
        }
    }

    public static class StructContainer
    extends Container {
        private final Container parent;

        public StructContainer(int type, Container parent, WikitextAstNode astNode) {
            super(type, astNode);
            this.parent = parent;
            this.startOffset = astNode.getStartOffset();
            this.length = astNode.getLength();
        }

        public ISourceUnit getSourceUnit() {
            return this.parent.getSourceUnit();
        }

        public boolean exists() {
            return this.parent.exists();
        }

        public boolean isReadOnly() {
            return this.parent.isReadOnly();
        }

        public ISourceStructElement getSourceParent() {
            return this.parent;
        }

        @Override
        public Container getModelParent() {
            return this.parent;
        }
    }
}

