/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.ui;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.docmlet.base.ui.DocmlBaseUIResources;
import org.eclipse.statet.docmlet.tex.core.model.TexNameAccess;
import org.eclipse.statet.docmlet.tex.ui.TexUIResources;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.ui.ElementLabelProvider;
import org.eclipse.swt.graphics.Image;

public class TexLabelProvider
extends StyledCellLabelProvider
implements ElementLabelProvider,
ILabelProvider {
    private DocmlBaseUIResources docBaseResources = DocmlBaseUIResources.INSTANCE;
    private TexUIResources texResources = TexUIResources.INSTANCE;

    public void dispose() {
        super.dispose();
        this.docBaseResources = null;
        this.texResources = null;
    }

    public Image getImage(Object element) {
        if (element instanceof IModelElement) {
            return this.getImage((IModelElement)element);
        }
        if (element instanceof TexNameAccess) {
            return this.getImage((TexNameAccess)element);
        }
        return null;
    }

    public Image getImage(IModelElement element) {
        switch (element.getElementType() & 0xFFF) {
            case 1040: {
                return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Preamble");
            }
            case 1057: {
                return this.getTexImage("org.eclipse.statet.docmlet.tex/image/obj/sectioning-part");
            }
            case 1058: {
                return this.getTexImage("org.eclipse.statet.docmlet.tex/image/obj/sectioning-chapter");
            }
            case 1059: {
                return this.getTexImage("org.eclipse.statet.docmlet.tex/image/obj/sectioning-section");
            }
            case 1060: {
                return this.getTexImage("org.eclipse.statet.docmlet.tex/image/obj/sectioning-subsection");
            }
            case 1061: {
                return this.getTexImage("org.eclipse.statet.docmlet.tex/image/obj/sectioning-subsubsection");
            }
        }
        return null;
    }

    public Image getImage(TexNameAccess access) {
        if (access.getType() == 66) {
            return this.getTexImage("org.eclipse.statet.docmlet.base/image/obj/Label-Ref");
        }
        return null;
    }

    protected Image getDocBaseImage(String imageId) {
        return this.docBaseResources.getImage(imageId);
    }

    protected Image getTexImage(String imageId) {
        return this.texResources.getImage(imageId);
    }

    public String getText(Object element) {
        if (element instanceof IModelElement) {
            return this.getText((IModelElement)element);
        }
        if (element instanceof TexNameAccess) {
            return this.getText((TexNameAccess)element);
        }
        return null;
    }

    public String getText(IModelElement element) {
        return element.getElementName().getDisplayName();
    }

    public String getText(TexNameAccess access) {
        return access.getDisplayName();
    }

    public StyledString getStyledText(IModelElement element) {
        return new StyledString(element.getElementName().getDisplayName());
    }

    public void update(ViewerCell cell) {
        Object cellElement = cell.getElement();
        if (cellElement instanceof IModelElement) {
            IModelElement element = (IModelElement)cellElement;
            cell.setImage(this.getImage(element));
            StyledString styledText = this.getStyledText(element);
            cell.setText(styledText.getString());
            cell.setStyleRanges(styledText.getStyleRanges());
            super.update(cell);
        } else {
            cell.setImage(null);
            cell.setText(cellElement.toString());
            cell.setStyleRanges(null);
            super.update(cell);
        }
    }
}

