/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.console;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.nico.ui.console.NIConsoleColorAdapter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;

public class PromptHighlighter
implements IPropertyChangeListener {
    private Control control;
    private final IPreferenceStore preferenceStore;
    private final PreferenceAccess prefAccess;
    private final ISharedTextColors sharedColors;
    private Color foregroundColor;
    private Color backgroundColor;
    private boolean isHighlightEnabled;

    public PromptHighlighter(Control control, PreferenceAccess prefAccess, IPreferenceStore preferenceStore) {
        this.control = control;
        this.prefAccess = prefAccess;
        this.preferenceStore = preferenceStore;
        this.sharedColors = EditorsUI.getSharedTextColors();
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.updateControl();
    }

    public void dispose() {
        this.control = null;
        this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("currentLineColor")) {
            Display.getDefault().asyncExec(() -> {
                this.updateSettings();
                this.updateControl();
            });
        }
    }

    public void setHighlight(boolean enable) {
        if (enable == this.isHighlightEnabled) {
            return;
        }
        this.isHighlightEnabled = enable;
        this.updateControl();
    }

    public void updateSettings() {
        this.foregroundColor = null;
        this.backgroundColor = null;
    }

    public void updateControl() {
        Color backgroundColor;
        Color foregroundColor;
        Control control = this.control;
        if (!UIAccess.isOkToUse((Control)control)) {
            return;
        }
        if (this.isHighlightEnabled) {
            RGB rgb;
            foregroundColor = this.foregroundColor;
            if (foregroundColor == null) {
                rgb = (RGB)this.prefAccess.getPreferenceValue(NIConsoleColorAdapter.getForegroundColorPref("org.eclipse.statet.nico.ui.InfoStream"));
                this.foregroundColor = foregroundColor = this.sharedColors.getColor(rgb);
            }
            if ((backgroundColor = this.backgroundColor) == null) {
                rgb = PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)"currentLineColor");
                this.backgroundColor = backgroundColor = this.sharedColors.getColor(rgb);
            }
        } else {
            foregroundColor = control.getDisplay().getSystemColor(39);
            backgroundColor = null;
        }
        control.setForeground(foregroundColor);
        control.setBackground(backgroundColor);
    }
}

