/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.refactoring.core;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.refactoring.core.SourceUnitChange;

public class TextChangeManager {
    private final Map<ISourceUnit, TextFileChange> map = new HashMap<ISourceUnit, TextFileChange>(10);
    private final boolean keepExecutedTextEdits;

    public TextChangeManager() {
        this(false);
    }

    public TextChangeManager(boolean keepExecutedTextEdits) {
        this.keepExecutedTextEdits = keepExecutedTextEdits;
    }

    public TextFileChange get(ISourceUnit su) {
        TextFileChange result = this.map.get(su);
        if (result == null) {
            result = new SourceUnitChange(su);
            result.setKeepPreviewEdits(this.keepExecutedTextEdits);
            this.map.put(su, result);
        }
        return result;
    }

    public TextChange remove(ISourceUnit unit) {
        return (TextChange)this.map.remove(unit);
    }

    public ISourceUnit[] getAllSourceUnits() {
        return this.map.keySet().toArray(new ISourceUnit[this.map.keySet().size()]);
    }

    public TextChange[] getAllChanges() {
        Set<ISourceUnit> suSet = this.map.keySet();
        ISourceUnit[] sus = suSet.toArray(new ISourceUnit[suSet.size()]);
        Arrays.sort(sus, new Comparator<ISourceUnit>(){

            @Override
            public int compare(ISourceUnit su1, ISourceUnit su2) {
                return su1.getId().compareTo(su2.getId());
            }
        });
        TextChange[] textChanges = new TextChange[sus.length];
        int i = 0;
        while (i < sus.length) {
            textChanges[i] = (TextChange)this.map.get(sus[i]);
            ++i;
        }
        return textChanges;
    }

    public boolean containsChangesIn(ISourceUnit su) {
        return this.map.containsKey(su);
    }

    public void clear() {
        this.map.clear();
    }
}

