/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.emf.ui.forms;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.statet.ecommons.databinding.core.DataBindingSubContext;
import org.eclipse.statet.ecommons.emf.core.databinding.IEMFEditContext;
import org.eclipse.statet.ecommons.emf.ui.databinding.DetailContext;
import org.eclipse.statet.ecommons.emf.ui.forms.Detail;
import org.eclipse.statet.ecommons.emf.ui.forms.IEFFormPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DetailStack
extends Composite {
    private final IEFFormPage page;
    private final StackLayout layout;
    private final List<DetailEntry> details;
    private final int limit = 10;
    private IEMFEditContext context;
    private DetailEntry currentDetail;
    private EObject currentValue;

    public DetailStack(IEFFormPage page, Composite parent) {
        super(parent, 0);
        this.page = page;
        this.layout = new StackLayout();
        this.setLayout((Layout)this.layout);
        this.details = new ArrayList<DetailEntry>(10 + 1);
    }

    public IEFFormPage getPage() {
        return this.page;
    }

    protected void dispose(DetailEntry entry) {
        Composite composite = entry.detail.getComposite();
        if (composite != null && !composite.isDisposed()) {
            composite.dispose();
        }
        if (entry.dbc != null) {
            entry.dbc.dispose();
            entry.dbc = null;
        }
    }

    public void showDetail(EObject value) {
        Object detail;
        int index = 0;
        Object key = this.getKey(value);
        Object entry = null;
        while (index < this.details.size()) {
            detail = this.details.get(index);
            if (key == ((DetailEntry)detail).key) {
                entry = detail;
                break;
            }
            ++index;
        }
        if (entry == null) {
            detail = this.createDetail(value);
            entry = new DetailEntry(key, (Detail)detail);
            this.details.add(0, (DetailEntry)entry);
            this.initDetailBindings((DetailEntry)entry, value);
        } else {
            if (((DetailEntry)entry).dbc == null) {
                this.initDetailBindings((DetailEntry)entry, value);
            }
            if (index != 0) {
                this.details.remove(index);
                this.details.add(0, (DetailEntry)entry);
            }
        }
        this.currentDetail = this.details.get(0);
        this.currentValue = value;
        this.layout.topControl = this.currentDetail.detail.getComposite();
        this.layout();
        this.getParent().layout(new Control[]{this});
        this.getPage().reflow(true);
        if (this.details.size() > 10) {
            this.dispose(this.details.remove(this.details.size() - 1));
        }
    }

    protected Object getKey(EObject value) {
        return value;
    }

    protected Detail createDetail(EObject value) {
        return new EmptyDetail(this);
    }

    protected void createDetailContent(Composite composite, EObject value) {
        if (value == null) {
            return;
        }
        Label label = new Label(composite, 0);
        label.setText(value.toString());
    }

    public void setContext(IEMFEditContext context) {
        this.context = context;
        IObservableValue baseValue = context.getBaseObservable();
        baseValue.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                DetailStack.this.showDetail((EObject)event.diff.getNewValue());
            }
        });
        this.showDetail((EObject)baseValue.getValue());
    }

    protected IEMFEditContext createDetailContext(IEMFEditContext parent, IObservableValue detailValue) {
        return new DetailContext(parent, detailValue);
    }

    private void initDetailBindings(final DetailEntry entry, final EObject value) {
        final IEMFEditContext context = this.context;
        if (context == null || entry.dbc != null) {
            if (entry.context != null) {
                entry.context.getBaseObservable().setValue((Object)value);
            }
            return;
        }
        final AtomicReference error = new AtomicReference();
        entry.dbc = new DataBindingSubContext(context.getDataBindingContext());
        entry.dbc.run(new Runnable(){

            @Override
            public void run() {
                try {
                    WritableValue contextValue = new WritableValue(context.getRealm(), (Object)value, EObject.class);
                    entry.context = DetailStack.this.createDetailContext(context, (IObservableValue)contextValue);
                    entry.detail.addBindings(entry.context);
                }
                catch (RuntimeException e) {
                    error.set(e);
                }
            }
        });
        if (error.get() != null) {
            throw (RuntimeException)error.get();
        }
    }

    private class DetailEntry {
        private final Object key;
        private final Detail detail;
        private IEMFEditContext context;
        private DataBindingSubContext dbc;

        public DetailEntry(Object key, Detail detail) {
            this.key = key;
            this.detail = detail;
        }
    }

    private static class EmptyDetail
    extends Detail {
        public EmptyDetail(DetailStack parent) {
            super(parent);
            this.createContent();
        }

        @Override
        protected Composite createComposite(DetailStack parent) {
            return new Composite((Composite)parent, 0);
        }

        @Override
        protected void createContent(Composite composite) {
        }
    }
}

