/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.nostart;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.statushandlers.StatusManager;

public class SupportFileCommandTester
extends PropertyTester {
    public static final String SUPPORTS_FILECOMMAND = "supportsFileCommand";
    private static final String BUNDLE_ID = "org.eclipse.statet.r.ui";
    private static final String R_CONTENT = "org.eclipse.statet.r.contentTypes.R";
    private static final String CONTENTHANDLER_EXTENSION_POINT = "rCodeLaunchContentHandler";
    private static final String CONTENTHANDLER_ELEMENT = "contentHandler";
    private static final String CONTENT_FILECOMMAND_ELEMENT = "fileCommand";
    private static final String ATT_CONTENT_TYPE = "contentTypeId";
    private final Set<String> fSupportedContentTypeIds = new HashSet<String>();

    public SupportFileCommandTester() {
        this.updateSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSettings() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(BUNDLE_ID, CONTENTHANDLER_EXTENSION_POINT);
        SupportFileCommandTester supportFileCommandTester = this;
        synchronized (supportFileCommandTester) {
            this.fSupportedContentTypeIds.clear();
            this.fSupportedContentTypeIds.add(R_CONTENT);
            int i = 0;
            while (i < elements.length) {
                try {
                    if (elements[i].getName().equals(CONTENTHANDLER_ELEMENT) && elements[i].getChildren(CONTENT_FILECOMMAND_ELEMENT).length > 0) {
                        this.fSupportedContentTypeIds.add(elements[i].getAttribute(ATT_CONTENT_TYPE));
                    }
                }
                catch (Exception e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, BUNDLE_ID, -1, "An error occurred when loading supported content types for file command", (Throwable)e));
                }
                ++i;
            }
        }
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IResource resource;
        IFile file = null;
        if (receiver instanceof IFile) {
            file = (IFile)receiver;
        } else if (receiver instanceof IAdaptable && (file = (IFile)((IAdaptable)receiver).getAdapter(IFile.class)) == null && (resource = (IResource)((IAdaptable)receiver).getAdapter(IResource.class)) instanceof IFile) {
            file = (IFile)resource;
        }
        if (property.equals(SUPPORTS_FILECOMMAND)) {
            if (file != null) {
                try {
                    IContentType contentType;
                    IContentDescription contentDescription = file.getContentDescription();
                    if (contentDescription != null && (contentType = contentDescription.getContentType()) != null) {
                        return this.fSupportedContentTypeIds.contains(contentType.getId());
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            return false;
        }
        return false;
    }
}

