/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.ecommons.text.ISourceFragment;
import org.eclipse.statet.ecommons.text.PartitionerDocumentSetupParticipant;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.model.core.IDocumentModelProvider;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceFragmentEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public class FragmentDocumentProvider
extends AbstractDocumentProvider
implements IDocumentModelProvider {
    private final String modelTypeId;
    private final IDocumentSetupParticipant documentSetupParticipant;

    public FragmentDocumentProvider(String modelTypeId, PartitionerDocumentSetupParticipant documentSetupParticipant) {
        if (modelTypeId == null) {
            throw new NullPointerException("modelTypeId");
        }
        this.modelTypeId = modelTypeId;
        this.documentSetupParticipant = documentSetupParticipant;
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        AbstractDocument document;
        Object su;
        block8: {
            su = null;
            document = null;
            if (element instanceof ISourceFragmentEditorInput) {
                ISourceFragmentEditorInput fragmentInput = (ISourceFragmentEditorInput)element;
                SubMonitor m = SubMonitor.convert((IProgressMonitor)this.getProgressMonitor(), (int)2);
                try {
                    try {
                        su = LTK.getSourceUnitManager().getSourceUnit(this.modelTypeId, LTK.EDITOR_CONTEXT, (Object)fragmentInput.getSourceFragment(), true, (IProgressMonitor)m.newChild(1));
                        document = su.getDocument((IProgressMonitor)m.newChild(1));
                    }
                    catch (Exception exception) {
                        m.done();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    m.done();
                    throw throwable;
                }
                m.done();
            }
        }
        if (document == null) {
            document = this.createDocument(su != null ? su : element);
        }
        if (document != null) {
            this.setupDocument(document);
            SourceElementInfo info = new SourceElementInfo((IDocument)document, this.createAnnotationModel(element));
            info.workingCopy = (ISourceUnit)su;
            return info;
        }
        return null;
    }

    protected AbstractDocument createDocument(Object element) throws CoreException {
        if (element instanceof ISourceFragmentEditorInput) {
            ISourceFragment fragment = ((ISourceFragmentEditorInput)element).getSourceFragment();
            return fragment.getDocument();
        }
        return null;
    }

    protected void setupDocument(AbstractDocument document) {
        if (this.documentSetupParticipant != null) {
            this.documentSetupParticipant.setup((IDocument)document);
        }
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return new AnnotationModel();
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo elementInfo) {
        SourceElementInfo info = (SourceElementInfo)elementInfo;
        if (info.workingCopy != null) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)this.getProgressMonitor(), (int)1);
            try {
                info.workingCopy.disconnect((IProgressMonitor)m.newChild(1));
            }
            finally {
                info.workingCopy = null;
                m.done();
            }
        }
        super.disposeElementInfo(element, elementInfo);
    }

    public ISourceUnit getWorkingCopy(Object element) {
        SourceElementInfo info = (SourceElementInfo)this.getElementInfo(element);
        if (info != null) {
            return info.workingCopy;
        }
        return null;
    }

    public class SourceElementInfo
    extends AbstractDocumentProvider.ElementInfo {
        private ISourceUnit workingCopy;

        public SourceElementInfo(IDocument document, IAnnotationModel model) {
            super((AbstractDocumentProvider)FragmentDocumentProvider.this, document, model);
        }
    }
}

