/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.workbench;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.components.WidgetToolBarComposite;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.ecommons.ui.workbench.ContainerContentProvider;
import org.eclipse.statet.internal.ecommons.ui.Messages;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ContainerSelectionComposite
extends Composite {
    private static final int SIZING_SELECTION_PANE_WIDTH = 320;
    private boolean allowNewContainerName = true;
    private boolean showClosedProjects = true;
    private IContainer selectedContainer;
    private Text containerNameField;
    private TreeViewer treeViewer;
    private ToolBarManager rightToolBarMgr;
    private boolean isToggleFilterActivated;
    private ContainerFilter toggledFilter;
    private Listener listener;

    public ContainerSelectionComposite(Composite parent, boolean allowNewContainerName, boolean showClosedProjects, @Nullable String message, int heightHint) {
        super(parent, 0);
        this.allowNewContainerName = allowNewContainerName;
        this.showClosedProjects = showClosedProjects;
        if (message == null) {
            message = allowNewContainerName ? Messages.ContainerSelectionControl_label_EnterOrSelectFolder : Messages.ContainerSelectionControl_label_SelectFolder;
        }
        this.createContents(message, heightHint);
    }

    protected void createContents(String message, int heightHint) {
        this.setLayout((Layout)LayoutUtils.newCompositeGrid());
        Label label = new Label((Composite)this, 64);
        label.setText(message);
        if (this.allowNewContainerName) {
            this.containerNameField = new Text((Composite)this, 2052);
            this.containerNameField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.containerNameField.setFont(this.getFont());
        } else {
            new Label((Composite)this, 0);
        }
        this.createTreeViewer(heightHint);
        Dialog.applyDialogFont((Control)this);
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    protected void createTreeViewer(int heightHint) {
        WidgetToolBarComposite treeGroup = new WidgetToolBarComposite(this, 2048);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 320;
        gd.heightHint = heightHint;
        treeGroup.setLayoutData(gd);
        ToolBarManager leftToolBarMgr = new ToolBarManager(treeGroup.getLeftToolBar());
        this.rightToolBarMgr = new ToolBarManager(treeGroup.getRightToolBar());
        this.treeViewer = new TreeViewer((Composite)treeGroup, 0);
        this.treeViewer.getTree().setLayoutData((Object)treeGroup.getContentLayoutData());
        DrillDownAdapter adapter = new DrillDownAdapter(this.treeViewer);
        adapter.addNavigationActions((IToolBarManager)leftToolBarMgr);
        this.rightToolBarMgr.add((IAction)new CollapseAllAction());
        this.rightToolBarMgr.add((IAction)new ExpandAllAction());
        leftToolBarMgr.update(true);
        this.rightToolBarMgr.update(true);
        treeGroup.layout();
        this.treeViewer.setUseHashlookup(true);
        ContainerContentProvider cp = new ContainerContentProvider();
        cp.showClosedProjects(this.showClosedProjects);
        this.treeViewer.setContentProvider((IContentProvider)cp);
        this.treeViewer.setComparator((ViewerComparator)new ResourceComparator(1));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ContainerSelectionComposite.this.containerSelectionChanged((IContainer)selection.getFirstElement());
            }
        });
        ViewerUtils.addDoubleClickExpansion(this.treeViewer);
    }

    public void setToggleFilter(ContainerFilter filter, boolean initialEnabled) {
        this.toggledFilter = filter;
        this.isToggleFilterActivated = initialEnabled;
        ToggleFilterAction action = new ToggleFilterAction();
        this.rightToolBarMgr.add((IContributionItem)new Separator());
        this.rightToolBarMgr.add((IAction)action);
        action.doToggleFilter(true);
        if (this.treeViewer.getTree().getItemCount() == 0) {
            action.doToggleFilter(false);
            action.setChecked(false);
            action.setEnabled(false);
        } else {
            action.setChecked(initialEnabled);
            if (!initialEnabled) {
                action.doToggleFilter(false);
            }
        }
        this.rightToolBarMgr.update(true);
        this.rightToolBarMgr.getControl().getParent().layout();
    }

    public boolean getToggleFilterSetting() {
        return this.isToggleFilterActivated;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
        if (this.containerNameField != null) {
            this.containerNameField.addListener(24, this.listener);
        }
    }

    public void setInitialFocus() {
        if (this.allowNewContainerName) {
            this.containerNameField.setFocus();
        } else {
            this.treeViewer.getTree().setFocus();
        }
    }

    protected void containerSelectionChanged(@Nullable IContainer container) {
        if (this.allowNewContainerName) {
            if (container != null) {
                this.selectedContainer = container;
                this.containerNameField.setText(container.getFullPath().makeRelative().toString());
            }
        } else {
            this.selectedContainer = container;
            if (this.listener != null) {
                Event changeEvent = new Event();
                changeEvent.type = 13;
                changeEvent.widget = this;
                this.listener.handleEvent(changeEvent);
            }
        }
    }

    public @Nullable IPath getContainerFullPath() {
        if (this.allowNewContainerName) {
            String pathName = this.containerNameField.getText();
            if (pathName == null || pathName.length() < 1) {
                return null;
            }
            return new Path(pathName).makeAbsolute();
        }
        if (this.selectedContainer == null) {
            return null;
        }
        return this.selectedContainer.getFullPath();
    }

    public void selectContainer(IContainer container) {
        this.selectedContainer = container;
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        IContainer parent = container.getParent();
        while (parent != null) {
            itemsToExpand.add(0, parent);
            parent = parent.getParent();
        }
        if (this.toggledFilter != null) {
            this.toggledFilter.excludePath = container.getFullPath();
            this.treeViewer.refresh();
        }
        this.treeViewer.setExpandedElements(itemsToExpand.toArray());
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)container), true);
    }

    public void selectContainer(IPath path) {
        IResource initial = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (initial != null) {
            if (!(initial instanceof IContainer)) {
                initial = initial.getParent();
            }
            this.selectContainer((IContainer)initial);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static IStatus validate(@Nullable IPath path) {
        if (path == null || path.isEmpty()) {
            return new StatusInfo(4, Messages.ContainerSelectionControl_error_FolderEmpty);
        }
        root = ResourcesPlugin.getWorkspace().getRoot();
        projectName = path.segment(0);
        if (projectName != null && root.getProject(projectName).exists()) ** GOTO lbl10
        return new StatusInfo(4, Messages.ContainerSelectionControl_error_ProjectNotExists);
lbl-1000:
        // 1 sources

        {
            if (root.getFile(path).exists()) {
                return new StatusInfo(4, NLS.bind((String)Messages.ContainerSelectionControl_error_PathOccupied, (Object)path.makeRelative()));
            }
            path = path.removeLastSegments(1);
lbl10:
            // 2 sources

            ** while (path.segmentCount() > 1)
        }
lbl11:
        // 1 sources

        return new StatusInfo();
    }

    private class CollapseAllAction
    extends Action {
        CollapseAllAction() {
            this.setText(SharedMessages.CollapseAllAction_label);
            this.setDescription(SharedMessages.CollapseAllAction_description);
            this.setToolTipText(SharedMessages.CollapseAllAction_tooltip);
            this.setImageDescriptor(SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctool/collapseall"));
        }

        public void run() {
            ContainerSelectionComposite.this.treeViewer.collapseAll();
        }
    }

    public static abstract class ContainerFilter
    extends ViewerFilter {
        private IPath excludePath;

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof IContainer)) {
                return true;
            }
            IContainer container = (IContainer)element;
            if (this.excludePath != null && container.getFullPath().isPrefixOf(this.excludePath)) {
                return true;
            }
            return this.select(container);
        }

        public abstract boolean select(IContainer var1);
    }

    private class ExpandAllAction
    extends Action {
        ExpandAllAction() {
            this.setText(SharedMessages.ExpandAllAction_label);
            this.setDescription(SharedMessages.ExpandAllAction_description);
            this.setToolTipText(SharedMessages.ExpandAllAction_tooltip);
            this.setImageDescriptor(SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctool/expandall"));
        }

        public void run() {
            ContainerSelectionComposite.this.treeViewer.expandAll();
        }
    }

    private class ToggleFilterAction
    extends Action {
        ToggleFilterAction() {
            this.setText(Messages.FilterFavouredContainersAction_label);
            this.setDescription(Messages.FilterFavouredContainersAction_description);
            this.setToolTipText(Messages.FilterFavouredContainersAction_tooltip);
            this.setImageDescriptor(SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctool/filter_view"));
            this.setDisabledImageDescriptor(SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctoold/filter_view"));
            this.setChecked(false);
        }

        public void run() {
            boolean enable = this.isChecked();
            this.doToggleFilter(enable);
            ContainerSelectionComposite.this.isToggleFilterActivated = enable;
        }

        void doToggleFilter(boolean enable) {
            if (enable) {
                ContainerSelectionComposite.this.treeViewer.addFilter((ViewerFilter)ContainerSelectionComposite.this.toggledFilter);
            } else {
                ContainerSelectionComposite.this.treeViewer.removeFilter((ViewerFilter)ContainerSelectionComposite.this.toggledFilter);
            }
        }
    }
}

