/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.internal.r.ui.correction.RLinkedNamesAssistProposal;
import org.eclipse.statet.internal.r.ui.correction.RenameInRegionAssistProposal;
import org.eclipse.statet.internal.r.ui.correction.RenameInWorkspaceAssistProposal;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.LTKUtils;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IAssistCompletionProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IQuickAssistComputer;
import org.eclipse.statet.r.core.model.IRCompositeSourceElement;
import org.eclipse.statet.r.core.model.IRLangSourceElement;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.IRWorkspaceSourceUnit;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;

public class RQuickRefactoringComputer
implements IQuickAssistComputer {
    public IStatus computeAssistProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        block8: {
            if (!(context.getAstSelection().getCovering() instanceof RAstNode)) {
                return Status.OK_STATUS;
            }
            RAstNode node = (RAstNode)context.getAstSelection().getCovering();
            if (node.getNodeType() == NodeType.SYMBOL || node.getNodeType() == NodeType.STRING_CONST) {
                RAstNode candidate = node;
                while (candidate != null) {
                    ImList attachments = candidate.getAttachments();
                    block1: for (Object attachment : attachments) {
                        if (!(attachment instanceof RElementAccess)) continue;
                        RElementAccess access = (RElementAccess)attachment;
                        while (access != null) {
                            if (access.getSegmentName() == null) continue block1;
                            if (access.getNameNode() == node) {
                                this.addAccessAssistProposals(context, access, proposals);
                                break block8;
                            }
                            access = access.getNextSegment();
                        }
                    }
                    candidate = candidate.getRParent();
                }
            } else if (context.getLength() > 0 && context.getSourceUnit() instanceof IRSourceUnit) {
                proposals.add((IAssistCompletionProposal)new RenameInRegionAssistProposal(context));
            }
        }
        return Status.OK_STATUS;
    }

    protected void addAccessAssistProposals(AssistInvocationContext context, RElementAccess access, AssistProposalCollector proposals) {
        ImIdentityList allAccess = ImCollections.toIdentityList((Collection)access.getAllInUnit(false));
        proposals.add((IAssistCompletionProposal)new RLinkedNamesAssistProposal(1, context, access));
        if (allAccess.size() > 2) {
            int current;
            List elements;
            IRLangSourceElement element;
            TextRegion chunk = null;
            ISourceStructElement sourceElement = context.getModelInfo().getSourceElement();
            if (sourceElement instanceof IRCompositeSourceElement && (element = (IRLangSourceElement)LTKUtils.getCoveringSourceElement((List)(elements = ((IRCompositeSourceElement)sourceElement).getCompositeElements()), (int)access.getNameNode().getStartOffset())) != null) {
                chunk = element.getSourceRange();
            }
            if ((current = allAccess.indexOf((Object)access)) >= 0) {
                if (current > 0 && current < allAccess.size() - 1) {
                    proposals.add((IAssistCompletionProposal)new RLinkedNamesAssistProposal(2, context, access));
                    proposals.add((IAssistCompletionProposal)new RLinkedNamesAssistProposal(3, context, access));
                }
                if (chunk != null) {
                    int chunkBegin = 0;
                    int offset = chunk.getStartOffset();
                    while (chunkBegin < current) {
                        if (offset <= ((RElementAccess)allAccess.get(chunkBegin)).getNameNode().getStartOffset()) break;
                        ++chunkBegin;
                    }
                    int chunkEnd = current + 1;
                    int offset2 = chunk.getEndOffset();
                    while (chunkEnd < allAccess.size()) {
                        if (offset2 <= ((RElementAccess)allAccess.get(chunkEnd)).getNameNode().getStartOffset()) break;
                        ++chunkEnd;
                    }
                    if (chunkEnd - chunkBegin > 1) {
                        proposals.add((IAssistCompletionProposal)new RLinkedNamesAssistProposal(4, context, access, chunk));
                    }
                }
            }
        }
        if (context.getSourceUnit() instanceof IRWorkspaceSourceUnit) {
            proposals.add((IAssistCompletionProposal)new RenameInWorkspaceAssistProposal(context, access.getNameNode()));
        }
    }
}

