/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection;

import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.event.ILayerEventHandler;
import org.eclipse.statet.ecommons.waltable.layer.event.IStructuralChangeEvent;
import org.eclipse.statet.ecommons.waltable.layer.event.StructuralDiff;
import org.eclipse.statet.ecommons.waltable.selection.ISelectionModel;
import org.eclipse.statet.ecommons.waltable.selection.SelectionLayer;

public class SelectionLayerStructuralChangeEventHandler
implements ILayerEventHandler<IStructuralChangeEvent> {
    private final ISelectionModel selectionModel;
    private final SelectionLayer selectionLayer;

    public SelectionLayerStructuralChangeEventHandler(SelectionLayer selectionLayer, ISelectionModel selectionModel) {
        this.selectionLayer = selectionLayer;
        this.selectionModel = selectionModel;
    }

    @Override
    public Class<IStructuralChangeEvent> getLayerEventClass() {
        return IStructuralChangeEvent.class;
    }

    @Override
    public void handleLayerEvent(IStructuralChangeEvent event) {
        block4: {
            event.isHorizontalStructureChanged();
            if (!event.isVerticalStructureChanged()) break block4;
            if (event.getRowDiffs() == null) {
                Collection<LRectangle> lRectangles = event.getChangedPositionRectangles();
                for (LRectangle lRectangle : lRectangles) {
                    LRange changedRange = new LRange(lRectangle.y, lRectangle.y + lRectangle.height);
                    if (!this.selectedRowModified(changedRange)) continue;
                    this.selectionLayer.clear();
                    break;
                }
            } else {
                for (StructuralDiff diff : event.getRowDiffs()) {
                    if (diff.getDiffType() == StructuralDiff.DiffTypeEnum.CHANGE || !this.selectedRowModified(diff.getBeforePositionRange())) continue;
                    this.selectionLayer.clear();
                    break;
                }
            }
        }
    }

    private boolean selectedRowModified(LRange changedRange) {
        LRangeList selectedRows = this.selectionModel.getSelectedRowPositions();
        for (LRange rowRange : selectedRows) {
            if (!rowRange.overlap(changedRange)) continue;
            return true;
        }
        return false;
    }
}

