/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell.decorator;

import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.BackgroundPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class XPBackgroundDecorator
extends BackgroundPainter {
    public final Color separatorColor = GUIHelper.getColor(199, 197, 178);
    public final Color gradientColor1 = GUIHelper.getColor(226, 222, 205);
    public final Color gradientColor2 = GUIHelper.getColor(214, 210, 194);
    public final Color gradientColor3 = GUIHelper.getColor(203, 199, 184);
    public final Color highlightColor1 = GUIHelper.getColor(250, 171, 0);
    public final Color highlightColor2 = GUIHelper.getColor(252, 194, 71);
    public final Color highlightColor3 = GUIHelper.getColor(250, 178, 24);

    public XPBackgroundDecorator(ICellPainter interiorPainter) {
        super(interiorPainter);
    }

    @Override
    public long getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return super.getPreferredWidth(cell, gc, configRegistry) + 4L;
    }

    @Override
    public long getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return super.getPreferredHeight(cell, gc, configRegistry) + 4L;
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, LRectangle lRectangle, IConfigRegistry configRegistry) {
        int x0;
        super.paintCell(cell, gc, lRectangle, configRegistry);
        LRectangle interiorBounds = new LRectangle(lRectangle.x + 2L, lRectangle.y + 2L, lRectangle.width - 4L, lRectangle.height - 4L);
        super.paintCell(cell, gc, interiorBounds, configRegistry);
        Color originalBackground = gc.getBackground();
        Color originalForeground = gc.getForeground();
        int x = x0 = GraphicsUtils.safe(lRectangle.x);
        gc.setForeground(GUIHelper.COLOR_WHITE);
        gc.drawLine(x, GraphicsUtils.safe(lRectangle.y + 3L), x, GraphicsUtils.safe(lRectangle.y + lRectangle.height - 6L));
        x = GraphicsUtils.safe(lRectangle.x + lRectangle.width - 1L);
        gc.setForeground(this.separatorColor);
        gc.drawLine(x, GraphicsUtils.safe(lRectangle.y + 3L), x, GraphicsUtils.safe(lRectangle.y + lRectangle.height - 6L));
        gc.setBackground(originalBackground);
        gc.setForeground(originalForeground);
        boolean isHighlight = false;
        int x1 = GraphicsUtils.safe(lRectangle.x + lRectangle.width);
        int y = GraphicsUtils.safe(lRectangle.y + lRectangle.height - 3L);
        if (y >= 0x7FFFFFFC) {
            return;
        }
        gc.setForeground(this.gradientColor1);
        gc.drawLine(x0, y, x1, y);
        gc.setForeground(this.gradientColor2);
        gc.drawLine(x0, ++y, x1, y);
        gc.setForeground(this.gradientColor3);
        gc.drawLine(x0, ++y, x1, y);
    }
}

