/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.source;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.markup.IMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupParser2;
import org.eclipse.statet.docmlet.wikitext.core.source.EmbeddingAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.WikitextPartitionNodeScanner;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNodeScan;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNodeScanner;
import org.eclipse.statet.ecommons.text.core.treepartitioner.ITreePartitionNodeType;
import org.eclipse.statet.ecommons.text.core.treepartitioner.WrappedPartitionScan;
import org.eclipse.statet.jcommons.text.core.TextRegion;

public class WikitextWeavePartitionNodeScanner
extends WikitextPartitionNodeScanner {
    private WrappedPartitionScan foreignScan;
    private final List<Embedding> embeddingStack = new ArrayList<Embedding>();

    public WikitextWeavePartitionNodeScanner(IMarkupLanguage markupLanguage) {
        this(markupLanguage, 0);
    }

    public WikitextWeavePartitionNodeScanner(IMarkupLanguage markupLanguage, int markupLanguageMode) {
        super(markupLanguage, markupLanguageMode);
    }

    @Override
    public void execute(ITreePartitionNodeScan scan) throws ITreePartitionNodeScan.BreakException {
        this.foreignScan = new WrappedPartitionScan(scan);
        try {
            super.execute(scan);
        }
        finally {
            this.foreignScan = null;
        }
    }

    @Override
    protected void init() {
        this.embeddingStack.clear();
        super.init();
    }

    @Override
    protected void configure(MarkupParser2 markupParser) {
        super.configure(markupParser);
        markupParser.enable(32);
    }

    protected WrappedPartitionScan getForeignScan() {
        return this.foreignScan;
    }

    @Override
    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        if (attributes instanceof EmbeddingAttributes) {
            Embedding embedding = new Embedding((EmbeddingAttributes)attributes);
            this.embeddingStack.add(embedding);
            this.beginEmbeddingBlock(type, embedding);
            return;
        }
        super.beginBlock(type, attributes);
    }

    protected void beginEmbeddingBlock(DocumentBuilder.BlockType type, Embedding embedding) {
        throw new UnsupportedOperationException("blockType= " + type + ", foreignType= " + embedding.getForeignType());
    }

    @Override
    public void endBlock() {
        int embeddingCount = this.embeddingStack.size();
        if (embeddingCount > 0) {
            Embedding embedding = this.embeddingStack.remove(embeddingCount - 1);
            this.endEmbeddingBlock(this.getNode().getType(), embedding);
            return;
        }
        super.endBlock();
    }

    protected void endEmbeddingBlock(ITreePartitionNodeType type, Embedding embedding) {
        throw new IllegalStateException();
    }

    @Override
    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        if (attributes instanceof EmbeddingAttributes) {
            Embedding embedding = new Embedding((EmbeddingAttributes)attributes);
            this.embeddingStack.add(embedding);
            this.beginEmbeddingSpan(type, embedding);
            return;
        }
        super.beginSpan(type, attributes);
    }

    protected void beginEmbeddingSpan(DocumentBuilder.SpanType type, Embedding embedding) {
        throw new UnsupportedOperationException("spanType= " + type + ", foreignType= " + embedding.getForeignType());
    }

    @Override
    public void endSpan() {
        int embeddingCount = this.embeddingStack.size();
        if (embeddingCount > 0) {
            Embedding embedding = this.embeddingStack.remove(embeddingCount - 1);
            this.endEmbeddingSpan(this.getNode().getType(), embedding);
            return;
        }
        super.endSpan();
    }

    protected void endEmbeddingSpan(ITreePartitionNodeType type, Embedding embedding) {
        throw new IllegalStateException();
    }

    protected class Embedding {
        private final EmbeddingAttributes attributes;
        protected ITreePartitionNode node;
        protected int contentStartOffset;
        protected int contentEndOffset;

        private Embedding(EmbeddingAttributes attributes) {
            this.attributes = attributes;
        }

        public EmbeddingAttributes getAttributes() {
            return this.attributes;
        }

        public String getForeignType() {
            return this.attributes.getForeignType();
        }

        public void init(ITreePartitionNode node) {
            this.node = node;
            TextRegion contentRegion = this.attributes.getContentRegion();
            if (contentRegion != null) {
                this.contentStartOffset = WikitextWeavePartitionNodeScanner.this.getStartOffset() + contentRegion.getStartOffset();
                this.contentEndOffset = WikitextWeavePartitionNodeScanner.this.getStartOffset() + contentRegion.getEndOffset();
            } else {
                this.contentStartOffset = WikitextWeavePartitionNodeScanner.this.getStartOffset();
                this.contentEndOffset = -1;
            }
        }

        public void setContentStartOffset(int offset) {
            this.contentStartOffset = offset;
        }

        public void setContentEndOffset(int offset) {
            this.contentEndOffset = offset;
        }

        public ITreePartitionNode getNode() {
            return this.node;
        }

        public int getContentStartOffset() {
            return this.contentStartOffset;
        }

        public int getContentEndOffset() {
            return this.contentEndOffset;
        }

        public void executeForeignScanner(ITreePartitionNodeScanner scanner) {
            WrappedPartitionScan scan = WikitextWeavePartitionNodeScanner.this.getForeignScan();
            scan.init(this.contentStartOffset, this.contentEndOffset, this.node);
            scanner.execute((ITreePartitionNodeScan)scan);
            scan.exit();
        }
    }
}

