/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.eclipse.statet.ecommons.preferences.AbstractPreferencesModelObject;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class RCodeStyleSettings
extends AbstractPreferencesModelObject
implements IIndentSettings {
    public static final String INDENT_GROUP_ID = "r/r.codestyle/indent";
    public static final String WS_GROUP_ID = "r/r.codestyle/ws";
    public static final String[] ALL_GROUP_IDS = new String[]{"r/r.codestyle/indent", "r/r.codestyle/ws"};
    public static final Preference.IntPref TAB_SIZE_PREF = new Preference.IntPref("org.eclipse.statet.r.core/codestyle/r", "Tab.size");
    public static final Preference.EnumPref<IIndentSettings.IndentationType> INDENT_DEFAULT_TYPE_PREF = new Preference.EnumPref("org.eclipse.statet.r.core/codestyle/r", "Indent.Default.type", IIndentSettings.IndentationType.class);
    public static final Preference.IntPref INDENT_SPACES_COUNT_PREF = new Preference.IntPref("org.eclipse.statet.r.core/codestyle/r", "Indent.Spaces.count");
    public static final Preference.BooleanPref REPLACE_TABS_WITH_SPACES_PREF = new Preference.BooleanPref("org.eclipse.statet.r.core/codestyle/r", "Indent.ReplaceTabs.enable");
    public static final Preference.BooleanPref REPLACE_CONVERSATIVE_PREF = new Preference.BooleanPref("org.eclipse.statet.r.core/codestyle/r", "Indent.ReplaceStrategy");
    public static final Preference.IntPref INDENT_BLOCK_DEPTH_PREF = new Preference.IntPref("org.eclipse.statet.r.core/codestyle/r", "Indent.Block.depth");
    public static final String INDENT_BLOCK_DEPTH_PROP = "indentBlockDepth";
    public static final Preference.IntPref INDENT_GROUP_DEPTH_PREF = new Preference.IntPref("org.eclipse.statet.r.core/codestyle/r", "Indent.Group.depth");
    public static final String INDENT_GROUP_DEPTH_PROP = "indentGroupDepth";
    public static final Preference.IntPref INDENT_WRAPPED_COMMAND_DEPTH_PREF = new Preference.IntPref("org.eclipse.statet.r.core/codestyle/r", "Indent.WrappedCommand.depth");
    public static final String INDENT_WRAPPED_COMMAND_DEPTH_PROP = "indentWrappedCommandDepth";
    public static final Preference.BooleanPref WS_ASSIGN_BEFORE_PREF = new Preference.BooleanPref("org.eclipse.statet.r.core/codestyle/r", "Whitespace.Assign.before");
    public static final String WS_ASSIGN_BEFORE_PROP = "whitespaceAssignBefore";
    public static final Preference.BooleanPref WS_ASSIGN_AFTER_PREF = new Preference.BooleanPref("org.eclipse.statet.r.core/codestyle/r", "Whitespace.Assign.after");
    public static final String WS_ASSIGN_AFTER_PROP = "whitespaceAssignAfter";
    public static final Preference.BooleanPref WS_ARGASSIGN_BEFORE_PREF = new Preference.BooleanPref("org.eclipse.statet.r.core/codestyle/r", "Whitespace.ArgAssign.before");
    public static final String WS_ARGASSIGN_BEFORE_PROP = "whitespaceArgAssignBefore";
    public static final Preference.BooleanPref WS_ARGASSIGN_AFTER_PREF = new Preference.BooleanPref("org.eclipse.statet.r.core/codestyle/r", "Whitespace.ArgAssign.after");
    public static final String WS_ARGASSIGN_AFTER_PROP = "whitespaceArgAssignAfter";
    public static final Preference.BooleanPref WS_OTHEROP_BEFORE_PREF = new Preference.BooleanPref("org.eclipse.statet.r.core/codestyle/r", "Whitespace.OtherOp.before");
    public static final String WS_OTHEROP_BEFORE_PROP = "whitespaceOtherOpBefore";
    public static final Preference.BooleanPref WS_OTHEROP_AFTER_PREF = new Preference.BooleanPref("org.eclipse.statet.r.core/codestyle/r", "Whitespace.OtherOp.after");
    public static final String WS_OTHEROP_AFTER_PROP = "whitespaceOtherOpAfter";
    public static final Preference.BooleanPref NL_FDEF_BODYBLOCK_BEFORE_PREF = new Preference.BooleanPref("org.eclipse.statet.r.core/codestyle/r", "NewLine.FDef.BodyBlock.before");
    public static final String NL_FDEF_BODYBLOCK_BEFORE_PROP = "newlineFDefBodyBlockBefore";
    private int tabSize;
    private IIndentSettings.IndentationType indentDefaultType;
    private int indentSpacesCount;
    private int indentBlockDepth;
    private int indentGroupDepth;
    private int indentWrappedCommandDepth;
    private boolean replaceOtherTabsWithSpaces;
    private boolean replaceConservative;
    private boolean wsAssignBefore;
    private boolean wsAssignAfter;
    private boolean wsArgAssignBefore;
    private boolean wsArgAssignAfter;
    private boolean wsOtherOpBefore;
    private boolean wsOtherOpAfter;
    private boolean nlFDefBodyBlockBefore;

    public RCodeStyleSettings(int mode) {
        if (mode >= 1) {
            this.installLock();
        }
        this.loadDefaults();
        this.resetDirty();
    }

    public String[] getNodeQualifiers() {
        return new String[]{"org.eclipse.statet.r.core/codestyle/r"};
    }

    public void loadDefaults() {
        this.setTabSize(4);
        this.setIndentDefaultType(IIndentSettings.IndentationType.TAB);
        this.setIndentSpacesCount(4);
        this.setIndentBlockDepth(1);
        this.setIndentGroupDepth(1);
        this.setIndentWrappedCommandDepth(2);
        this.setReplaceOtherTabsWithSpaces(false);
        this.setReplaceConservative(false);
        this.setWhitespaceAssignBefore(true);
        this.setWhitespaceAssignAfter(true);
        this.setWhitespaceArgAssignBefore(true);
        this.setWhitespaceArgAssignAfter(true);
        this.setWhitespaceOtherOpBefore(true);
        this.setWhitespaceOtherOpAfter(true);
        this.setNewlineFDefBodyBlockBefore(false);
    }

    public void load(PreferenceAccess prefs) {
        this.setTabSize((Integer)prefs.getPreferenceValue((Preference)TAB_SIZE_PREF));
        this.setIndentDefaultType((IIndentSettings.IndentationType)prefs.getPreferenceValue(INDENT_DEFAULT_TYPE_PREF));
        this.setIndentSpacesCount((Integer)prefs.getPreferenceValue((Preference)INDENT_SPACES_COUNT_PREF));
        this.setReplaceOtherTabsWithSpaces((Boolean)prefs.getPreferenceValue((Preference)REPLACE_TABS_WITH_SPACES_PREF));
        this.setIndentBlockDepth((Integer)prefs.getPreferenceValue((Preference)INDENT_BLOCK_DEPTH_PREF));
        this.setIndentGroupDepth((Integer)prefs.getPreferenceValue((Preference)INDENT_GROUP_DEPTH_PREF));
        this.setIndentWrappedCommandDepth((Integer)prefs.getPreferenceValue((Preference)INDENT_WRAPPED_COMMAND_DEPTH_PREF));
        this.setReplaceConservative((Boolean)prefs.getPreferenceValue((Preference)REPLACE_CONVERSATIVE_PREF));
        this.setWhitespaceAssignBefore((Boolean)prefs.getPreferenceValue((Preference)WS_ASSIGN_BEFORE_PREF));
        this.setWhitespaceAssignAfter((Boolean)prefs.getPreferenceValue((Preference)WS_ASSIGN_AFTER_PREF));
        this.setWhitespaceArgAssignBefore((Boolean)prefs.getPreferenceValue((Preference)WS_ARGASSIGN_BEFORE_PREF));
        this.setWhitespaceArgAssignAfter((Boolean)prefs.getPreferenceValue((Preference)WS_ARGASSIGN_AFTER_PREF));
        this.setWhitespaceOtherOpBefore((Boolean)prefs.getPreferenceValue((Preference)WS_OTHEROP_BEFORE_PREF));
        this.setWhitespaceOtherOpAfter((Boolean)prefs.getPreferenceValue((Preference)WS_OTHEROP_AFTER_PREF));
        this.setNewlineFDefBodyBlockBefore((Boolean)prefs.getPreferenceValue((Preference)NL_FDEF_BODYBLOCK_BEFORE_PREF));
    }

    public void load(RCodeStyleSettings source) {
        Lock writeLock = this.getWriteLock();
        Lock sourceLock = source.getReadLock();
        try {
            sourceLock.lock();
            writeLock.lock();
            this.setTabSize(source.tabSize);
            this.setIndentDefaultType(source.indentDefaultType);
            this.setIndentSpacesCount(source.indentSpacesCount);
            this.setReplaceOtherTabsWithSpaces(source.replaceOtherTabsWithSpaces);
            this.setIndentBlockDepth(source.indentBlockDepth);
            this.setIndentGroupDepth(source.indentGroupDepth);
            this.setIndentWrappedCommandDepth(source.indentWrappedCommandDepth);
            this.setReplaceConservative(source.replaceConservative);
            this.setWhitespaceAssignBefore(source.wsAssignBefore);
            this.setWhitespaceAssignAfter(source.wsAssignAfter);
            this.setWhitespaceArgAssignBefore(source.wsArgAssignBefore);
            this.setWhitespaceArgAssignAfter(source.wsArgAssignAfter);
            this.setWhitespaceOtherOpBefore(source.wsOtherOpBefore);
            this.setWhitespaceOtherOpAfter(source.wsOtherOpAfter);
            this.setNewlineFDefBodyBlockBefore(source.nlFDefBodyBlockBefore);
        }
        finally {
            sourceLock.unlock();
            writeLock.unlock();
        }
    }

    public Map<Preference<?>, Object> deliverToPreferencesMap(Map<Preference<?>, Object> map) {
        map.put((Preference<?>)TAB_SIZE_PREF, this.getTabSize());
        map.put((Preference<?>)INDENT_DEFAULT_TYPE_PREF, this.getIndentDefaultType());
        map.put((Preference<?>)INDENT_SPACES_COUNT_PREF, this.getIndentSpacesCount());
        map.put((Preference<?>)REPLACE_TABS_WITH_SPACES_PREF, this.getReplaceOtherTabsWithSpaces());
        map.put((Preference<?>)INDENT_BLOCK_DEPTH_PREF, this.getIndentBlockDepth());
        map.put((Preference<?>)INDENT_GROUP_DEPTH_PREF, this.getIndentGroupDepth());
        map.put((Preference<?>)INDENT_WRAPPED_COMMAND_DEPTH_PREF, this.getIndentWrappedCommandDepth());
        map.put((Preference<?>)REPLACE_CONVERSATIVE_PREF, this.getReplaceConservative());
        map.put((Preference<?>)WS_ASSIGN_BEFORE_PREF, this.getWhitespaceAssignBefore());
        map.put((Preference<?>)WS_ASSIGN_AFTER_PREF, this.getWhitespaceAssignAfter());
        map.put((Preference<?>)WS_ARGASSIGN_BEFORE_PREF, this.getWhitespaceArgAssignBefore());
        map.put((Preference<?>)WS_ARGASSIGN_AFTER_PREF, this.getWhitespaceArgAssignAfter());
        map.put((Preference<?>)WS_OTHEROP_BEFORE_PREF, this.getWhitespaceOtherOpBefore());
        map.put((Preference<?>)WS_OTHEROP_AFTER_PREF, this.getWhitespaceOtherOpAfter());
        map.put((Preference<?>)NL_FDEF_BODYBLOCK_BEFORE_PREF, this.getNewlineFDefBodyBlockBefore());
        return map;
    }

    public void setTabSize(int size) {
        int oldValue = this.tabSize;
        this.tabSize = size;
        this.firePropertyChange("tabSize", oldValue, size);
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setIndentDefaultType(IIndentSettings.IndentationType type) {
        IIndentSettings.IndentationType oldValue = this.indentDefaultType;
        this.indentDefaultType = type;
        this.firePropertyChange("indentDefaultType", oldValue, type);
    }

    public IIndentSettings.IndentationType getIndentDefaultType() {
        return this.indentDefaultType;
    }

    public void setIndentSpacesCount(int count) {
        int oldValue = this.indentSpacesCount;
        this.indentSpacesCount = count;
        this.firePropertyChange("indentSpacesCount", oldValue, count);
    }

    public int getIndentSpacesCount() {
        return this.indentSpacesCount;
    }

    public final void setIndentBlockDepth(int depth) {
        int oldValue = this.indentBlockDepth;
        this.indentBlockDepth = depth;
        this.firePropertyChange(INDENT_BLOCK_DEPTH_PROP, oldValue, depth);
    }

    public final int getIndentBlockDepth() {
        return this.indentBlockDepth;
    }

    public final void setIndentGroupDepth(int depth) {
        int oldValue = this.indentGroupDepth;
        this.indentGroupDepth = depth;
        this.firePropertyChange(INDENT_GROUP_DEPTH_PROP, oldValue, depth);
    }

    public final int getIndentGroupDepth() {
        return this.indentGroupDepth;
    }

    public final void setIndentWrappedCommandDepth(int depth) {
        int oldValue = this.indentWrappedCommandDepth;
        this.indentWrappedCommandDepth = depth;
        this.firePropertyChange(INDENT_WRAPPED_COMMAND_DEPTH_PROP, oldValue, depth);
    }

    public final int getIndentWrappedCommandDepth() {
        return this.indentWrappedCommandDepth;
    }

    public void setReplaceOtherTabsWithSpaces(boolean enable) {
        boolean oldValue = this.replaceOtherTabsWithSpaces;
        this.replaceOtherTabsWithSpaces = enable;
        this.firePropertyChange("replaceOtherTabsWithSpaces", oldValue, this.getReplaceOtherTabsWithSpaces());
    }

    public boolean getReplaceOtherTabsWithSpaces() {
        return this.replaceOtherTabsWithSpaces;
    }

    public void setReplaceConservative(boolean enable) {
        boolean oldValue = this.replaceConservative;
        this.replaceConservative = enable;
        this.firePropertyChange("replaceConservative", oldValue, enable);
    }

    public boolean getReplaceConservative() {
        return this.replaceConservative;
    }

    public int getLineWidth() {
        return -1;
    }

    public void setWhitespaceAssignBefore(boolean enable) {
        boolean oldValue = this.wsAssignBefore;
        this.wsAssignBefore = enable;
        this.firePropertyChange(WS_ASSIGN_BEFORE_PROP, oldValue, enable);
    }

    public boolean getWhitespaceAssignBefore() {
        return this.wsAssignBefore;
    }

    public void setWhitespaceAssignAfter(boolean enable) {
        boolean oldValue = this.wsAssignAfter;
        this.wsAssignAfter = enable;
        this.firePropertyChange(WS_ASSIGN_AFTER_PROP, oldValue, enable);
    }

    public boolean getWhitespaceAssignAfter() {
        return this.wsAssignAfter;
    }

    public void setWhitespaceArgAssignBefore(boolean enable) {
        boolean oldValue = this.wsArgAssignBefore;
        this.wsArgAssignBefore = enable;
        this.firePropertyChange(WS_ARGASSIGN_BEFORE_PROP, oldValue, enable);
    }

    public boolean getWhitespaceArgAssignBefore() {
        return this.wsArgAssignBefore;
    }

    public void setWhitespaceArgAssignAfter(boolean enable) {
        boolean oldValue = this.wsArgAssignAfter;
        this.wsArgAssignAfter = enable;
        this.firePropertyChange(WS_ARGASSIGN_AFTER_PROP, oldValue, enable);
    }

    public boolean getWhitespaceArgAssignAfter() {
        return this.wsArgAssignAfter;
    }

    public void setWhitespaceOtherOpBefore(boolean enable) {
        boolean oldValue = this.wsOtherOpBefore;
        this.wsOtherOpBefore = enable;
        this.firePropertyChange(WS_OTHEROP_BEFORE_PROP, oldValue, enable);
    }

    public boolean getWhitespaceOtherOpBefore() {
        return this.wsOtherOpBefore;
    }

    public void setWhitespaceOtherOpAfter(boolean enable) {
        boolean oldValue = this.wsOtherOpAfter;
        this.wsOtherOpAfter = enable;
        this.firePropertyChange(WS_OTHEROP_AFTER_PROP, oldValue, enable);
    }

    public boolean getWhitespaceOtherOpAfter() {
        return this.wsOtherOpAfter;
    }

    public void setNewlineFDefBodyBlockBefore(boolean enable) {
        boolean oldValue = this.nlFDefBodyBlockBefore;
        this.nlFDefBodyBlockBefore = enable;
        this.firePropertyChange(NL_FDEF_BODYBLOCK_BEFORE_PROP, oldValue, enable);
    }

    public boolean getNewlineFDefBodyBlockBefore() {
        return this.nlFDefBodyBlockBefore;
    }

    public String getArgAssignString() {
        return this.wsArgAssignBefore ? (this.wsArgAssignAfter ? " = " : " =") : (this.wsArgAssignBefore ? "= " : "=");
    }
}

