/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.editors;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.AbstractMarkOccurrencesProvider;
import org.eclipse.statet.r.core.model.IRModelInfo;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.rsource.ast.DocuComment;
import org.eclipse.statet.r.core.rsource.ast.DocuTag;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAst;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;
import org.eclipse.swt.graphics.Point;

public class RMarkOccurrencesLocator {
    public void run(AbstractMarkOccurrencesProvider.RunData run, ISourceUnitModelInfo info, AstSelection astSelection, ITextSelection orgSelection) throws BadLocationException, BadPartitioningException, UnsupportedOperationException {
        RAstNode node = (RAstNode)astSelection.getCovering();
        if (this.checkForAccess(run, node)) {
            return;
        }
        if (orgSelection != null && info instanceof IRModelInfo) {
            int start = orgSelection.getOffset();
            int stop = start + orgSelection.getLength();
            if (info.getAst().getRoot() instanceof SourceComponent) {
                List comments = ((SourceComponent)info.getAst().getRoot()).getComments();
                block0: for (RAstNode comment : comments) {
                    if (comment.getEndOffset() < start) continue;
                    if (comment.getStartOffset() > stop) break;
                    if (comment.getNodeType() != NodeType.DOCU_AGGREGATION) continue;
                    DocuComment docuComment = (DocuComment)comment;
                    List tags = docuComment.getTags();
                    for (DocuTag tag : tags) {
                        if (tag.getEndOffset() < start) continue;
                        if (tag.getStartOffset() > stop) continue block0;
                        AstSelection selection = AstSelection.search((AstNode)tag, (int)start, (int)stop, (int)3);
                        node = (RAstNode)selection.getCovering();
                        if (!this.checkForAccess(run, node)) continue;
                        return;
                    }
                }
            }
        }
    }

    private boolean checkForAccess(AbstractMarkOccurrencesProvider.RunData run, RAstNode node) throws BadLocationException {
        if (node == null || node.getNodeType() != NodeType.SYMBOL && node.getNodeType() != NodeType.STRING_CONST) {
            return false;
        }
        do {
            ImList attachments = node.getAttachments();
            for (Object attachment : attachments) {
                RElementAccess access;
                Map<Annotation, Position> annotations;
                if (!(attachment instanceof RElementAccess) || (annotations = this.checkDefault(run, access = (RElementAccess)attachment)) == null) continue;
                run.set(annotations);
                return true;
            }
        } while ((node = node.getRParent()) != null);
        return false;
    }

    private Map<Annotation, Position> checkDefault(AbstractMarkOccurrencesProvider.RunData run, RElementAccess access) throws BadLocationException {
        while (access != null) {
            RAstNode nameNode = access.getNameNode();
            if (nameNode == null) {
                return null;
            }
            if (run.accept(new Point(nameNode.getStartOffset(), nameNode.getEndOffset()))) {
                ImList allAccess = access.getAllInUnit(false);
                LinkedHashMap<Annotation, Position> annotations = new LinkedHashMap<Annotation, Position>(allAccess.size());
                for (RElementAccess aAccess : allAccess) {
                    String message = run.doc.get(aAccess.getNode().getStartOffset(), aAccess.getNode().getLength());
                    annotations.put(new Annotation(aAccess.isWriteAccess() ? "org.eclipse.statet.ecommons.text.editorAnnotations.WriteOccurrences" : "org.eclipse.statet.ecommons.text.editorAnnotations.CommonOccurrences", false, message), RAst.getElementNamePosition((RAstNode)aAccess.getNameNode()));
                }
                return annotations;
            }
            access = access.getNextSegment();
        }
        return null;
    }
}

