/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class StatusLineMessageManager {
    private final IStatusLineManager statusLineManager;
    private final Display display;
    private final boolean showIcons;
    private final Handler infoHandler = new Handler();
    private final Handler errorHandler = new Handler();

    public StatusLineMessageManager(IStatusLineManager statusLineManager) {
        this(statusLineManager, true);
    }

    public StatusLineMessageManager(IStatusLineManager statusLineManager, boolean showIcons) {
        this.statusLineManager = statusLineManager;
        this.display = UIAccess.getDisplay();
        this.showIcons = showIcons;
    }

    protected IStatusLineManager getStatusLine() {
        return this.statusLineManager;
    }

    public void setMessage(IStatus status) {
        this.setMessage(status, 30);
    }

    public void setMessage(IStatus status, int timeout) {
        this.getHandler(status).setMessage(status, timeout);
    }

    public void setSelectionMessage(IStatus status) {
        this.infoHandler.setDefaultMessage(status);
    }

    public void clear(IStatus status) {
        this.getHandler(status).clear(status);
    }

    public void clearAll() {
        this.infoHandler.clear();
        this.errorHandler.clear();
    }

    private Handler getHandler(IStatus status) {
        return status.getSeverity() == 4 ? this.errorHandler : this.infoHandler;
    }

    private Image getIcon(int severity) {
        if (!this.showIcons) {
            return null;
        }
        switch (severity) {
            case 1: {
                return JFaceResources.getImage((String)"dialog_messasge_info_image");
            }
            case 2: {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
            case 4: {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
        }
        return null;
    }

    private class Handler
    implements Runnable {
        private IStatus status;
        private IStatus defaultStatus;
        private long timeout;
        private long scheduledTimeout;

        private void doSetMessage(Image icon, String message) {
            if (this == StatusLineMessageManager.this.errorHandler) {
                StatusLineMessageManager.this.getStatusLine().setErrorMessage(icon, message);
            } else {
                StatusLineMessageManager.this.getStatusLine().setMessage(icon, message);
            }
        }

        public void setMessage(IStatus status, int timeout) {
            Image icon = StatusLineMessageManager.this.getIcon(status.getSeverity());
            String message = status.getMessage();
            this.status = status;
            if (timeout > 0) {
                this.timeout = System.nanoTime() / 1000000L + (long)timeout * 1000L;
                if (this.scheduledTimeout > this.timeout) {
                    this.scheduledTimeout = Long.MIN_VALUE;
                    StatusLineMessageManager.this.display.timerExec(-1, (Runnable)this);
                }
                if (this.scheduledTimeout == Long.MIN_VALUE) {
                    this.scheduledTimeout = this.timeout;
                    StatusLineMessageManager.this.display.timerExec(timeout * 1000, (Runnable)this);
                }
            } else {
                this.timeout = Long.MIN_VALUE;
            }
            this.doSetMessage(icon, message);
        }

        public void setDefaultMessage(IStatus status) {
            if (status != null) {
                this.defaultStatus = status;
                this.setMessage(status, 0);
            } else {
                status = this.defaultStatus;
                this.defaultStatus = null;
                this.clear(status);
            }
        }

        public void clear(IStatus status) {
            if (this.status == status) {
                this.clear();
            }
        }

        public void clear() {
            if (this.defaultStatus != null) {
                this.setMessage(this.defaultStatus, 0);
            } else {
                this.status = null;
                this.timeout = Long.MIN_VALUE;
                this.doSetMessage(null, null);
            }
        }

        @Override
        public void run() {
            if (this.timeout != Long.MIN_VALUE) {
                int diff = (int)(this.timeout - System.nanoTime() / 1000000L);
                if (diff > 0) {
                    this.scheduledTimeout = this.timeout;
                    StatusLineMessageManager.this.display.timerExec(diff + 10, (Runnable)this);
                    return;
                }
                this.clear();
            }
            this.scheduledTimeout = Long.MIN_VALUE;
        }
    }
}

