/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import java.util.Collections;
import java.util.List;
import org.eclipse.statet.ecommons.collections.FastList;
import org.eclipse.statet.ecommons.ui.components.IIntValueListener;
import org.eclipse.statet.ecommons.ui.components.IIntValueWidget;
import org.eclipse.statet.ecommons.ui.components.IntValueEvent;
import org.eclipse.statet.internal.ecommons.ui.UIMiscellanyPlugin;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class WaScale
extends Composite
implements IIntValueWidget {
    private static StyleData gDefaultStyleData;
    private static StyleData gFlatStyleData;
    private final int fThisStyle;
    private final StyleData fStyleData;
    private Color fColor1;
    private Color fColor2;
    private Color fRangeColor;
    private Color fRangeFocusColor;
    private Color fTickColor;
    private Rectangle fScaleArea;
    private int fMinimum = 1;
    private int fMaximum = 100;
    private int fIncrement = 1;
    private int fPageIncrement = 10;
    private List<Knob> fKnobs;
    private final FastList<IIntValueListener> fSelectionListeners = new FastList(IIntValueListener.class);
    private boolean fIsActive;
    private int fOpInProgress;
    private int fOpButton;
    private int fOpSavedValue;
    private int fOpOffset;
    private final FocusListener fButtonFocusListener = new FocusListener(){

        public void focusGained(FocusEvent event) {
            Control[] children = WaScale.this.getChildren();
            if (children[0] == event.widget) {
                return;
            }
            ((Button)event.widget).moveAbove(children[0]);
        }

        public void focusLost(FocusEvent event) {
        }
    };
    private final PaintListener fButtonPaintListener = new PaintListener(){

        public void paintControl(PaintEvent event) {
            WaScale.this.paintKnob(event);
        }
    };
    private final Listener fButtonKnobMoveListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 31) {
                switch (event.keyCode) {
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000003: 
                    case 0x1000004: {
                        event.doit = false;
                        return;
                    }
                }
                return;
            }
            WaScale.this.moveKnob(event);
        }
    };

    private static int checkSWTStyle(int style) {
        return style &= 0xFFFFFCFF;
    }

    private static int checkThisStyle(int style, int swtStyle) {
        if (((style &= 0x300) & 0x100) != 0) {
            style &= 0xFFFFFDFF;
        }
        return style |= swtStyle & 0x800000;
    }

    public WaScale(Composite parent, int style) {
        super(parent, WaScale.checkSWTStyle(style));
        this.fThisStyle = WaScale.checkThisStyle(style, this.getStyle());
        this.fStyleData = this.createStyle();
        this.fKnobs = Collections.emptyList();
        this.updateColors();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                WaScale.this.paint(event);
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 26: {
                        WaScale.this.fIsActive = true;
                        WaScale.this.redraw();
                        return;
                    }
                    case 27: {
                        WaScale.this.fIsActive = false;
                        WaScale.this.redraw();
                        return;
                    }
                    case 11: {
                        WaScale.this.updateLayout();
                        return;
                    }
                    case 12: {
                        WaScale.this.onDispose();
                        return;
                    }
                }
            }
        };
        this.addListener(26, listener);
        this.addListener(27, listener);
        this.addListener(11, listener);
        this.addListener(12, listener);
        this.initKnobs();
    }

    private StyleData createStyle() {
        if ((this.fThisStyle & 0x800000) != 0) {
            if (gFlatStyleData == null) {
                gFlatStyleData = new StyleData(this.getDisplay(), 0x800000);
            }
            return gFlatStyleData;
        }
        if (gDefaultStyleData == null) {
            gDefaultStyleData = new StyleData(this.getDisplay(), 0);
        }
        return gDefaultStyleData;
    }

    @Override
    public Control getControl() {
        return this;
    }

    protected void initKnobs() {
        this.setKnobs((List<Knob>)ImCollections.newList((Object[])new Knob[]{new Knob(this.getMinimum()), new Knob(this.getMaximum())}));
    }

    protected void setKnobs(List<Knob> knobs) {
        this.stopOperations(0);
        knobs = ImCollections.toList(knobs);
        if (this.fKnobs != null) {
            int idx = 0;
            while (idx < this.fKnobs.size()) {
                ++idx;
            }
            for (Knob knob : knobs) {
                if (knob.fButton == null) continue;
                knob.fButton.dispose();
                knob.fButton = null;
            }
        }
        Control[] tabList = new Control[knobs.size()];
        boolean enabled = this.getEnabled();
        int idx = 0;
        while (idx < knobs.size()) {
            Knob knob = (Knob)knobs.get(idx);
            ((Knob)knobs.get(idx)).fIdx = idx;
            knob.fButton = this.createKnobControl(knob);
            if (!enabled) {
                knob.fButton.setEnabled(false);
            }
            tabList[idx] = knob.fButton;
            ++idx;
        }
        this.fKnobs = knobs;
        this.setTabList(tabList);
        this.recheckKnobValues();
        this.updateLayout();
    }

    protected List<Knob> getKnobs() {
        return this.fKnobs;
    }

    private void recheckKnobValues() {
        List<Knob> knobs = this.fKnobs;
        int i = 0;
        while (i < knobs.size()) {
            Knob knob = knobs.get(i);
            knob.setValue(0, knob.getValue());
            ++i;
        }
    }

    public int getMinimum() {
        this.checkWidget();
        return this.fMinimum;
    }

    public void setMinimum(int value) {
        this.checkWidget();
        this.fMinimum = value;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.fMaximum;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        this.fMaximum = value;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.fPageIncrement;
    }

    public void setPageIncrement(int increment) {
        this.checkWidget();
        this.fPageIncrement = increment;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.fIncrement;
    }

    public void setIncrement(int increment) {
        this.checkWidget();
        this.fIncrement = increment;
    }

    @Override
    public int getValue(int knobIdx) {
        return this.fKnobs.get(knobIdx).getValue();
    }

    @Override
    public void setValue(int knobIdx, int value) {
        this.fKnobs.get(knobIdx).setValue(0, value);
        this.updateButtonPositions();
        this.redraw();
    }

    @Override
    public void addValueListener(IIntValueListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    @Override
    public void removeValueListener(IIntValueListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    private int fireAboutToChange(int time, int knobIdx, int oldValue, int newValue) {
        if (time == 0) {
            return newValue;
        }
        IIntValueListener[] listeners = (IIntValueListener[])this.fSelectionListeners.toArray();
        IntValueEvent scaleEvent = new IntValueEvent((Control)this, time, knobIdx, oldValue, newValue);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].valueAboutToChange(scaleEvent);
            ++i;
        }
        return scaleEvent.newValue;
    }

    private void fireChanged(int time, int knobIdx, int oldValue, int newValue) {
        if (time == 0) {
            return;
        }
        IIntValueListener[] listeners = (IIntValueListener[])this.fSelectionListeners.toArray();
        IntValueEvent scaleEvent = new IntValueEvent((Control)this, time, knobIdx, oldValue, newValue);
        int i = 0;
        while (i < listeners.length) {
            scaleEvent.newValue = newValue;
            listeners[i].valueChanged(scaleEvent);
            ++i;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getEnabled() == enabled) {
            return;
        }
        List<Knob> knobs = this.fKnobs;
        if (!enabled) {
            int idx = 0;
            while (idx < knobs.size()) {
                Knob knob = knobs.get(idx);
                knob.fSavedEnabled = knob.fButton.getEnabled();
                knob.fButton.setEnabled(false);
                ++idx;
            }
        } else {
            int idx = 0;
            while (idx < knobs.size()) {
                Knob knob = knobs.get(idx);
                knob.fButton.setEnabled(knob.fSavedEnabled);
                ++idx;
            }
        }
    }

    protected int convertClient2Value(int coord) {
        Rectangle scaleArea = this.fScaleArea;
        double tmp = coord - scaleArea.x;
        tmp /= (double)scaleArea.width;
        tmp *= (double)this.fMaximum - (double)this.fMinimum;
        return (int)(tmp += (double)this.fMinimum);
    }

    protected int convertValue2Client(int value) {
        Rectangle scaleArea = this.fScaleArea;
        double tmp = value - this.fMinimum;
        tmp /= (double)this.fMaximum - (double)this.fMinimum;
        int scale = (int)(tmp *= (double)scaleArea.width);
        if (tmp < 0.0) {
            scale = 0;
        }
        if (tmp > (double)scaleArea.width) {
            scale = scaleArea.width;
        }
        return scale + scaleArea.x;
    }

    protected final int getCoord(Event event) {
        return (this.fThisStyle & 0x200) != 0 ? event.y : event.x;
    }

    protected final int getCoord(Point location) {
        return (this.fThisStyle & 0x200) != 0 ? location.y : location.x;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint < 0) {
            wHint = this.fStyleData.defaultWidth;
        } else if (wHint < this.fStyleData.minWidth) {
            wHint = this.fStyleData.minWidth;
        }
        Rectangle trim = this.computeTrim(0, 0, wHint, this.fStyleData.height);
        return new Point(trim.width, trim.height);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.updateColors();
    }

    protected void updateColors() {
        this.fColor1 = this.computeColor1();
        this.fColor2 = this.computeColor2();
        this.fRangeColor = this.computeRangeColor(false);
        this.fRangeFocusColor = this.computeRangeColor(true);
        this.fTickColor = this.computeTickColor();
    }

    protected Color computeColor1() {
        Display display = this.getDisplay();
        Color color = display.getSystemColor(18);
        if (color.equals((Object)this.getBackground())) {
            color = display.getSystemColor(17);
        }
        return color;
    }

    protected Color getColor1() {
        return this.fColor1;
    }

    protected Color computeColor2() {
        Display display = this.getDisplay();
        Color color = display.getSystemColor(19);
        if (color.equals((Object)this.getBackground())) {
            color = display.getSystemColor(20);
        }
        return color;
    }

    protected Color getColor2() {
        return this.fColor2;
    }

    protected Color computeRangeColor(boolean focus) {
        Color color;
        Display display = this.getDisplay();
        if (focus) {
            RGB color1 = this.getBackground().getRGB();
            RGB color2 = display.getSystemColor(26).getRGB();
            RGB rgb = new RGB((color1.red + color2.red) / 2, (color1.green + color2.green) / 2, (color1.blue + color2.blue) / 2);
            color = UIMiscellanyPlugin.getInstance().getColorManager().getColor(rgb);
        } else {
            color = display.getSystemColor(15);
            if (color.equals((Object)this.getBackground())) {
                color = display.getSystemColor(16);
            }
        }
        return color;
    }

    protected Color getRangeColor(boolean focus) {
        return focus ? this.fRangeFocusColor : this.fRangeColor;
    }

    protected Color computeTickColor() {
        return this.computeColor1();
    }

    protected Color getTickColor() {
        return this.fTickColor;
    }

    private Button createKnobControl(Knob knob) {
        Button button = new Button((Composite)this, 8 | this.fThisStyle & 0x800000);
        button.setSize(this.fStyleData.knobWidth, this.fStyleData.knobHeight);
        button.addFocusListener(this.fButtonFocusListener);
        button.addPaintListener(this.fButtonPaintListener);
        button.addListener(31, this.fButtonKnobMoveListener);
        button.addListener(1, this.fButtonKnobMoveListener);
        button.addListener(37, this.fButtonKnobMoveListener);
        button.addListener(3, this.fButtonKnobMoveListener);
        button.addListener(5, this.fButtonKnobMoveListener);
        button.addListener(4, this.fButtonKnobMoveListener);
        button.setData((Object)knob);
        button.setToolTipText(knob.fToolTipText);
        Region shape = new Region((Device)button.getDisplay());
        shape.add(0, 0, this.fStyleData.knobWidth, this.fStyleData.knobHeight - 1);
        button.setRegion(shape);
        return button;
    }

    private void updateLayout() {
        Rectangle scaleArea = this.getClientArea();
        if ((this.fThisStyle & 0x200) != 0) {
            scaleArea.x = scaleArea.y;
            scaleArea.width = scaleArea.height;
        }
        scaleArea.x += this.fStyleData.knobScaleOffset;
        scaleArea.width -= 2 * this.fStyleData.knobScaleOffset;
        this.fScaleArea = scaleArea;
        this.updateButtonPositions();
    }

    private void updateButtonPositions() {
        List<Knob> knobs = this.fKnobs;
        if ((this.fThisStyle & 0x200) != 0) {
            int idx = 0;
            while (idx < knobs.size()) {
                Knob knob = knobs.get(idx);
                int y = this.convertValue2Client(knob.getValue()) - this.fStyleData.knobScaleOffset;
                knob.fButton.setLocation(0, y);
                ++idx;
            }
        } else {
            int idx = 0;
            while (idx < knobs.size()) {
                Knob knob = knobs.get(idx);
                int x = this.convertValue2Client(knob.getValue()) - this.fStyleData.knobScaleOffset;
                knob.fButton.setLocation(x, 0);
                ++idx;
            }
        }
    }

    private void paint(PaintEvent e) {
        Rectangle clientArea = this.getClientArea();
        if (clientArea.width == 0 || clientArea.height == 0) {
            return;
        }
        GC gc = e.gc;
        gc.setBackground(this.getBackground());
        gc.fillRectangle(clientArea);
        if (clientArea.height < this.fStyleData.height || clientArea.width < this.fStyleData.knobWidth) {
            return;
        }
        gc.setLineWidth(1);
        gc.setForeground(this.getColor1());
        int x = clientArea.x + this.fStyleData.linePadding;
        int y = clientArea.y + this.fStyleData.knobHeight - 1;
        int width = clientArea.width - 2 * this.fStyleData.linePadding;
        gc.drawLine(x, y, x + width, y);
        gc.drawPoint(x, ++y);
        gc.setForeground(this.getColor2());
        gc.drawPoint(x + width, y);
        gc.drawLine(x, ++y, x + width, y);
        ++y;
        Rectangle scaleArea = this.fScaleArea;
        width = scaleArea.width;
        y += 3;
        gc.setForeground(this.getTickColor());
        int count = 4;
        int i = 0;
        while (i <= 4) {
            x = scaleArea.x + width * i / 4;
            gc.drawLine(x, y, x, y + 3);
            ++i;
        }
        y = clientArea.y + this.fStyleData.knobHeight;
        this.paintRanges(gc, y);
        gc.setForeground(this.getDisplay().getSystemColor(2));
        i = 0;
        while (i < this.fKnobs.size()) {
            x = this.convertValue2Client(this.fKnobs.get(i).getValue());
            gc.drawPoint(x, y);
            ++i;
        }
    }

    protected void stopOperations(int time) {
        if (this.fOpInProgress == 0) {
            return;
        }
        this.fOpInProgress = 0;
        this.fKnobs.get(this.fOpButton).setValue(time, this.fOpSavedValue);
        this.updateButtonPositions();
        this.redraw();
    }

    protected boolean isInOperation() {
        return false;
    }

    private void paintKnob(PaintEvent e) {
        GC gc = e.gc;
        gc.drawImage(this.fStyleData.knobLine, this.fStyleData.knobScaleOffset - 1, (1 + this.fStyleData.knobHeight) / 2);
    }

    protected void paintRanges(GC gc, int y) {
        if (this.fKnobs.size() == 2) {
            Knob knob0 = this.fKnobs.get(0);
            Knob knob1 = this.fKnobs.get(1);
            gc.setForeground(this.getRangeColor(this.fIsActive && (knob0.fButton.isFocusControl() || knob1.fButton.isFocusControl())));
            gc.drawLine(this.convertValue2Client(this.fKnobs.get(0).getValue()), y, this.convertValue2Client(this.fKnobs.get(1).getValue()), y);
        }
    }

    private void moveKnob(Event event) {
        int newValue;
        Knob knob = (Knob)event.widget.getData();
        block0 : switch (event.type) {
            case 1: {
                this.stopOperations(event.time);
                switch (event.keyCode) {
                    case 0x1000003: {
                        newValue = knob.getValue() - this.fIncrement;
                        break block0;
                    }
                    case 0x1000002: {
                        if ((this.fThisStyle & 0x200) != 0) {
                            newValue = knob.getValue() + this.fIncrement;
                            break block0;
                        }
                        newValue = knob.getValue() - this.fIncrement;
                        break block0;
                    }
                    case 0x1000004: {
                        newValue = knob.getValue() + this.fIncrement;
                        break block0;
                    }
                    case 0x1000001: {
                        if ((this.fThisStyle & 0x200) != 0) {
                            newValue = knob.getValue() - this.fIncrement;
                            break block0;
                        }
                        newValue = knob.getValue() + this.fIncrement;
                        break block0;
                    }
                    case 0x1000006: {
                        newValue = knob.getValue() - this.fPageIncrement;
                        break block0;
                    }
                    case 0x1000005: {
                        newValue = knob.getValue() + this.fPageIncrement;
                        break block0;
                    }
                    case 0x1000007: {
                        newValue = this.fMinimum;
                        break block0;
                    }
                    case 0x1000008: {
                        newValue = this.fMaximum;
                        break block0;
                    }
                }
                return;
            }
            case 37: {
                if (this.isInOperation()) {
                    return;
                }
                newValue = knob.getValue() + this.fIncrement * event.count;
                break;
            }
            case 3: {
                this.stopOperations(event.time);
                this.fOpInProgress = 1;
                this.fOpButton = knob.getIdx();
                this.fOpSavedValue = knob.getValue();
                this.fOpOffset = this.getCoord(event) - this.fStyleData.knobScaleOffset;
                return;
            }
            case 5: {
                if (this.fOpInProgress != 1) {
                    return;
                }
                newValue = this.convertClient2Value(this.getCoord(knob.fButton.getLocation()) + this.getCoord(event) - this.fOpOffset);
                break;
            }
            case 4: {
                if (this.fOpInProgress != 1) {
                    return;
                }
                this.fOpInProgress = 0;
                return;
            }
            default: {
                return;
            }
        }
        event.doit = false;
        knob.setValue(event.time, newValue);
        this.updateButtonPositions();
        this.redraw();
    }

    protected void onDispose() {
    }

    protected class Knob {
        private int fIdx;
        private int fValue;
        private Button fButton;
        private String fToolTipText;
        private boolean fSavedEnabled = true;

        public Knob(int value) {
            this.fValue = value;
        }

        public void setToolTipText(String text) {
            this.fToolTipText = text;
            if (this.fButton != null) {
                this.fButton.setToolTipText(text);
            }
        }

        public final int getIdx() {
            return this.fIdx;
        }

        public final int getValue() {
            return this.fValue;
        }

        protected int checkValue(int value) {
            if (value < WaScale.this.fMinimum) {
                value = WaScale.this.fMinimum;
            } else if (value > WaScale.this.fMaximum) {
                value = WaScale.this.fMaximum;
            }
            return value;
        }

        public boolean setValue(int time, int value) {
            int oldValue = this.fValue;
            value = this.checkValue(value);
            value = WaScale.this.fireAboutToChange(time, this.fIdx, oldValue, value);
            if (oldValue == (value = this.checkValue(value))) {
                return false;
            }
            this.fValue = value;
            WaScale.this.fireChanged(time, this.fIdx, oldValue, this.fValue);
            return true;
        }
    }

    protected class OrderedKnob
    extends Knob {
        public OrderedKnob(int value) {
            super(value);
        }

        public OrderedKnob(int value, String toolTipText) {
            super(value);
            this.setToolTipText(toolTipText);
        }

        protected int getMinDistance() {
            return 1;
        }

        @Override
        protected int checkValue(int value) {
            int bound;
            List<Knob> knobs = WaScale.this.getKnobs();
            int idx = this.getIdx();
            int distance = this.getMinDistance();
            if (idx + 1 < knobs.size() && (bound = knobs.get(idx + 1).getValue()) - value < distance) {
                value = bound - distance;
            }
            if (idx > 0 && value - (bound = knobs.get(idx - 1).getValue()) < distance) {
                value = bound + distance;
            }
            return super.checkValue(value);
        }
    }

    private static class StyleData {
        final int minWidth;
        final int defaultWidth;
        final int height;
        final int linePadding = 1;
        final int knobHeight;
        final int knobWidth;
        final int knobScaleOffset;
        final Image knobLine;

        public StyleData(Display display, int style) {
            Shell shell = new Shell(display, 8);
            GC gc = null;
            try {
                shell.setSize(200, 200);
                shell.setFont(display.getSystemFont());
                gc = new GC((Drawable)shell);
                int width = gc.getFontMetrics().getAverageCharWidth() * 2;
                if (width % 2 == 0) {
                    ++width;
                }
                if (width < 11) {
                    width = 11;
                }
                Button button = new Button((Composite)shell, 8 | style);
                Point size = button.computeSize(width, (int)((double)width * 1.333));
                width = size.x;
                if (width % 2 == 0) {
                    ++width;
                }
                this.knobWidth = width;
                this.knobHeight = size.y;
                this.knobScaleOffset = this.knobWidth / 2;
                this.height = this.knobHeight + 9;
                this.minWidth = 4 * this.knobWidth + 2 * this.knobScaleOffset;
                this.defaultWidth = 100 + 2 * this.knobScaleOffset;
                this.knobLine = this.createKnobLine(display, this.knobHeight / 2);
            }
            finally {
                if (gc != null) {
                    gc.dispose();
                }
                shell.dispose();
            }
        }

        private Image createKnobLine(Display display, int height) {
            Image image = new Image((Device)display, 3, height);
            GC gc = new GC((Drawable)image);
            gc.setForeground(display.getSystemColor(18));
            gc.drawLine(0, 0, 0, height);
            gc.drawPoint(1, 0);
            gc.drawLine(2, 0, 2, height);
            gc.setForeground(display.getSystemColor(2));
            gc.drawLine(1, 1, 1, height);
            gc.dispose();
            ImageData imageData = image.getImageData();
            image.dispose();
            byte[] alphaData = new byte[3 * imageData.height];
            int alpha = 127;
            int line = 0;
            int i = 0;
            while (line++ < 4) {
                alphaData[i++] = alpha;
                alphaData[i++] = alpha;
                alphaData[i++] = alpha;
                alpha = (byte)(alpha + 16);
            }
            while (line++ < imageData.height) {
                alphaData[i++] = alpha;
                alphaData[i++] = alpha;
                alphaData[i++] = alpha;
            }
            imageData.alphaData = alphaData;
            return new Image((Device)display, imageData);
        }
    }
}

