/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.config;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ObservableEvent;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.databinding.core.AggregateValidationStatus;
import org.eclipse.statet.ecommons.databinding.core.DataStatus;
import org.eclipse.statet.ecommons.databinding.core.util.DirtyTracker;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class LaunchConfigTabWithDbc
extends AbstractLaunchConfigurationTab {
    private DataBindingContext dbc;
    private AggregateValidationStatus aggregateStatus;
    private IStatus currentStatus;
    private boolean initializing;

    protected LaunchConfigTabWithDbc() {
    }

    public String getValidationErrorAttr() {
        return String.valueOf(this.getId()) + "/validation.hasError";
    }

    protected void updateDialogState() {
        if (!this.isInitializing()) {
            switch (DataStatus.getInfoSeverity((IStatus)this.currentStatus)) {
                case 3: 
                case 4: {
                    this.setMessage(null);
                    this.setWarningMessage(null);
                    this.setErrorMessage(this.currentStatus.getMessage());
                    break;
                }
                case 2: {
                    this.setMessage(null);
                    this.setWarningMessage(this.currentStatus.getMessage());
                    this.setErrorMessage(null);
                    break;
                }
                case 1: {
                    this.setMessage(this.currentStatus.getMessage());
                    this.setWarningMessage(null);
                    this.setErrorMessage(null);
                    break;
                }
                default: {
                    this.setMessage(null);
                    this.setWarningMessage(null);
                    this.setErrorMessage(null);
                }
            }
            this.updateLaunchConfigurationDialog();
        }
    }

    protected Realm getRealm() {
        return Realm.getDefault();
    }

    protected void initBindings() {
        this.dbc = new DataBindingContext(this.getRealm());
        this.addBindings(this.dbc);
        this.aggregateStatus = new AggregateValidationStatus(this.dbc, 3);
        this.aggregateStatus.addValueChangeListener(event -> {
            this.currentStatus = (IStatus)event.diff.getNewValue();
            this.updateDialogState();
        });
        this.currentStatus = ValidationStatus.ok();
        new DirtyTracker(this.dbc){

            public void handleChange(ObservableEvent event) {
                if (!this.isDirty()) {
                    LaunchConfigTabWithDbc.this.currentStatus = (IStatus)LaunchConfigTabWithDbc.this.aggregateStatus.getValue();
                    LaunchConfigTabWithDbc.this.setDirty(true);
                    LaunchConfigTabWithDbc.this.updateDialogState();
                }
            }
        };
        this.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LaunchConfigTabWithDbc.this.disposeBindings();
            }
        });
    }

    private void disposeBindings() {
        if (this.aggregateStatus != null) {
            this.aggregateStatus.dispose();
            this.aggregateStatus = null;
        }
        if (this.dbc != null) {
            this.dbc.dispose();
            this.dbc = null;
        }
    }

    protected DataBindingContext getDataBindingContext() {
        return this.dbc;
    }

    @Deprecated
    protected void addBindings(DataBindingContext dbc, Realm realm) {
    }

    protected void addBindings(DataBindingContext dbc) {
        this.addBindings(dbc, dbc.getValidationRealm());
    }

    public void dispose() {
        super.dispose();
        this.disposeBindings();
    }

    protected void logReadingError(CoreException e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.ui", 0, NLS.bind((String)"An error occurred while reading launch configuration (name: ''{0}'', id: ''{1}'')", (Object)this.getName(), (Object)this.getId()), (Throwable)e));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initializing = true;
        this.doInitialize(configuration);
        this.setDirty(false);
        for (Object obj : this.dbc.getBindings()) {
            ((Binding)obj).validateTargetToModel();
        }
        this.currentStatus = (IStatus)this.aggregateStatus.getValue();
        this.initializing = false;
        this.updateDialogState();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.updateDialogState();
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (!this.canSave()) {
            configuration.setAttribute(this.getValidationErrorAttr(), true);
            return;
        }
        configuration.removeAttribute(this.getValidationErrorAttr());
        if (this.isDirty()) {
            this.doSave(configuration);
            this.setDirty(false);
        }
    }

    protected final boolean isInitializing() {
        return this.initializing;
    }

    protected abstract void doInitialize(ILaunchConfiguration var1);

    protected abstract void doSave(ILaunchConfigurationWorkingCopy var1);

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return DataStatus.getInfoSeverity((IStatus)this.currentStatus) <= 2;
    }

    public boolean canSave() {
        return this.currentStatus.getSeverity() < 4;
    }
}

