/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.services.util.dataaccess;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.rj.services.util.dataaccess.RDataAssignment;
import org.eclipse.statet.rj.services.util.dataaccess.RDataSubset;

public class LazyRStore<V> {
    public static final int DEFAULT_FRAGMENT_SIZE = 2500;
    public static final int FORCE_SYNC = 1;
    private final long columnCount;
    private long rowCount;
    private final int maxFragmentCount;
    private Fragment<V>[] fragments;
    private int currentFragmentCount = 0;
    private final Fragment<V> topFragment = new Fragment(-1L, 0L, 0L, 0L, 0L);
    private final Fragment<V> bottomFragment = new Fragment(-1L, 0L, 0L, 0L, 0L);
    private final int fragmentRowCount;
    private final int fragmentColCount;
    private final long fragmentCountInRow;
    private final List<RDataAssignment> assignments = new ArrayList<RDataAssignment>();
    private int scheduledCount;
    private Fragment<V> scheduleNext;
    private Updater<V> updater;

    public LazyRStore(long rowCount, long columnCount, int maxFragmentCount, Updater<V> updater) {
        this(rowCount, columnCount, maxFragmentCount, 2500, updater);
    }

    public LazyRStore(long rowCount, long columnCount, int maxFragmentCount, int fragmentSize, Updater<V> updater) {
        this.columnCount = columnCount;
        this.maxFragmentCount = maxFragmentCount;
        this.fragmentColCount = (int)Math.min(columnCount, 25L);
        this.fragmentCountInRow = (columnCount - 1L) / (long)this.fragmentColCount + 1L;
        this.fragmentRowCount = fragmentSize / this.fragmentColCount;
        this.updater = updater;
        this.init(rowCount);
    }

    public LazyRStore(long rowCount, long columnCount, int maxFragmentCount, int fragmentRowCount, int fragmentColCount, Updater<V> updater) {
        this.columnCount = columnCount;
        this.maxFragmentCount = maxFragmentCount;
        this.fragmentColCount = fragmentColCount;
        this.fragmentCountInRow = (columnCount - 1L) / (long)fragmentColCount + 1L;
        this.fragmentRowCount = fragmentRowCount;
        this.updater = updater;
        this.init(rowCount);
    }

    private void init(long rowCount) {
        this.fragments = new Fragment[Math.min(16, this.maxFragmentCount)];
        this.clear(rowCount);
    }

    private long getNumber(long rowIdx, long columnIdx) {
        return rowIdx / (long)this.fragmentRowCount * this.fragmentCountInRow + columnIdx / (long)this.fragmentColCount;
    }

    public Fragment<V> getFragment(long rowIdx, long columnIdx, int flags, ProgressMonitor m) {
        if (rowIdx >= this.rowCount) {
            return null;
        }
        long number = this.getNumber(rowIdx, columnIdx);
        Fragment<V> fragment = this.getFragment(number, true);
        if ((((Fragment)fragment).state & 2) != 0) {
            return fragment;
        }
        boolean scheduleUpdate = this.scheduledCount == 0;
        this.scheduleNext = this.topFragment;
        if ((((Fragment)fragment).state & 1) == 0) {
            ((Fragment)fragment).state = (byte)1;
            ++this.scheduledCount;
        }
        if (scheduleUpdate || (flags & 1) != 0) {
            this.updater.scheduleUpdate(this, null, fragment, flags, m);
            if ((((Fragment)fragment).state & 2) != 0) {
                return fragment;
            }
        }
        return null;
    }

    public void setFragment(long rowIdx, long columnIdx, V rObject) {
        long number = this.getNumber(rowIdx, columnIdx);
        Fragment<V> fragment = this.getFragment(number, true);
        this.updateFragment(fragment, rObject);
    }

    public Fragment<V> getLoadedFragment(long rowIdx, long columnIdx) {
        if (rowIdx >= this.rowCount) {
            return null;
        }
        long number = this.getNumber(rowIdx, columnIdx);
        Fragment<V> fragment = this.getFragment(number, false);
        if ((((Fragment)fragment).state & 2) != 0) {
            return fragment;
        }
        return null;
    }

    public Fragment<V> getLoadedFragmentAny() {
        Fragment fragment = this.topFragment;
        while (fragment != null) {
            if ((fragment.state & 2) != 0) {
                return fragment;
            }
            fragment = fragment.older;
        }
        return null;
    }

    public void set(RDataAssignment assignment, int flags, ProgressMonitor m) {
        Fragment<V> fragment = this.clear(assignment);
        this.assignments.add(assignment);
        boolean scheduleUpdate = this.scheduledCount == 0;
        ++this.scheduledCount;
        if (fragment != null) {
            ((Fragment)fragment).state = (byte)1;
            ++this.scheduledCount;
        }
        if (scheduleUpdate) {
            this.updater.scheduleUpdate(this, assignment, fragment, flags, m);
        }
    }

    public Fragment<V> clear(RDataSubset subset) {
        Fragment<V> firstFragment = null;
        long columnBeginIdx = subset.getColumnBeginIdx() / (long)this.fragmentColCount * (long)this.fragmentColCount;
        while (columnBeginIdx < subset.getColumnEndIdx()) {
            long rowBeginIdx = subset.getRowBeginIdx() / (long)this.fragmentRowCount * (long)this.fragmentRowCount;
            while (rowBeginIdx < subset.getRowEndIdx()) {
                long number = this.getNumber(rowBeginIdx, columnBeginIdx);
                int idx = this.indexOf(number);
                if (idx >= 0) {
                    Fragment<V> fragment = this.clearFragment(idx);
                    if (firstFragment == null) {
                        firstFragment = fragment;
                    }
                }
                rowBeginIdx = Math.min(rowBeginIdx + (long)this.fragmentRowCount, this.rowCount);
            }
            columnBeginIdx = Math.min(columnBeginIdx + (long)this.fragmentColCount, this.columnCount);
        }
        return firstFragment;
    }

    private int indexOf(long number) {
        Fragment<V>[] array = this.fragments;
        int low = 0;
        int high = this.currentFragmentCount;
        while (low <= high) {
            int mid = low + high >> 1;
            Fragment<V> fragment = array[mid];
            if (((Fragment)fragment).number < number) {
                low = mid + 1;
                continue;
            }
            if (((Fragment)fragment).number > number) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private Fragment<V> getFragment(long number, boolean create) {
        if (((Fragment)this.topFragment).older.number == number) {
            return ((Fragment)this.topFragment).older;
        }
        Fragment<V>[] array = this.fragments;
        int low = 0;
        int high = this.currentFragmentCount - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Fragment<V> fragment = array[mid];
            if (((Fragment)fragment).number < number) {
                low = mid + 1;
                continue;
            }
            if (((Fragment)fragment).number > number) {
                high = mid - 1;
                continue;
            }
            ((Fragment)fragment).newer.older = ((Fragment)fragment).older;
            ((Fragment)fragment).older.newer = ((Fragment)fragment).newer;
            ((Fragment)fragment).newer = (Fragment)this.topFragment;
            ((Fragment)fragment).older = ((Fragment)this.topFragment).older;
            ((Fragment)this.topFragment).older.newer = (Fragment)fragment;
            ((Fragment)this.topFragment).older = (Fragment)fragment;
            return fragment;
        }
        if (!create) {
            return null;
        }
        Fragment<V> fragment = this.createFragment(number);
        if (this.currentFragmentCount >= this.maxFragmentCount) {
            this.removeOldestFragment();
        }
        if (array.length == this.currentFragmentCount) {
            this.fragments = new Fragment[Math.min(this.currentFragmentCount * 2, this.maxFragmentCount)];
            System.arraycopy(array, 0, this.fragments, 0, low);
        }
        System.arraycopy(array, low, this.fragments, low + 1, this.currentFragmentCount - low);
        this.fragments[low] = fragment;
        ++this.currentFragmentCount;
        ((Fragment)fragment).newer = (Fragment)this.topFragment;
        ((Fragment)fragment).older = ((Fragment)this.topFragment).older;
        ((Fragment)this.topFragment).older.newer = (Fragment)fragment;
        ((Fragment)this.topFragment).older = (Fragment)fragment;
        return fragment;
    }

    private Fragment<V> createFragment(long number) {
        long rowBeginIdx = number / this.fragmentCountInRow * (long)this.fragmentRowCount;
        long rowEndIdx = Math.min(rowBeginIdx + (long)this.fragmentRowCount, this.rowCount);
        long columnBeginIdx = number % this.fragmentCountInRow * (long)this.fragmentColCount;
        long columnEndIdx = Math.min(columnBeginIdx + (long)this.fragmentColCount, this.columnCount);
        return new Fragment(number, rowBeginIdx, rowEndIdx - rowBeginIdx, columnBeginIdx, columnEndIdx - columnBeginIdx);
    }

    private Fragment<V> clearFragment(int idx) {
        Fragment<V> oldFragment = this.fragments[idx];
        Fragment newFragment = new Fragment(((Fragment)oldFragment).number, oldFragment.getRowBeginIdx(), oldFragment.getRowCount(), oldFragment.getColumnBeginIdx(), oldFragment.getColumnCount());
        if (((Fragment)oldFragment).newer != null) {
            newFragment.newer = ((Fragment)oldFragment).newer;
            newFragment.newer.older = newFragment;
        }
        if (((Fragment)oldFragment).older != null) {
            newFragment.older = ((Fragment)oldFragment).older;
            newFragment.older.newer = newFragment;
        }
        this.fragments[idx] = newFragment;
        return this.fragments[idx];
    }

    private void removeOldestFragment() {
        Fragment fragment = ((Fragment)this.bottomFragment).newer;
        if ((fragment.state & 1) != 0) {
            Fragment fragment2 = fragment;
            fragment2.state = (byte)(fragment2.state & 0xFFFFFFFE);
            --this.scheduledCount;
        }
        if (this.scheduleNext == fragment) {
            this.scheduleNext = fragment.older;
        }
        int idx = this.indexOf(fragment.number);
        --this.currentFragmentCount;
        System.arraycopy(this.fragments, idx + 1, this.fragments, idx, this.currentFragmentCount - idx);
        this.fragments[this.currentFragmentCount] = null;
        fragment.newer.older = (Fragment)this.bottomFragment;
        ((Fragment)this.bottomFragment).newer = fragment.newer;
        fragment.newer = null;
        fragment.older = null;
    }

    public void clear(long rowCount) {
        Fragment<V>[] array = this.fragments;
        int i = 0;
        while (i < this.currentFragmentCount) {
            Fragment<V> fragment = array[i];
            ((Fragment)fragment).state = (byte)(((Fragment)fragment).state & 0xFFFFFFFE);
            array[i] = null;
            ++i;
        }
        this.currentFragmentCount = 0;
        ((Fragment)this.topFragment).older = (Fragment)this.bottomFragment;
        ((Fragment)this.bottomFragment).newer = (Fragment)this.topFragment;
        this.scheduledCount = 0;
        this.scheduleNext = this.topFragment;
        if (rowCount >= 0L) {
            this.rowCount = rowCount;
        }
    }

    public Fragment<V>[] getScheduledFragments() {
        Fragment[] scheduledFragments = new Fragment[this.scheduledCount];
        Fragment fragment = ((Fragment)this.topFragment).older;
        int i = 0;
        while (i < this.scheduledCount) {
            if ((fragment.state & 1) != 0) {
                scheduledFragments[i++] = fragment;
            }
            fragment = fragment.older;
        }
        return scheduledFragments;
    }

    public Fragment<V> getNextScheduledFragment() {
        if (this.scheduledCount == 0) {
            return null;
        }
        Fragment fragment = ((Fragment)this.scheduleNext).older;
        while (true) {
            if ((fragment.state & 1) != 0) {
                this.scheduleNext = fragment;
                return fragment;
            }
            fragment = fragment.older;
        }
    }

    public void updateAssignment(RDataAssignment assignment, Status status) {
        if (this.assignments.remove(assignment)) {
            --this.scheduledCount;
        }
    }

    public void updateFragment(Fragment<V> fragment, V rObject) {
        if ((((Fragment)fragment).state & 2) != 0) {
            throw new IllegalStateException();
        }
        ((Fragment)fragment).rObject = rObject;
        if ((((Fragment)fragment).state & 1) != 0) {
            --this.scheduledCount;
        }
        ((Fragment)fragment).state = (byte)2;
    }

    public static final class Fragment<W>
    extends RDataSubset {
        private static final byte SCHEDULED = 1;
        private static final byte SET = 2;
        private final long number;
        private W rObject;
        private Fragment<W> newer;
        private Fragment<W> older;
        private byte state;

        Fragment(long number, long rowBeginIdx, long rowCount, long columnBeginIdx, long columnCount) {
            super(rowBeginIdx, rowCount, columnBeginIdx, columnCount);
            this.number = number;
        }

        public W getRObject() {
            return this.rObject;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("LazyRStore$Fragment ");
            sb.append(this.number);
            sb.append("\n\trows= ").append(this.getRowBeginIdx()).append("...").append(this.getRowEndIdx());
            sb.append("\n\tcolumns= ").append(this.getColumnBeginIdx()).append("...").append(this.getColumnEndIdx());
            return sb.toString();
        }
    }

    public static interface Updater<T> {
        public void scheduleUpdate(LazyRStore<T> var1, RDataAssignment var2, Fragment<T> var3, int var4, ProgressMonitor var5);
    }
}

